/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.views.vehicule.DialogCreationVehicule;
import transpo.system.util.Fonctions;

public class VehicleImport {
    private File[] sourcePath = null;
    private BddTransport database = null;
    private byte[] fileBuffer = null;

    public VehicleImport(File[] path) {
        this.sourcePath = path;
    }

    public boolean run() {
        TimsLogger.debug("nb de fichier " + this.sourcePath.length);
        if (this.sourcePath == null) {
            return false;
        }
        int x = 0;
        while (x < this.sourcePath.length) {
            String fileName = this.sourcePath[x].getName();
            String firstName = fileName.substring(0, fileName.indexOf("  "));
            String lastName = fileName.substring(fileName.indexOf("  "), fileName.lastIndexOf("  "));
            String version = fileName.substring(fileName.lastIndexOf("  "));
            TimsLogger.debug("import de " + lastName + " " + firstName);
            this.loadVehicle(this.sourcePath[x]);
            ++x;
        }
        return true;
    }

    private boolean loadVehicle(File toRead) {
        this.readFile(toRead);
        Vehicule vehicle = this.readVehicule();
        if (vehicle == null) {
            TimsLogger.debug("conducteur impossible \u00e0 trouver");
            return false;
        }
        Vector<UevActivity> activityList = this.readActivity();
        Vector<UevEventsFaults> eventsfaultsList = this.readEventsFaults();
        Vector<UevSpeed> speedList = this.readSpeed();
        Vector<VehicleUsed> ioList = this.readInputOutput();
        Vector<UevDownload> downloadList = this.readDownload();
        DialogCreationVehicule creation = new DialogCreationVehicule((Frame)MainFrameTransport.getInstance(), vehicle);
        creation.setVisible(true);
        if (creation.enregistrement) {
            vehicle.loadByImmat(vehicle.getRegistrationNumber(), false);
        }
        int cle = vehicle.getCleVehicule();
        for (UevActivity uevActivity : activityList) {
            uevActivity.setCleVehicule(cle);
            uevActivity.insert();
        }
        for (UevEventsFaults uevEventsFaults : eventsfaultsList) {
            uevEventsFaults.setVehicleId(cle);
            uevEventsFaults.insert();
        }
        for (UevSpeed uevSpeed : speedList) {
            uevSpeed.setCleVehicule(cle);
            uevSpeed.insert();
        }
        for (VehicleUsed vehicleUsed : ioList) {
            vehicleUsed.setCleVehicule(cle);
            vehicleUsed.insert("vehicle_used");
        }
        for (UevDownload uevDownload : downloadList) {
            uevDownload.insert();
        }
        return true;
    }

    public Vehicule readVehicule() {
        Vehicule tmp = new Vehicule();
        int offset = this.getOffset(48);
        if (offset == -1) {
            TimsLogger.warn("Error offset vehicle unknown");
            return null;
        }
        tmp.read(this.fileBuffer, offset);
        return tmp;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<UevActivity> readActivity() {
        returnList = new Vector<UevActivity>();
        offset = this.getOffset(49);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF UevActivity ");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new UevActivity();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 49)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#VehicleImport.readActivity#size of UevActivity = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<UevEventsFaults> readEventsFaults() {
        returnList = new Vector<UevEventsFaults>();
        offset = this.getOffset(51);
        if (offset != -1) ** GOTO lbl11
        TimsLogger.warn("no data for EF UevEvents ");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new UevEventsFaults();
            returnList.add(tmp);
            offset += one.length + 3;
lbl11:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 51)
        }
lbl12:
        // 1 sources

        TimsLogger.debug("#VehicleImport.readEvents#size of UevEvents = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<UevSpeed> readSpeed() {
        returnList = new Vector<UevSpeed>();
        offset = this.getOffset(53);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF UevSpeed ");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new UevSpeed();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 53)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#VehicleImport.readSpeed#size of UevSpeed = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<VehicleUsed> readInputOutput() {
        returnList = new Vector<VehicleUsed>();
        offset = this.getOffset(52);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF VehicleUsed ");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new VehicleUsed();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 52)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#VehicleImport.readInputOutput#size of VehicleUsed = " + returnList.size());
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<UevDownload> readDownload() {
        returnList = new Vector<UevDownload>();
        offset = this.getOffset(54);
        if (offset != -1) ** GOTO lbl12
        TimsLogger.warn("no data for EF UevDownload ");
        return returnList;
lbl-1000:
        // 1 sources

        {
            one = this.getObjectByte(offset);
            tmp = new UevDownload();
            tmp.read(one);
            returnList.add(tmp);
            offset += one.length + 3;
lbl12:
            // 2 sources

            ** while (offset < this.fileBuffer.length && Fonctions.bytesToInt((byte[])this.fileBuffer, (int)offset, (int)1) == 54)
        }
lbl13:
        // 1 sources

        TimsLogger.debug("#VehicleImport.readDownload#size of UevDownload = " + returnList.size());
        return returnList;
    }

    public void readFile(File toRead) {
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            this.fileBuffer = new byte[taille];
            fs.read(this.fileBuffer, 0, taille);
            channel.close();
            fs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getOffset(int idOffset) {
        int offset = 0;
        while (offset < this.fileBuffer.length) {
            if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == idOffset) {
                return offset;
            }
            int lengthSize = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
            int lengthOffset = Fonctions.bytesToInt(this.fileBuffer, ++offset, lengthSize);
            offset += lengthSize + lengthOffset;
        }
        return -1;
    }

    public byte[] getObjectByte(int offset) {
        int lengthSize = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        int activityLength = Fonctions.bytesToInt(this.fileBuffer, ++offset, lengthSize);
        TimsLogger.debug("#VehicleImport.getObjectByte#objectLength = " + activityLength + " (" + offset + ")");
        ++offset;
        byte[] one = new byte[activityLength];
        int x = 0;
        while (x < activityLength) {
            one[x] = this.fileBuffer[offset];
            ++x;
            ++offset;
        }
        return one;
    }

    public static File[] getFile(String title, String btnMsg, boolean repOnly, String defaultRep) {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            String def = "";
            if (defaultRep != null && defaultRep != "") {
                def = prefs.node("DIRECTORY").get(defaultRep, System.getProperty("user.home"));
            }
            JFileChooser choix = new JFileChooser(def);
            if (repOnly) {
                choix.setFileSelectionMode(1);
            }
            choix.setMultiSelectionEnabled(true);
            choix.setDialogTitle(title);
            choix.setApproveButtonText(btnMsg);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                if (defaultRep != null && defaultRep != "") {
                    prefs.node("DIRECTORY").put(defaultRep, choix.getCurrentDirectory().getAbsolutePath());
                }
                return choix.getSelectedFiles();
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.system.util.Fonctions.getFile(  )  : " + ex);
            return null;
        }
        return null;
    }
}

