/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ImportField;
import fr.pgh.data.bdd.VehicleAffectation;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.VehicleBody;
import fr.pgh.data.bdd.VehicleModel;
import fr.pgh.data.bdd.VehicleType;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.imp.util.CsvReader;
import transpo.system.imp.util.DataReader;
import transpo.system.imp.util.ExcelReader;

public class VehicleSheetImport
extends AbstractAutomaticWarning {
    private DataReader reader = null;
    private final String MODULE = "VEHICLE_SHEET";
    HashMap<String, String> field = null;
    private int IDX_AGENCY = -1;
    private int IDX_AGENCY_CODE = -1;
    private int IDX_IMMATRICULATION = -1;
    private int IDX_DESIGNATION = -1;
    private int IDX_IDENTIFICATION = -1;
    private int IDX_FAMILLE = -1;
    private int IDX_MARQUE = -1;
    private int IDX_COMMENTAIRE = -1;
    private int IDX_DATE_ENTREE = -1;
    private int IDX_DATE_SORTIE = -1;
    private int IDX_ARCHIVAGE = -1;
    private int IDX_LOCATION_LIMIT = -1;
    private int IDX_GUARANTEE = -1;
    private int IDX_LOCATION_KM = -1;
    private int IDX_LAST_KNOWN_KM = -1;
    private int IDX_OWNER = -1;
    private int IDX_LOCATION_PRICE = -1;
    private int IDX_TYPE = -1;
    private int IDX_BODY = -1;
    private int IDX_MODEL = -1;
    private int IDX_AFFECTATION = -1;
    private int IDX_ANALYTIC_CODE = -1;

    @Override
    public void execute() throws Exception {
        this.field = ImportField.loadHashMap("VEHICLE_SHEET");
        if (this.field.values().size() == 0 || this.field.get("FILENAME") == null) {
            TimsLogger.warn("#VehicleSheetImport.process# Missing parameters for VehicleSheetImport (VEHICLE_SHEET), can't continue");
            return;
        }
        int created = 0;
        int updated = 0;
        boolean unchanged = false;
        int agencyCreated = 0;
        int typeCreated = 0;
        int affectationCreated = 0;
        int acCreated = 0;
        int bodyCreated = 0;
        int modelCreated = 0;
        int ignored = 0;
        BddTransport.getInstance().startTransaction();
        String file = this.field.get("FILENAME");
        try {
            String dateFormat = this.field.get("DATE_FORMAT") == null ? "dd/MM/yyyy" : this.field.get("DATE_FORMAT");
            String ext = file.substring(file.indexOf(".") + 1);
            if (ext.equals("xls")) {
                this.reader = new ExcelReader(file, dateFormat);
            } else if (ext.equals("csv")) {
                this.reader = new CsvReader(file, dateFormat);
            }
            this.initColmun();
            while (this.reader.next()) {
                String fImmatriculation = this.IDX_IMMATRICULATION == -1 ? null : this.reader.get(this.IDX_IMMATRICULATION);
                String fIdentification = this.IDX_IDENTIFICATION == -1 ? null : this.reader.get(this.IDX_IDENTIFICATION);
                String fDesignation = this.IDX_DESIGNATION == -1 ? null : this.reader.get(this.IDX_DESIGNATION);
                String fFamille = this.IDX_FAMILLE == -1 ? null : this.reader.get(this.IDX_FAMILLE);
                String fMarque = this.IDX_MARQUE == -1 ? null : this.reader.get(this.IDX_MARQUE);
                String fComm = this.IDX_COMMENTAIRE == -1 ? null : this.reader.get(this.IDX_COMMENTAIRE);
                String fLocationKm = this.IDX_LOCATION_KM == -1 ? "0" : this.reader.get(this.IDX_LOCATION_KM);
                String fLastKm = this.IDX_LAST_KNOWN_KM == -1 ? "0" : this.reader.get(this.IDX_LAST_KNOWN_KM);
                String fOwner = this.IDX_OWNER == -1 ? null : this.reader.get(this.IDX_OWNER);
                String fLocationPrice = this.IDX_LOCATION_PRICE == -1 ? "0" : this.reader.get(this.IDX_LOCATION_PRICE);
                Date fGuarantee = this.IDX_GUARANTEE == -1 ? null : this.reader.getDate(this.IDX_GUARANTEE);
                Date fLocationLimit = this.IDX_LOCATION_LIMIT == -1 ? null : this.reader.getDate(this.IDX_LOCATION_LIMIT);
                Date dEntree = this.IDX_DATE_ENTREE == -1 ? null : this.reader.getDate(this.IDX_DATE_ENTREE);
                String dateEntree = ConversionTime.dateToString(dEntree, "yyyy-MM-dd");
                Date dSortie = this.IDX_DATE_SORTIE == -1 ? null : this.reader.getDate(this.IDX_DATE_SORTIE);
                String dateSortie = ConversionTime.dateToString(dSortie, "yyyy-MM-dd");
                String agency = this.IDX_AGENCY == -1 ? null : this.reader.get(this.IDX_AGENCY);
                String agencyCode = this.IDX_AGENCY_CODE == -1 ? null : this.reader.get(this.IDX_AGENCY_CODE);
                String type = this.IDX_TYPE == -1 ? null : this.reader.get(this.IDX_TYPE);
                String body = this.IDX_BODY == -1 ? null : this.reader.get(this.IDX_BODY);
                String model = this.IDX_MODEL == -1 ? null : this.reader.get(this.IDX_MODEL);
                String affectation = this.IDX_AFFECTATION == -1 ? null : this.reader.get(this.IDX_AFFECTATION);
                String analytique = this.IDX_ANALYTIC_CODE == -1 ? null : this.reader.get(this.IDX_ANALYTIC_CODE);
                Vehicule currentVehicle = new Vehicule();
                Agence currentAgence = new Agence();
                VehicleType currentType = new VehicleType();
                VehicleBody currentBody = new VehicleBody();
                VehicleAffectation currentAffectation = new VehicleAffectation();
                VehicleModel currentModel = new VehicleModel();
                VehicleAnalyticCode currentAnalyticCode = new VehicleAnalyticCode();
                if (!currentAgence.loadByNameOrCode(agency, agencyCode)) {
                    currentAgence.setDescription(agency);
                    currentAgence.setCleInterneAgence(agencyCode);
                    currentAgence.insert();
                    currentAgence.loadByNameOrCode(agency, agencyCode);
                    ++agencyCreated;
                }
                if (type != null && !currentType.loadByName(type)) {
                    currentType.setName(type);
                    currentType.insert();
                    currentType.loadByName(type);
                    ++typeCreated;
                }
                if (body != null && !currentBody.loadByName(body)) {
                    currentModel.setName(body);
                    currentBody.insert();
                    currentBody.loadByName(body);
                    ++bodyCreated;
                }
                if (model != null && !currentModel.loadByName(model)) {
                    currentModel.setName(model);
                    currentModel.insert();
                    currentModel.loadByName(model);
                    ++modelCreated;
                }
                if (affectation != null && !currentAffectation.loadByName(affectation)) {
                    currentAffectation.setName(affectation);
                    currentAffectation.insert();
                    currentAffectation.loadByName(affectation);
                    ++affectationCreated;
                }
                if (analytique != null && !currentAnalyticCode.loadByName(analytique)) {
                    currentAnalyticCode.setName(analytique);
                    currentAnalyticCode.setCode(analytique);
                    currentAnalyticCode.insert();
                    currentAnalyticCode.loadByName(analytique);
                    ++acCreated;
                }
                if (fImmatriculation == null || fImmatriculation.equals("")) {
                    ++ignored;
                    continue;
                }
                if (!currentVehicle.loadByImmat(fImmatriculation, false)) {
                    TimsLogger.debug("Create vehicle " + fImmatriculation);
                    if (dateSortie != null && !dateSortie.equals("1970-01-01") && !ConversionTime.stringToDate(dateSortie, "yyyy-MM-dd").after(new Date())) continue;
                    TimsLogger.debug("Create vehicle " + fImmatriculation);
                    currentVehicle.setAgencyId(currentAgence.getCleAgence());
                    currentVehicle.setDesignation(fDesignation);
                    currentVehicle.setRegistrationNumber(fImmatriculation);
                    currentVehicle.setIdentificationNumber(fIdentification);
                    currentVehicle.setCategory(fFamille);
                    currentVehicle.setBrand(fMarque);
                    currentVehicle.setComment(fComm);
                    currentVehicle.setLocationKm(Integer.parseInt(fLocationKm));
                    currentVehicle.setLastKnownKm(Integer.parseInt(fLastKm));
                    currentVehicle.setDateEntree(dateEntree);
                    currentVehicle.setDateSortie(dateSortie);
                    currentVehicle.setOwner(fOwner);
                    currentVehicle.setGuarantee(fGuarantee);
                    currentVehicle.setLocationLimit(fLocationLimit);
                    currentVehicle.setLocationPrice(Float.parseFloat(fLocationPrice));
                    currentVehicle.setBodyId(currentBody.getId());
                    currentVehicle.setTypeId(currentType.getId());
                    currentVehicle.setAffectationId(currentAffectation.getId());
                    currentVehicle.setModelId(currentModel.getId());
                    currentVehicle.insert();
                    ++created;
                    continue;
                }
                TimsLogger.debug("Update vehicle " + fImmatriculation);
                boolean upd = currentVehicle.compareAndUpdate(currentAgence.getCleAgence(), fDesignation, fMarque, fFamille, fImmatriculation, fIdentification, dateEntree, dateSortie, fComm, fGuarantee, fOwner, fLocationLimit, Integer.parseInt(fLocationKm), Float.parseFloat(fLocationPrice), currentVehicle.getAverageDailyKm(), currentType.getId(), currentAffectation.getId(), currentBody.getId(), currentModel.getId(), currentAnalyticCode.getId());
                ++updated;
            }
            if (Transport.debug >= 1) {
                BddTransport.getInstance().rollback();
            } else {
                BddTransport.getInstance().commit();
            }
            this.warnContent = "Import du fichier v\u00e9hicule " + file + " => " + (updated + created + ignored) + " fiches trait\u00e9es : " + agencyCreated + " agences cr\u00e9es. " + created + " v\u00e9hicules cr\u00e9es, " + ignored + " ignor\u00e9es (champs manquants).";
            TimsLogger.info("\r\n#VehicleSheetImport# Final result : " + agencyCreated + " agences cr\u00e9es. " + created + " v\u00e9hicules cr\u00e9es, " + updated + " mis \u00e0 jour (changement ou non), " + ignored + " ignor\u00e9s, ");
            this.reader.close();
            File tmp = new File(file);
            tmp.delete();
        }
        catch (Exception ex) {
            TimsLogger.error("Erreur VehicleSheetImport");
            ex.printStackTrace();
            throw ex;
        }
    }

    private void initColmun() {
        this.IDX_AGENCY = Integer.parseInt(this.field.get("IDX_AGENCY").toString());
        this.IDX_AGENCY_CODE = Integer.parseInt(this.field.get("IDX_AGENCY_CODE").toString());
        this.IDX_IMMATRICULATION = Integer.parseInt(this.field.get("IDX_IMMATRICULATION").toString());
        this.IDX_DESIGNATION = Integer.parseInt(this.field.get("IDX_DESIGNATION").toString());
        this.IDX_IDENTIFICATION = Integer.parseInt(this.field.get("IDX_IDENTIFICATION").toString());
        this.IDX_FAMILLE = Integer.parseInt(this.field.get("IDX_FAMILLE").toString());
        this.IDX_MARQUE = Integer.parseInt(this.field.get("IDX_MARQUE").toString());
        this.IDX_COMMENTAIRE = Integer.parseInt(this.field.get("IDX_COMMENTAIRE").toString());
        this.IDX_DATE_ENTREE = Integer.parseInt(this.field.get("IDX_DATE_ENTREE").toString());
        this.IDX_DATE_SORTIE = Integer.parseInt(this.field.get("IDX_DATE_SORTIE").toString());
        this.IDX_ARCHIVAGE = Integer.parseInt(this.field.get("IDX_ARCHIVAGE").toString());
        this.IDX_LOCATION_LIMIT = Integer.parseInt(this.field.get("IDX_LOCATION_LIMIT").toString());
        this.IDX_GUARANTEE = Integer.parseInt(this.field.get("IDX_GUARANTEE").toString());
        this.IDX_LOCATION_KM = Integer.parseInt(this.field.get("IDX_LOCATION_KM").toString());
        this.IDX_LAST_KNOWN_KM = Integer.parseInt(this.field.get("IDX_LAST_KNOWN_KM").toString());
        this.IDX_OWNER = Integer.parseInt(this.field.get("IDX_OWNER").toString());
        this.IDX_LOCATION_PRICE = Integer.parseInt(this.field.get("IDX_LOCATION_PRICE").toString());
        this.IDX_TYPE = Integer.parseInt(this.field.get("IDX_TYPE").toString());
        this.IDX_BODY = Integer.parseInt(this.field.get("IDX_BODY").toString());
        this.IDX_MODEL = Integer.parseInt(this.field.get("IDX_MODEL").toString());
        this.IDX_AFFECTATION = Integer.parseInt(this.field.get("IDX_AFFECTATION").toString());
        this.IDX_ANALYTIC_CODE = Integer.parseInt(this.field.get("IDX_ANALYTIC_CODE").toString());
    }
}

