/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp.ui;

import fr.pgh.data.bdd.Rule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMImport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class UIImport
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlContent = null;
    private JComboBox cbImportRule = null;
    private JPanel pnlListe = null;
    private JTextField fileToImport = null;
    private JButton btnGetFile = null;
    private JButton btnDetail = null;
    private JScrollPane jspTable = null;
    private JTable tblData = null;
    private JButton btnSave = null;

    public UIImport(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setSize(500, 400);
        this.setTitle(LanguageTranslator.getString("import.title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.fill = 3;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlContent(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlListe(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getBtnSave(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridx = 0;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getCbImportRule(), gridBagConstraints2);
            this.pnlContent.add((Component)this.getBtnGetFile(), gridBagConstraints5);
            this.pnlContent.add((Component)this.getBtnDetail(), gridBagConstraints7);
            this.pnlContent.add((Component)this.getJspTable(), gridBagConstraints6);
            this.pnlContent.add((Component)this.getFileToImport(), gridBagConstraints3);
        }
        return this.pnlContent;
    }

    private JComboBox getCbImportRule() {
        if (this.cbImportRule == null) {
            this.cbImportRule = new JComboBox();
            this.cbImportRule.setModel(new ComboBoxModel(Rule.getRules(), true, null));
        }
        return this.cbImportRule;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            this.pnlListe = new JPanel();
            this.pnlListe.setPreferredSize(new Dimension(150, 0));
            this.pnlListe.setLayout(new GridBagLayout());
        }
        return this.pnlListe;
    }

    private JTextField getFileToImport() {
        if (this.fileToImport == null) {
            this.fileToImport = new JTextField();
        }
        return this.fileToImport;
    }

    private JButton getBtnGetFile() {
        if (this.btnGetFile == null) {
            this.btnGetFile = new JButton();
            this.btnGetFile.setText(LanguageTranslator.getString("button.load"));
            this.btnGetFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIImport.this.select();
                }
            });
        }
        return this.btnGetFile;
    }

    private void select() {
        File selected = this.getFile();
        if (selected != null) {
            Rule current = (Rule)((ComboBoxModel)this.getCbImportRule().getModel()).getObjectAt(this.getCbImportRule().getSelectedIndex());
            current.setToLoad(selected);
            if (current.checkPattern() != 1) {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString(""), LanguageTranslator.getString("message.numberedError", "11"), 0);
            } else if (current.getValue() != null) {
                TMImport tmp = new TMImport(current.getLinks(), current.getValue());
                this.getTblData().setModel(tmp);
            }
        }
    }

    private JButton getBtnDetail() {
        if (this.btnDetail == null) {
            this.btnDetail = new JButton();
            this.btnDetail.setText(LanguageTranslator.getString("button.details"));
        }
        return this.btnDetail;
    }

    private File getFile() {
        try {
            JFileChooser choix = new JFileChooser();
            choix.setFileSelectionMode(0);
            choix.setMultiSelectionEnabled(false);
            choix.setDialogTitle(LanguageTranslator.getString("message.selectFile"));
            choix.setApproveButtonText(LanguageTranslator.getString("button.valid"));
            if (choix.showOpenDialog(this) == 0) {
                return choix.getSelectedFile();
            }
            return null;
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.system.uev.UIImport.getFile(  )  : " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblData());
        }
        return this.jspTable;
    }

    private JTable getTblData() {
        if (this.tblData == null) {
            this.tblData = new JTable();
        }
        return this.tblData;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimsLogger.debug("TODO save()");
                }
            });
        }
        return this.btnSave;
    }
}

