/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.imp.util.DataReader;
import transpo.system.util.Fonctions;

public class CsvReader
implements DataReader {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat alternativeDateFormat = new SimpleDateFormat("dd MM yyyy HH:mm:ss");
    private BufferedReader data = null;
    private String[] currentLine = null;
    private int lineNumber = 0;

    public CsvReader(String file, String sDateFormat) throws FileNotFoundException {
        this.data = new BufferedReader(new FileReader(file));
        if (sDateFormat != null) {
            this.dateFormat = new SimpleDateFormat(sDateFormat);
        }
    }

    @Override
    public boolean next() {
        String line;
        block3: {
            ++this.lineNumber;
            try {
                line = this.data.readLine();
                if (line != null) break block3;
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        TimsLogger.debug("line " + this.lineNumber + " of " + " ?? = " + line);
        this.currentLine = line.split(";");
        return true;
    }

    @Override
    public String get(int column) {
        if (this.currentLine == null || column > this.currentLine.length - 1) {
            return "";
        }
        return this.currentLine[column] == null || this.currentLine[column].equals("") ? "" : this.currentLine[column].trim();
    }

    @Override
    public Date getDate(int column) {
        return this.getDate(this.get(column));
    }

    public Date getDate(String input) {
        block5: {
            try {
                if (input != null && !input.equals("")) break block5;
                return null;
            }
            catch (ParseException ex) {
                try {
                    return this.alternativeDateFormat.parse(input);
                }
                catch (ParseException e) {
                    TimsLogger.warn("unparseable " + input + " ... ignoring");
                    return null;
                }
            }
        }
        return this.dateFormat.parse(input);
    }

    @Override
    public int getInt(int column) {
        boolean nonInt;
        boolean bl = nonInt = !Fonctions.isInt(this.currentLine[column]);
        if (this.currentLine == null || column > this.currentLine.length - 1 || nonInt) {
            if (nonInt && Fonctions.isFloat(this.currentLine[column])) {
                return (int)this.getFloat(column);
            }
            return -1;
        }
        return Integer.parseInt(this.currentLine[column].replace(",", "."));
    }

    @Override
    public float getFloat(int column) {
        if (this.currentLine == null || column > this.currentLine.length - 1) {
            return -1.0f;
        }
        String toConvert = this.currentLine[column].replace("\u00a0", "").replace(" ", "").replace(",", ".");
        if (toConvert.equals("") || !Fonctions.isFloat(toConvert)) {
            return 0.0f;
        }
        return Float.parseFloat(toConvert);
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public void close() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

