/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.imp.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import transpo.system.TimsLogger;
import transpo.system.imp.util.DataReader;
import transpo.system.util.Fonctions;

public class ExcelReader
implements DataReader {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat alternativeDateFormat = new SimpleDateFormat("dd MM yyyy HH:mm:ss");
    private HSSFWorkbook wb = null;
    private HSSFSheet dataSheet = null;
    private int index = -1;
    private Iterator<Row> rowIterator = null;
    Row currentRow = null;

    public ExcelReader(String file, String sSateFormat) throws Exception {
        this.dateFormat = new SimpleDateFormat(sSateFormat);
        TimsLogger.debug("#ExcelReader# lecture");
        this.wb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        this.wb.getSheetAt(0);
        this.dataSheet = this.wb.getSheetAt(0);
        this.rowIterator = this.dataSheet.rowIterator();
    }

    @Override
    public boolean next() {
        this.currentRow = this.rowIterator.next();
        return this.currentRow != null;
    }

    @Override
    public String get(int column) {
        if (column > this.currentRow.getLastCellNum() - 1) {
            return "";
        }
        String toReturn = this.currentRow.getCell(column).getStringCellValue();
        return toReturn == null || toReturn.equals("") ? "" : toReturn.trim();
    }

    @Override
    public Date getDate(int column) {
        return this.getDate(this.get(column));
    }

    public Date getDate(String input) {
        block5: {
            TimsLogger.debug("parse " + input);
            try {
                if (input != null && !input.equals("")) break block5;
                return null;
            }
            catch (ParseException ex) {
                try {
                    return this.alternativeDateFormat.parse(input);
                }
                catch (ParseException e) {
                    TimsLogger.warn("unparseable " + input + " with " + this.dateFormat.toPattern() + " format... ignoring");
                    return null;
                }
            }
        }
        return this.dateFormat.parse(input);
    }

    @Override
    public int getInt(int column) {
        String value = this.get(column);
        if (!Fonctions.isInt(value)) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    @Override
    public float getFloat(int column) {
        String value = this.get(column);
        if (!Fonctions.isFloat(value.replace(",", "."))) {
            return -1.0f;
        }
        return Float.parseFloat(value.replace(",", "."));
    }

    @Override
    public int getLine() {
        return this.index;
    }

    @Override
    public void close() {
        try {
            this.wb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

