/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.CardAcquisition;
import transpo.system.jsmartcard.CompanyCardProperty;
import transpo.system.jsmartcard.CompanyCardStructure;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;

public class CompanyCardAcquisition
extends CardAcquisition {
    CompanyCardStructure tableFichier = new CompanyCardStructure();
    public Fmresources res = new Fmresources();

    public int lireCaP() {
        Transport.ps.startOperation();
        sound player = null;
        ByteArrayInputStream stream = null;
        if (System.getProperty("company", "PGH").equals("salvesen")) {
            String path = String.valueOf(System.getenv("SystemRoot")) + "\\Media\\notify.wav";
            player = new sound(path);
            stream = new ByteArrayInputStream(player.getSamples());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmm");
        Date date = new Date();
        String dd = formatter.format(date);
        String nameFile = String.valueOf(dd) + ".S1B";
        String workFile = String.valueOf(Transport.savePath) + nameFile;
        if (this.getComm(workFile) != "9000") {
            if (System.getProperty("company", "PGH").equals("salvesen")) {
                player.play(stream);
            }
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.transfer.error"), LanguageTranslator.getString("", String.valueOf(String.valueOf(2)) + 0), 0);
            File tmp = new File(workFile);
            tmp.delete();
            Transport.ps.endOperation(PerformanceScanner.READING, "card dowload");
            return 0;
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "card download");
        return 2;
    }

    public String getComm(String fileName) {
        this.tableFichier.makeTable();
        this.tableFichier.afficheTable();
        String code = null;
        if (!this.communicator.connect()) {
            TimsLogger.warn("erreur d'ouverture de session ...");
            return "0000";
        }
        try {
            FileOutputStream writer = new FileOutputStream(fileName);
            ProgressBar av = new ProgressBar(MainFrameTransport.getInstance(), "Lecture CAP");
            av.setVisible(true);
            av.jBar.setMinimum(0);
            av.jBar.setMaximum(this.tableFichier.arrayRead.length);
            int i = 0;
            while (i < this.tableFichier.arrayRead.length) {
                av.jBar.setValue(i);
                if (i == 2 && (code = this.communicator.selectFile("FF544143484F")) != "9000") {
                    TimsLogger.warn(String.valueOf(code) + " : Error for selecting the file .... \n");
                    writer.close();
                    new File(fileName).delete();
                    return code;
                }
                code = this.communicator.selectFile(this.tableFichier.arrayRead[i][0]);
                if (code != "9000") {
                    TimsLogger.debug("selectFile returns " + code);
                    writer.close();
                    new File(fileName).delete();
                    return code;
                }
                av.getBar().setString(LanguageTranslator.getString("card.transfer.state", this.tableFichier.arrayRead[i][0]));
                if (Integer.parseInt(this.tableFichier.arrayRead[i][1]) > 256 && (code = this.communicator.performHashOfFile()) != "9000") {
                    TimsLogger.debug("hashOfFile returns " + code);
                    writer.close();
                    new File(fileName).delete();
                    return code;
                }
                ByteBuffer buff = ByteBuffer.allocate(5);
                short al1 = (short)Integer.parseInt(this.tableFichier.arrayRead[i][0], 16);
                int len = Integer.parseInt(this.tableFichier.arrayRead[i][1]);
                String alength = Integer.toHexString(len);
                if (alength.length() == 1) {
                    alength = "0" + alength;
                }
                short al2 = (short)Integer.parseInt(alength, 16);
                buff.putShort(al1);
                buff.put((byte)0);
                buff.putShort(al2);
                buff.flip();
                writer.getChannel().write(buff);
                int j = 2;
                while (j < this.tableFichier.arrayRead[i].length) {
                    String le;
                    String p2;
                    String p1 = this.tableFichier.arrayRead[i][j++];
                    if ((code = this.communicator.readBinary(p1, p2 = this.tableFichier.arrayRead[i][j++], le = this.tableFichier.arrayRead[i][j++])) != "9000") {
                        TimsLogger.debug("readBinary returns " + code);
                        writer.close();
                        new File(fileName).delete();
                        return code;
                    }
                    ByteBuffer buf = ByteBuffer.allocate(255);
                    int index = 0;
                    int count = this.getBuffer().length;
                    while (index < count - 2 && buf.hasRemaining()) {
                        writer.write(this.getBuffer()[index++]);
                    }
                    if (!this.tableFichier.arrayRead[i][0].equals("0501")) continue;
                    int numberOfCompanyActivity = Fonctions.bytesToInt(this.getBuffer(), 3, 2);
                    CompanyCardProperty.setNumberOfCompanyActivityRecord(numberOfCompanyActivity);
                    this.tableFichier.setSize("050D", CompanyCardProperty.companyActivityDataSize - 5);
                    this.tableFichier.makeTable();
                }
                ++i;
            }
            av.dispose();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Erreur cr\u00e9ation du fichier : " + e);
            return "0000";
        }
        return "9000";
    }

    public class sound {
        private AudioFormat format;
        private byte[] samples;

        public sound(String filename) {
            try {
                AudioInputStream stream = AudioSystem.getAudioInputStream(new File(filename));
                this.format = stream.getFormat();
                this.samples = this.getSamples(stream);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public byte[] getSamples() {
            return this.samples;
        }

        public byte[] getSamples(AudioInputStream stream) {
            int length = (int)(stream.getFrameLength() * (long)this.format.getFrameSize());
            byte[] samples = new byte[length];
            DataInputStream in = new DataInputStream(stream);
            try {
                in.readFully(samples);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return samples;
        }

        public void play(InputStream source) {
            SourceDataLine line;
            int bufferSize = this.format.getFrameSize() * Math.round(this.format.getSampleRate() / 10.0f);
            byte[] buffer = new byte[bufferSize];
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(this.format, bufferSize);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return;
            }
            line.start();
            try {
                int numBytesRead = 0;
                while (numBytesRead != -1) {
                    numBytesRead = source.read(buffer, 0, buffer.length);
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            line.drain();
            line.close();
        }
    }
}

