/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.CCIDReader;
import transpo.system.jsmartcard.CardAcquisition;
import transpo.system.jsmartcard.CardCommunicator;
import transpo.system.jsmartcard.DriverCardProperty;
import transpo.system.jsmartcard.DriverCardSaving;
import transpo.system.jsmartcard.ElementaryFile;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.reader.FileReadManager;

public class DriverCardAcquisition
extends CardAcquisition {
    private static DriverCardAcquisition instance = null;
    DriverCardProperty cardStructure = new DriverCardProperty();
    public Fmresources res = new Fmresources();

    public static DriverCardAcquisition getInstance() {
        if (instance == null) {
            instance = new DriverCardAcquisition(null);
        }
        return instance;
    }

    public DriverCardAcquisition(CardCommunicator communicator) {
        this.communicator = communicator == null ? new CCIDReader() : communicator;
    }

    /*
     * Unable to fully structure code
     */
    public int launchCardReading() {
        block15: {
            if (this.communicator == null || !this.communicator.connect()) {
                TimsLogger.warn("#DriverCardAcquisition# Erreur init communicator : " + (this.communicator == null));
                return -1;
            }
            if (!this.communicator.reset()) {
                TimsLogger.warn("#DriverCardAcquisition# Erreur while sending ATR");
                return -1;
            }
            TimsLogger.info("#DCA.initSession# Contact OK ...\n");
            Transport.ps.startOperation();
            player = null;
            stream = null;
            if (System.getProperty("company", "PGH").equals("salvesen")) {
                path = String.valueOf(System.getenv("SystemRoot")) + "\\Media\\notify.wav";
                player = new sound(path);
                stream = new ByteArrayInputStream(player.getSamples());
            }
            formatter = new SimpleDateFormat("yyMMddHHmm");
            date = new Date();
            dd = formatter.format(date);
            nameFile = String.valueOf(dd) + ".C1B";
            workFile = String.valueOf(Transport.savePath) + nameFile;
            lastCardDownload = Long.toHexString(date.getTime() / 1000L);
            if (this.readCardProcess(workFile).equals("9000")) break block15;
            if (System.getProperty("company", "PGH").equals("salvesen")) {
                player.play(stream);
            }
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.transfer.error"), LanguageTranslator.getString("message.numberedError", new String[]{String.valueOf(String.valueOf(2)) + 0}), 0);
            tmp = new File(workFile);
            tmp.delete();
            Transport.ps.endOperation(PerformanceScanner.READING, "card dowload");
            return 0;
        }
        try {
            source = new File(workFile);
            tmp = new DriverCardSaving(source);
            cardNumber = tmp.getCardNumber();
            pays = tmp.getMemberState();
            nameFile = String.valueOf(pays) + cardNumber.substring(0, 14) + nameFile;
            workFile = System.getProperty("URL") == null ? String.valueOf(FileManager.ARCHIVE_DIRECTORY) + nameFile : String.valueOf(Transport.savePath) + nameFile;
            destination = new File(workFile);
            TimsLogger.debug(destination.getAbsolutePath());
            if (!source.renameTo(destination)) {
                TimsLogger.warn("Erreur de d\u00e9placement du fichier");
                Transport.ps.endOperation(PerformanceScanner.READING, "card dowload");
                return 7;
            }
            ** GOTO lbl58
        }
        catch (Exception e) {
            try {
                try {
                    if (System.getProperty("company", "PGH").equals("salvesen")) {
                        player.play(stream);
                    }
                }
                catch (Exception ew) {
                    ew.printStackTrace();
                }
                TimsLogger.warn("#DCA# il y a une exception");
                e.printStackTrace();
lbl58:
                // 2 sources

                this.WriteFECardDownLoad(lastCardDownload);
                Transport.ps.endOperation(PerformanceScanner.READING, "card download");
                if (System.getProperty("company", "PGH").equals("salvesen")) {
                    player.play(stream);
                }
                if ("1".equals(System.getProperty("automatic.tools.detection", "0"))) {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.transfer.success"), LanguageTranslator.getString("message.done"), 1);
                }
                FileReadManager.getInstance().addFile(new File(workFile), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 2;
    }

    public String readCardProcess(String fileName) {
        int selectedDF = 0;
        boolean g2v2 = false;
        String code = null;
        try {
            FileOutputStream writer = new FileOutputStream(fileName);
            ProgressBar av = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.reading"));
            av.setVisible(true);
            av.getBar().setMinimum(0);
            av.getBar().setMaximum(100);
            int processedEf = 0;
            for (ElementaryFile ef : this.cardStructure.getDownloadList()) {
                if (!ef.shouldDownload(selectedDF, g2v2)) {
                    TimsLogger.debug("#DCA.readCardProcess# skipping " + ef.getFileID() + " (" + ef.getDfTachoType() + ") for generation " + selectedDF + " download");
                    continue;
                }
                TimsLogger.debug("#DCA.readCardProcess# reading " + ef.getFileID() + "...");
                int percent = ++processedEf * 100 / this.cardStructure.getDownloadList().size();
                av.getBar().setValue(percent);
                if (ef.getDfTachoType() != selectedDF) {
                    if (ef.getDfTachoType() == 1) {
                        code = this.communicator.selectFile("FF544143484F");
                        if (!code.equals("9000")) {
                            TimsLogger.warn(String.valueOf(code) + " : DF TACHOGRAPH : Error for selecting the file... \n");
                            continue;
                        }
                        TimsLogger.warn(String.valueOf(code) + " : DF TACHOGRAPH : selected \n");
                        selectedDF = 1;
                    } else if (ef.getDfTachoType() == 2) {
                        code = this.communicator.selectFile("FF534D524454");
                        if (!code.equals("9000")) {
                            TimsLogger.info(String.valueOf(code) + " : DF TACHOGRAPH 2 non s\u00e9lectionnable, c'est une version 1... \n");
                            continue;
                        }
                        TimsLogger.warn(String.valueOf(code) + " : DF TACHOGRAPH G2 : selected \n");
                        selectedDF = 2;
                    } else {
                        if (ef.getDfTachoType() == 3) {
                            TimsLogger.warn(" EF of G2V2");
                            continue;
                        }
                        TimsLogger.warn(" wrong DF TACHOGRAPH " + ef.getDfTachoType());
                        continue;
                    }
                }
                if (!(code = this.communicator.selectFile(ef.getFileID())).equals("9000")) {
                    TimsLogger.debug("selectFile returns " + code);
                    writer.close();
                    new File(fileName).delete();
                    av.dispose();
                    return code;
                }
                av.getBar().setString(LanguageTranslator.getString("card.transfer.state", ef.getFileName(), String.valueOf(percent)));
                if (selectedDF == 2 && ef.isDFG2Certificate()) {
                    TimsLogger.debug("#DCA.RCP# Certificate workaround");
                    int x = 204;
                    while (x < 341) {
                        int y = x >= 256 ? 255 : 0;
                        String p1 = Integer.toHexString(y >> 8);
                        String p2 = Integer.toHexString(y & 0xFF);
                        String le = Integer.toHexString(Math.min(x - y, 255));
                        if (p1.length() == 1) {
                            p1 = "0" + p1;
                        }
                        if (p2.length() == 1) {
                            p2 = "0" + p2;
                        }
                        if (le.length() == 1) {
                            le = "0" + le;
                        }
                        if ((code = this.communicator.readBinary(p1, p2, le)).equals("6700")) {
                            TimsLogger.debug("#DCA.RCP# Certificate " + ef.getFileID() + "'s size is " + (x - 1));
                            ef.setSize(x - 1);
                            break;
                        }
                        ++x;
                    }
                }
                writer.getChannel().write(this.getHeader(ef));
                TimsLogger.verbose("#DCA.RCP# " + ef.getFileID() + ":" + ef.getFileName() + " => " + ef.getSize() + " octets (param in DCP)");
                int readedByte = 0;
                while (readedByte < ef.getSize()) {
                    String p1 = Integer.toHexString(readedByte >> 8);
                    String p2 = Integer.toHexString(readedByte & 0xFF);
                    String le = Integer.toHexString(Math.min(ef.getSize() - readedByte, 255));
                    if (p1.length() == 1) {
                        p1 = "0" + p1;
                    }
                    if (p2.length() == 1) {
                        p2 = "0" + p2;
                    }
                    if (le.length() == 1) {
                        le = "0" + le;
                    }
                    percent = readedByte * 100 / ef.getSize();
                    av.getBar().setString(LanguageTranslator.getString("card.transfer.state", ef.getFileName(), String.valueOf(percent)));
                    code = this.communicator.readBinary(p1, p2, le);
                    if (!code.equals("9000")) {
                        TimsLogger.debug("readBinary returns " + code + " for " + p1 + "," + p2 + "," + le);
                        writer.close();
                        new File(fileName).delete();
                        av.dispose();
                        return code;
                    }
                    TimsLogger.verbose(String.valueOf(ef.getFileID()) + ":" + ef.getFileName() + " (" + p1 + "," + p2 + "," + le + ") => " + Fonctions.hexify(this.getBuffer()));
                    writer.write(this.getBuffer(), 0, this.getBuffer().length - 2);
                    readedByte += 255;
                }
                if (ef.getFileID().equals("0501")) {
                    int dfTachograph = ef.getDfTachoType();
                    this.cardStructure.setNumberOfEventsData(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 3, 1));
                    this.cardStructure.setNumberOfFaultsData(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 4, 1));
                    this.cardStructure.setActiviteStructureLength(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 5, 2));
                    this.cardStructure.setNumberOfVehicleRecords(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 7, 2));
                    this.cardStructure.setNumberOfPlaceRecords(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 9, selectedDF == 2 ? 2 : 1));
                    if (dfTachograph == 2) {
                        g2v2 = Fonctions.bytesToInt(this.getBuffer(), 1, 2) == 5;
                        TimsLogger.debug("#DCA.readCardProcess# g2v2 = " + Fonctions.bytesToInt(this.getBuffer(), 1, 2));
                        this.cardStructure.setNumberOfGNSSRecords(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 11, 2));
                        this.cardStructure.setNumberOfSpecificConditionRecords(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 13, 2));
                        this.cardStructure.setNumberOfVehicleUnitUsedRecords(dfTachograph, Fonctions.bytesToInt(this.getBuffer(), 15, 2));
                    }
                }
                if (ef.getFileID().equals("0525")) {
                    this.cardStructure.setNumberOfCrossingBordersRecords(Fonctions.bytesToInt(this.getBuffer(), 2, 2));
                    this.cardStructure.setNumberOfLoadUnloadOperationsRecords(Fonctions.bytesToInt(this.getBuffer(), 4, 2));
                    this.cardStructure.setNumberOfLoadTypeEntriesRecords(Fonctions.bytesToInt(this.getBuffer(), 6, 2));
                }
                if (!ef.isSigned()) continue;
                int signatureLength = selectedDF == 2 ? 64 : 128;
                code = this.communicator.performHashOfFile();
                if (!code.equals("9000") || !(code = this.communicator.computeDigitalSignature(signatureLength)).equals("9000")) {
                    TimsLogger.debug("hashOfFile of computeDigitalSignature returns " + code + " " + fileName);
                    writer.close();
                    av.dispose();
                    return code;
                }
                if (selectedDF == 2) {
                    TimsLogger.debug("#DCA.RCP# Signature workaround " + code);
                    while (code.equals("9000")) {
                        this.communicator.performHashOfFile();
                        code = this.communicator.computeDigitalSignature(++signatureLength);
                        TimsLogger.debug("#DCA.RDP# boucle signature " + signatureLength + " returns " + code + " (" + this.getBuffer().length + " car in buffer)");
                    }
                    this.communicator.computeDigitalSignature(--signatureLength);
                    signatureLength = this.getBuffer().length - 2;
                }
                TimsLogger.debug(String.valueOf(ef.getFileID()) + ":" + ef.getFileName() + " sign (length=" + signatureLength + ") => " + Fonctions.hexify(this.getBuffer()));
                writer.getChannel().write(this.getSignHeader(ef, signatureLength));
                writer.write(this.getBuffer(), 0, this.getBuffer().length - 2);
            }
            av.dispose();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Erreur cr\u00e9ation du fichier : " + e);
            return "0000";
        }
        return "9000";
    }

    private ByteBuffer getSignHeader(ElementaryFile ef, int signatureLenth) {
        ByteBuffer buff = ByteBuffer.allocate(5);
        short al1 = (short)Integer.parseInt(ef.getFileID(), 16);
        buff.putShort(al1);
        buff.put((byte)(ef.getDfTachoType() == 2 ? 3 : 1));
        buff.put((byte)0);
        buff.put((byte)signatureLenth);
        buff.flip();
        return buff;
    }

    private ByteBuffer getHeader(ElementaryFile ef) {
        ByteBuffer buff = ByteBuffer.allocate(5);
        short al1 = (short)Integer.parseInt(ef.getFileID(), 16);
        buff.putShort(al1);
        buff.put((byte)(ef.getDfTachoType() == 2 ? 2 : 0));
        String alength = Integer.toHexString(ef.getSize());
        if (alength.length() == 1) {
            alength = "0" + alength;
        }
        short al2 = (short)Integer.parseInt(alength, 16);
        buff.putShort(al2);
        buff.flip();
        return buff;
    }

    public void WriteFECardDownLoad(String lastCardDownload) {
        String code = null;
        if (!this.communicator.selectFile("050E").equals("9000")) {
            TimsLogger.warn(" Error for selecting the file 050E...");
            return;
        }
        code = this.communicator.updateBinary(lastCardDownload);
        if (!code.equals("9000")) {
            TimsLogger.warn(String.valueOf(code) + " : Error for Write in the file .... \n");
        }
    }

    public void waitForWithdraw() {
        this.communicator.waitForWithdraw();
    }

    public class sound {
        private AudioFormat format;
        private byte[] samples;

        public sound(String filename) {
            try {
                AudioInputStream stream = AudioSystem.getAudioInputStream(new File(filename));
                this.format = stream.getFormat();
                this.samples = this.getSamples(stream);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public byte[] getSamples() {
            return this.samples;
        }

        public byte[] getSamples(AudioInputStream stream) {
            int length = (int)(stream.getFrameLength() * (long)this.format.getFrameSize());
            byte[] samples = new byte[length];
            DataInputStream in = new DataInputStream(stream);
            try {
                in.readFully(samples);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return samples;
        }

        public void play(InputStream source) {
            SourceDataLine line;
            int bufferSize = this.format.getFrameSize() * Math.round(this.format.getSampleRate() / 10.0f);
            byte[] buffer = new byte[bufferSize];
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(this.format, bufferSize);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return;
            }
            line.start();
            try {
                int numBytesRead = 0;
                while (numBytesRead != -1) {
                    numBytesRead = source.read(buffer, 0, buffer.length);
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            line.drain();
            line.close();
        }
    }
}

