/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.BorderCrossing;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.CardEventsFaults;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverError;
import fr.pgh.data.bdd.EntryType;
import fr.pgh.data.bdd.GNSSAuthentication;
import fr.pgh.data.bdd.GNSSPlace;
import fr.pgh.data.bdd.HardnessAttribution;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.LoadUnload;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Place;
import fr.pgh.data.bdd.PlaceAuthentication;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.SpecificCondition;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.ServiceException;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import transpo.system.LicenceManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.core.hardness.GlobalHardnessCalculator;
import transpo.system.jsmartcard.DriverCardProperty;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ApercuCarte;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.conducteur.AffectationConducteur;
import transpo.system.ui.views.conducteur.DialogCreationConducteur;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.GestionChevauchement;
import transpo.system.util.messaging.ListMessage;
import transpo.system.util.messaging.ListsMessage;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.reader.FileReadResult;

public class DriverCardSaving {
    private Conducteur conducteur = null;
    private File toRead = null;
    private byte[] fileBuffer = null;
    private boolean fileReaden = false;
    Hashtable<Date, Integer> kmJour = null;
    private Vector<CardEventsFaults> eventFault = null;
    private ArrayList<GNSSPlace> gnssPlaces = new ArrayList();
    private Vector<Place> places = null;
    private Vector<VehicleUsed> vehicleUsed = null;
    private Vector<ChangementActivite> activityChangeInfo = null;
    private Vector<SpecificCondition> specificCondition = null;
    private Vector<VehicleUsed> lastVehiclesUsed = null;
    private Vector<String> unknownImmatriculation = new Vector();
    private ArrayList<PlaceAuthentication> placeAuthentications = new ArrayList();
    private ArrayList<BorderCrossing> borderCrossings = new ArrayList();
    private ArrayList<GNSSAuthentication> gnssAuthentications = new ArrayList();
    private ArrayList<EntryType> entriesType = new ArrayList();
    private ArrayList<LoadUnload> loadUnloads = new ArrayList();
    private Date jourEteToHiver = null;
    private Date jourHiverToEte = null;
    private boolean jourToEte = false;
    private boolean jourToHiver = false;
    private int beginIdxReminder = -1;
    private ProgressBar progression = null;
    private String firstDay = null;
    private int maxIo = 0;
    private int replacement = 0;
    private int renewal = 0;
    private int dayCount = 0;
    private Vector<String> errors = null;
    private String licenseNumber = null;
    private DriverCardProperty cardProperty = new DriverCardProperty();
    private boolean hasDFG2 = false;
    private boolean hasDFG2V2 = false;

    public DriverCardSaving(File toRead) {
        this.activityChangeInfo = new Vector();
        this.toRead = toRead;
    }

    public void readFile() {
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(this.toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            this.fileBuffer = new byte[taille];
            fs.read(this.fileBuffer, 0, taille);
            channel.close();
            fs.close();
            this.fileReaden = true;
        }
        catch (Exception ex) {
            TimsLogger.warn("#DCS.readFile() unable to find the file");
            ex.printStackTrace();
        }
    }

    public FileReadResult run() {
        Transport.ps.startOperation();
        String resume = null;
        FileReadResult toReturn = new FileReadResult();
        toReturn.setFile(this.toRead.getName());
        if (!this.toRead.getName().toUpperCase().endsWith(".C1B")) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("card.badFile"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + 8));
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process (badFile)");
            return new FileReadResult(this.toRead.getName(), 0, null, LanguageTranslator.getString("card.badFile"), this.toRead.getName());
        }
        if (!this.fileReaden) {
            this.readFile();
        }
        if (!this.fileReaden) {
            toReturn.setResult(LanguageTranslator.getString("generics.fileNotFound", this.toRead.getName()));
            resume = LanguageTranslator.getString("generics.error");
        } else {
            this.readApplicationIdentification();
            this.readDrivingLicense();
            int ident = this.readIdentification();
            resume = LanguageTranslator.getString("card.reading.title", String.valueOf(this.conducteur.getNom()) + " " + this.conducteur.getPrenom() + " ");
            if (ident == 12) {
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(2));
                Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process (unknowDriver)");
                return new FileReadResult(this.toRead.getName(), 0, null, LanguageTranslator.getString("card.readCancelled", this.conducteur.getNom(), this.conducteur.getPrenom()), resume);
            }
            if (ident == 18) {
                Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process (unknowDriver)");
                return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("card.renewal.error"), LanguageTranslator.getString("card.renewal.error"), resume);
            }
            if (ident == 19) {
                Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process (unknowDriver)");
                return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("card.renewal.replacement.error"), LanguageTranslator.getString("card.renewal.error"), resume);
            }
            if (ident == 14 && !this.addDriver()) {
                Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process (unknowDriver)");
                return new FileReadResult(this.toRead.getName(), 0, null, LanguageTranslator.getString("card.unknownDriver", this.conducteur.getNom(), this.conducteur.getPrenom()), resume);
            }
            this.conducteur.affiche();
            if (System.getProperty("check_missing", "0").equals("1")) {
                Fonctions.lookForFiles(this.conducteur);
            }
            if (LicenceManager.isExploitationLevel() && BddTransport.getInstance().getConflitList(this.conducteur.getCleConducteur(), null, 0, false).size() != 0) {
                toReturn.setResult(LanguageTranslator.getString("card.conflictDetected", this.conducteur.getNom()));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(2));
            } else if (this.readEvents() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.eventsError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readEvents());
            } else if (this.readFaults() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.faultsError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readFaults());
            } else if (this.readVehiclesUsed() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.vehicleUsedError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readVehiclesUsed());
            } else if (this.readPlaces() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.placesError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readPlaces());
            } else if (this.readSpecificConditions() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.specificError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readSpecificConditions());
            } else if (this.readGNSSPlaces() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.GNSSplacesError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.GNSSplacesError", String.valueOf(String.valueOf(2)) + this.readGNSSPlaces());
            } else if (this.readPlacesAuthentication() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.placesAuthenticationError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.placesAuthenticationError", String.valueOf(String.valueOf(2)) + this.readPlacesAuthentication());
            } else if (this.readGNSSAuthentication() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.GNSSAuthenticationError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.GNSSAuthenticationError", String.valueOf(String.valueOf(2)) + this.readGNSSAuthentication());
            } else if (this.readBorderCrossing() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.borderCrossingError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.borderCrossingError", String.valueOf(String.valueOf(2)) + this.readBorderCrossing());
            } else if (this.readLoadUnload() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.loadUnloadError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.loadUnloadError", String.valueOf(String.valueOf(2)) + this.readLoadUnload());
            } else if (this.readLoadEntriesType() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.loadEntriesTypeError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.loadEntriesTypeError", String.valueOf(String.valueOf(2)) + this.readLoadEntriesType());
            } else if (this.readVuConfiguration() != 2) {
                toReturn.setResult(LanguageTranslator.getString("card.vuConfigurationError"));
                resume = String.valueOf(resume) + LanguageTranslator.getString("message.vuConfigurationError", String.valueOf(String.valueOf(2)) + this.readVuConfiguration());
            } else {
                Date lastAct;
                Date download;
                int nbJour;
                int returnCode = this.readActivity();
                boolean errorButRead = false;
                if (returnCode == 11 && this.activityChangeInfo.size() != 0) {
                    if (Transport.apiMode == 1) {
                        errorButRead = true;
                    } else {
                        try {
                            String amessage = LanguageTranslator.getString("card.structureError");
                            String atitle = LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + returnCode);
                            ConfirmMessage t = new ConfirmMessage(amessage, atitle);
                            SwingUtilities.invokeAndWait(t);
                            if (t.getResponse() == 0) {
                                errorButRead = true;
                            }
                        }
                        catch (InvocationTargetException ex) {
                            TimsLogger.warn("#DCS.run# InvocationTargetException on invokeAndWait ");
                            ex.printStackTrace();
                        }
                        catch (InterruptedException ex) {
                            TimsLogger.warn("#DCS.run# InterruptedException on invokeAndWait ");
                            ex.printStackTrace();
                        }
                    }
                }
                if ((nbJour = ConversionTime.getDaysBetween(download = ConversionTime.stringToDate(this.getDateDownload(), "yyyy-MM-dd HH:mm:ss"), lastAct = ConversionTime.stringToDate(this.getDernierChangement(), "yyyy-MM-dd HH:mm:ss"))) > 2) {
                    TimsLogger.warn("#DCS.run# download date is " + download + " but last activity is " + lastAct + " it's an error !");
                    returnCode = 17;
                    toReturn.setResult(LanguageTranslator.getString("card.file.dateBeforeAct", ConversionTime.dateFromBDDToFrance(this.getDernierChangement(), true, true), ConversionTime.dateFromBDDToFrance(this.getDateDownload(), true, true)));
                    resume = LanguageTranslator.getString("card.savingError");
                    if (Transport.debug >= 2) {
                        Date possibleDate = ConversionTime.add(ConversionTime.stringToDateDb(this.getDernierChangement(), true), 12, 1);
                        String sPossibleDate = ConversionTime.dateToString(possibleDate, "yyMMddHHmm");
                        this.toRead.renameTo(new File(String.valueOf(this.toRead.getName().substring(0, 16)) + sPossibleDate + ".C1B"));
                    }
                } else {
                    nbJour = ConversionTime.getDaysBetween(download, new Date());
                    if (nbJour < -1) {
                        TimsLogger.warn("#DCS.run# download date is " + download + " and we are " + new Date() + " it's an error !");
                        returnCode = 16;
                        resume = LanguageTranslator.getString("card.savingError");
                        toReturn.setResult(LanguageTranslator.getString("card.file.dateAfterDay", ConversionTime.dateFromBDDToFrance(this.getDateDownload(), true, true)));
                    }
                }
                if (returnCode == 2 || returnCode == 6 || errorButRead) {
                    int save;
                    Transport.bdd.startTransaction();
                    int n = save = returnCode == 6 ? 6 : this.saveInfos();
                    if (save == 2 || save == 1 || save == 6) {
                        if (this.updateDBValues(save) == 2) {
                            Transport.bdd.commit();
                            this.offenceRecalculation();
                            toReturn.setStatus(1);
                            if (Transport.apiMode == 0) {
                                MainFrameTransport.getInstance().getTree().updateValues(null);
                                MainFrameTransport.getInstance().majPnlAccueil();
                            }
                            if (save == 1) {
                                toReturn.setResult(LanguageTranslator.getString("card.activityEverRead"));
                            } else if (returnCode == 6) {
                                toReturn.setResult(LanguageTranslator.getString("card.noActivity"));
                            } else {
                                if (this.errors.size() != 0 && this.unknownImmatriculation.size() != 0) {
                                    toReturn.setStatus(3);
                                    toReturn.setInfo(new ListsMessage(this.getErrorsWarningList(), this.getImmatriculationWarningList()));
                                } else if (this.errors.size() != 0) {
                                    toReturn.setStatus(3);
                                    toReturn.setInfo(new ListsMessage(this.getErrorsWarningList()));
                                } else if (this.unknownImmatriculation.size() != 0) {
                                    toReturn.setStatus(3);
                                    toReturn.setInfo(new ListsMessage(this.getImmatriculationWarningList()));
                                }
                                if (toReturn.getInfo() == null) {
                                    toReturn.setResult(LanguageTranslator.getString("card.activitySaved"));
                                } else {
                                    toReturn.setResult(LanguageTranslator.getString("card.activitySavedWithWarning"));
                                }
                            }
                        } else {
                            Transport.bdd.rollback();
                            toReturn.setResult(LanguageTranslator.getString("card.writingError"));
                            resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + 7);
                        }
                    } else {
                        Transport.bdd.rollback();
                        if (save == 12) {
                            TimsLogger.info("#CDP.run# Read cancelled");
                        } else {
                            toReturn.setResult(LanguageTranslator.getString("card.savingError"));
                            resume = String.valueOf(resume) + LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + save);
                            if (save == 10 && Transport.debug == 0 && !FileManager.moveTemporaryFile(new File(TimsLogger.getCurrentLogPath()))) {
                                TimsLogger.warn("#DCS.run# Log transfer failed");
                            }
                        }
                    }
                }
            }
            if (Transport.apiMode != 1) {
                this.getProgression().dispose();
            }
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total card process");
        }
        toReturn.setResume(resume);
        TimsLogger.info("#DCS.run# " + this.toRead.getName() + " (" + (this.eventFault != null ? String.valueOf(this.eventFault.size()) + " events/faults, " : "no events") + (this.vehicleUsed != null ? String.valueOf(this.vehicleUsed.size()) + " vehicleUsed, " : "no vehicles") + (this.places != null ? String.valueOf(this.places.size()) + " places" : "no places") + ") => " + toReturn.getResume() + " : " + toReturn.getResult());
        return toReturn;
    }

    private ListMessage getImmatriculationWarningList() {
        return new ListMessage(LanguageTranslator.getString("card.errorUev"), null, this.unknownImmatriculation);
    }

    private ListMessage getErrorsWarningList() {
        return new ListMessage(LanguageTranslator.getString("card.errorDay"), LanguageTranslator.getString("card.errorDay2"), this.errors);
    }

    private int offenceRecalculation() {
        Date begin = this.getFirstActivityToInsert();
        if (this.getDernierChangement().startsWith("1970-01-01") || begin == null) {
            return 2;
        }
        Date end = ConversionTime.stringToDate(this.getDernierChangement(), "yyyy-MM-dd HH:mm:ss");
        int offencereturn = Fonctions.offenceCalculation(this.conducteur, begin, end, false);
        return offencereturn == 1 ? 15 : 2;
    }

    public void readApplicationIdentification() {
        TimsLogger.debug("#DCS.readApplicationIdentification# reading...");
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 327936) + 5;
        int df = 1;
        int typeOfCartographCardId = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
        int cardStructureVersionAA = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        int cardStructureVersionBB = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        TimsLogger.debug("#DCS.readApplicationIdentification# DF_Tachograph : typeOfCartographCardId = " + typeOfCartographCardId + " / cardStructureVersionAA = " + cardStructureVersionAA + " / cardStructureVersionBB = " + cardStructureVersionBB);
        this.cardProperty.setNumberOfEventsData(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 1));
        this.cardProperty.setNumberOfFaultsData(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 1));
        this.cardProperty.setActiviteStructureLength(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 2));
        this.cardProperty.setNumberOfVehicleRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfPlaceRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 1));
        ++offset;
        offset = this.cardProperty.getOffsetFile(this.fileBuffer, 327938);
        if (offset == -1) {
            TimsLogger.debug("#DCS.readApplicationIdentification# No DF_Tachograph_G2");
            return;
        }
        TimsLogger.debug("#DCS.readApplicationIdentification# DF_Tachograph_G2 is present at " + offset);
        this.hasDFG2 = true;
        df = 2;
        typeOfCartographCardId = Fonctions.bytesToInt(this.fileBuffer, offset += 5, 1);
        cardStructureVersionAA = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        cardStructureVersionBB = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
        TimsLogger.debug("#DCS.readApplicationIdentification# DF_Tachograph_G2 : typeOfCartographCardId = " + typeOfCartographCardId + " / cardStructureVersionAA = " + cardStructureVersionAA + " / cardStructureVersionBB = " + cardStructureVersionBB);
        this.cardProperty.setNumberOfEventsData(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 1));
        this.cardProperty.setNumberOfFaultsData(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 1));
        this.cardProperty.setActiviteStructureLength(df, Fonctions.bytesToInt(this.fileBuffer, ++offset, 2));
        this.cardProperty.setNumberOfVehicleRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfPlaceRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfGNSSRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfSpecificConditionRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfVehicleUnitUsedRecords(df, Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        offset += 2;
        offset = this.cardProperty.getOffsetFile(this.fileBuffer, 337154);
        if (offset == -1) {
            TimsLogger.debug("#DCS.readApplicationIdentificationV2# No DF_Tachographe_G2V2");
            return;
        }
        this.hasDFG2V2 = true;
        TimsLogger.debug("#DCS.readApplicationIdentificationV2# DF_Tachographe_G2V2 is present at " + (offset += 5));
        int lengthOfFollowingData = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
        this.cardProperty.setNumberOfCrossingBordersRecords(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfLoadUnloadOperationsRecords(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        this.cardProperty.setNumberOfLoadTypeEntriesRecords(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2));
        int VuConfigurationLengthRange = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
        offset += 2;
        TimsLogger.debug("lengthOfFollowingData=" + lengthOfFollowingData + ", VuConfigurationLengthRange=" + VuConfigurationLengthRange);
    }

    public int readIdentification() {
        int dayBeforeExpiry;
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 335872) + 5;
        SimpleDateFormat Formatdate = new SimpleDateFormat("yyyy-MM-dd");
        byte cardIssuingMemberState = this.fileBuffer[offset];
        ++offset;
        byte[] cardNumber = new byte[16];
        int i = 0;
        while (i < cardNumber.length) {
            cardNumber[i] = this.fileBuffer[offset + i];
            if (i == 14) {
                this.replacement = Integer.parseInt(String.valueOf((char)this.fileBuffer[offset + i]));
            }
            if (i == 15) {
                this.renewal = Integer.parseInt(String.valueOf((char)this.fileBuffer[offset + i]));
            }
            ++i;
        }
        String numeroCarte = new String(cardNumber).trim();
        offset = offset + cardNumber.length + 1;
        byte[] cardIssuingAuthorityName = new byte[35];
        int i2 = 0;
        while (i2 < cardIssuingAuthorityName.length) {
            cardIssuingAuthorityName[i2] = this.fileBuffer[offset + i2];
            ++i2;
        }
        offset += cardIssuingAuthorityName.length;
        int cardValidityBegin = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4);
        Date tmp = new Date((long)cardValidityBegin * 1000L);
        String debutValidite = Formatdate.format(tmp);
        int cardExpiryDate = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4);
        tmp = new Date((long)cardExpiryDate * 1000L);
        String finValidite = Formatdate.format(tmp);
        offset = offset + 4 + 1;
        byte[] cardHolderSurname = new byte[35];
        int i3 = 0;
        while (i3 < cardHolderSurname.length) {
            cardHolderSurname[i3] = this.fileBuffer[offset + i3];
            ++i3;
        }
        String nomCarte = new String(cardHolderSurname).trim();
        offset = offset + cardHolderSurname.length + 1;
        byte[] cardHolderFirstNames = new byte[35];
        int i4 = 0;
        while (i4 < cardHolderFirstNames.length) {
            cardHolderFirstNames[i4] = this.fileBuffer[offset + i4];
            ++i4;
        }
        String prenomCarte = new String(cardHolderFirstNames).trim();
        int cardHolderBirthDate = Fonctions.bytesToInt(this.fileBuffer, offset += cardHolderFirstNames.length, 4);
        String bd = Integer.toHexString(cardHolderBirthDate);
        String dateNaissance = ConversionTime.intToDate(bd);
        offset += 4;
        byte[] cardHolderPreferredLanguage = new byte[2];
        int i5 = 0;
        while (i5 < cardHolderPreferredLanguage.length) {
            cardHolderPreferredLanguage[i5] = this.fileBuffer[offset + i5];
            ++i5;
        }
        this.conducteur = new Conducteur();
        if (!this.conducteur.loadByCard(numeroCarte, cardIssuingMemberState, 0)) {
            this.conducteur.setNom(nomCarte);
            this.conducteur.setPrenom(prenomCarte);
            this.conducteur.setNumeroCarte(numeroCarte);
            this.conducteur.setMemberState(cardIssuingMemberState);
            this.conducteur.setReplacement(this.replacement);
            this.conducteur.setRenewal(this.renewal);
            this.conducteur.setDateDebutValiditeCarte(debutValidite);
            this.conducteur.setDateFinValiditeCarte(finValidite);
            this.conducteur.setDateNaissance(dateNaissance);
            if (this.licenseNumber != null) {
                this.conducteur.setNumeroPermis(this.licenseNumber);
            }
            TimsLogger.debug("#DCS.readIdentification# New card driver detected");
            return 14;
        }
        if (Transport.apiMode == 0 && this.conducteur.getDateSortie() != null && !"".equals(this.conducteur.getDateSortie())) {
            try {
                String amessage = LanguageTranslator.getString("card.activityAfterEndDate", ConversionTime.dateFromBDDToFrance(this.conducteur.getDateSortie(), false, false));
                String atitle = LanguageTranslator.getString("message.confirm");
                ConfirmMessage t = new ConfirmMessage(amessage, atitle);
                SwingUtilities.invokeAndWait(t);
                TimsLogger.error("response" + t.getResponse());
                if (t.getResponse() == 2) {
                    return 12;
                }
            }
            catch (InvocationTargetException ex) {
                TimsLogger.warn("#DriverCardProcessing.run# InvocationTargetException on invokeAndWait ");
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                TimsLogger.warn("#DriverCardProcessing.run# InterruptedException on invokeAndWait ");
                ex.printStackTrace();
            }
        }
        if (this.conducteur.getRenewal() != this.renewal || this.conducteur.getReplacement() != this.replacement) {
            if (this.conducteur.getRenewal() > this.renewal || this.conducteur.getRenewal() == this.renewal && this.conducteur.getReplacement() > this.replacement) {
                TimsLogger.warn("#DCP.readIdentification# Erreur d'indice de renouvellement/remplacement  de carte (carte plus ancienne)");
                return 19;
            }
            if (this.conducteur.getRenewal() == this.renewal) {
                if (Transport.apiMode == 0 && MessageSystemManager.showConfirm(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.replacement.new", ConversionTime.dateFromBDDToFrance(this.conducteur.getDernierTelechargement()), ConversionTime.dateFromBDDToFrance(debutValidite)), LanguageTranslator.getString("card.reading")) != 0) {
                    return 12;
                }
                if (Transport.apiMode != 0) {
                    MessageSystemManager.warning((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("card.replacement.new", ConversionTime.dateFromBDDToFrance(this.conducteur.getDernierTelechargement()), ConversionTime.dateFromBDDToFrance(debutValidite)), LanguageTranslator.getString("card.reading.title", this.conducteur.getNom()));
                }
                Date begin = ConversionTime.stringToDateDb(this.conducteur.getDernierTelechargement());
                Date end = ConversionTime.stringToDateDb(debutValidite);
                new DriverError(0, this.conducteur.getCleConducteur(), begin, end, 2, "La carte a \u00e9t\u00e9 remplac\u00e9e, les trous d'activit\u00e9s doivent \u00eatre compl\u00e9t\u00e9s").insert();
            } else {
                Date lastDl = ConversionTime.stringToDateDb(this.conducteur.getDernierTelechargement());
                Date expiration = ConversionTime.stringToDateDb(this.conducteur.getDateFinValiditeCarte());
                if (expiration.after(lastDl)) {
                    TimsLogger.warn("#DCP.readIdentification# carte expir\u00e9e, il faut lire l'ancienne avant");
                    new DriverError(0, this.conducteur.getCleConducteur(), expiration, null, 1, "La carte arriv\u00e9e \u00e0 expiration doit \u00eatre lue avant de lire la nouvelle").insert();
                    return 18;
                }
                DriverError.setProcessed(this.conducteur.getCleConducteur(), expiration, null, 1);
            }
            this.conducteur.updateCard(numeroCarte, this.conducteur.getMemberState(), this.replacement, this.renewal, 0, dateNaissance, debutValidite, finValidite);
        }
        if (this.licenseNumber != null && !this.licenseNumber.equals(this.conducteur.getNumeroPermis())) {
            this.conducteur.updateLicense(this.licenseNumber);
        }
        if ((dayBeforeExpiry = ConversionTime.getDaysBetween(new Date(), ConversionTime.stringToDate(finValidite, "yyyy-MM-dd"))) <= 90 && Transport.apiMode == 0) {
            TimsLogger.debug("Attention fin de validit\u00e9 \u00e0 moins de 3 mois, lancer le renouvellement");
            MessageSystemManager.warning((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("card.upcomingRenewal"), LanguageTranslator.getString("card.reading.title", this.conducteur.getNom()));
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "identification");
        return 13;
    }

    public int readFaults() {
        Transport.ps.startOperation();
        if (this.eventFault == null) {
            this.eventFault = new Vector();
        }
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 328448);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readFaults####### at " + Integer.toHexString(offset));
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "faults (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readFaults# Can't find faults");
            }
            return 6;
        }
        offset += 5;
        try {
            while (Fonctions.bytesToInt(this.fileBuffer, offset, 1) != 0 && offset < this.fileBuffer.length) {
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                Date dateDebut = new Date((long)Fonctions.bytesToInt(this.fileBuffer, ++offset, 4) * 1000L);
                Date dateFin = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4) * 1000L);
                offset += 4;
                offset = offset + 1 + 1;
                byte[] immatriculation = new byte[13];
                int j = 0;
                while (j < immatriculation.length) {
                    immatriculation[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                offset += immatriculation.length;
                if (Transport.apiMode == 0) {
                    TimsLogger.debug(String.valueOf(type) + " " + new String(immatriculation).trim() + " " + dateDebut + " " + dateFin);
                }
                this.eventFault.add(new CardEventsFaults(type, this.conducteur != null ? this.conducteur.getNumeroCarte() : "", new String(immatriculation).trim(), dateDebut, dateFin));
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readFaults");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "faults (error)");
            return 3;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#DCS.readFaults# " + this.eventFault.size() + " events and faults");
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "faults");
        return 2;
    }

    public int readEvents() {
        Transport.ps.startOperation();
        if (this.eventFault == null) {
            this.eventFault = new Vector();
        }
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 328192);
        if (Transport.apiMode == 0 && Transport.debug >= 1) {
            TimsLogger.debug("#######readEvents####### at " + Integer.toHexString(offset));
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "events (no data)");
            TimsLogger.warn("#readEvents# Can't find events");
            return 6;
        }
        offset += 5;
        try {
            while (Fonctions.bytesToInt(this.fileBuffer, offset, 1) != 0 && offset < this.fileBuffer.length) {
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                Date dateDebut = new Date((long)Fonctions.bytesToInt(this.fileBuffer, ++offset, 4) * 1000L);
                Date dateFin = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4) * 1000L);
                offset += 6;
                byte[] immatriculation = new byte[13];
                int j = 0;
                while (j < immatriculation.length) {
                    immatriculation[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                offset += immatriculation.length;
                if (Transport.apiMode == 0) {
                    TimsLogger.debug(String.valueOf(type) + " " + new String(immatriculation).trim() + " " + dateDebut + " " + dateFin);
                }
                this.eventFault.add(new CardEventsFaults(type, this.conducteur != null ? this.conducteur.getNumeroCarte() : "", new String(immatriculation).trim(), dateDebut, dateFin));
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readEvents");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "events (error)");
            return 3;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#DCS.readFaults# " + this.eventFault.size() + " events");
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "events");
        return 2;
    }

    public int readSpecificConditions() {
        Transport.ps.startOperation();
        if (this.specificCondition == null) {
            this.specificCondition = new Vector();
        }
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 336384);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readSpecificCondition####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "specificCondition (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readSpecificCondition# Can't find specificCondition");
            }
            return 6;
        }
        offset += 5;
        try {
            int count = 0;
            while (count < DriverCardProperty.specificConditionCount) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 4) == 0) {
                    offset += 5;
                } else {
                    Date date = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                    int type = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
                    ++offset;
                    if (ConversionTime.stringToDate(this.conducteur.getDernierChangement(), "yyyy-MM-dd") == null || date.after(ConversionTime.stringToDate(this.conducteur.getDernierChangement(), "yyyy-MM-dd"))) {
                        this.specificCondition.add(new SpecificCondition(0, this.conducteur.getCleConducteur(), date, type));
                    }
                }
                ++count;
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readSpecificCondition");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "specificCondition (error)");
            return 3;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#DCS.readSpecificCondition# " + this.specificCondition.size() + " specificCondition");
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "specificCondition");
        return 2;
    }

    public int readGNSSPlaces() {
        if (!this.hasDFG2) {
            TimsLogger.debug("#DCP.readGNSSPlaces# Can't read GNSS on first generation card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 336898);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readGNSSPlaces####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "GNSSPlaces (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readGNSSPlaces# Can't find GNSSPlaces");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfGNSSG2;
                    continue;
                }
                this.addGNSSPlace(this.fileBuffer, offset += 4, GNSSPlace.POINT_TYPE.CONTINUOUS_DRIVING, true, false);
                offset += 14;
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readGNSSPlaces");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readGNSSPlaces (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readGNSSPlaces# " + this.gnssPlaces.size() + " GNSS Places readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readGNSSPlaces");
        return 2;
    }

    public int readPlacesAuthentication() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readPlacesAuthentication# Can't read places authentication on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 337410);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readPlacesAuthentication####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readPlacesAuthentication (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readPlacesAuthentication# Can't find EF");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfPlacesAuthenticationData;
                    continue;
                }
                Date timestamp = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                int authenticationStatus = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
                ++offset;
                this.placeAuthentications.add(new PlaceAuthentication(0, this.conducteur.getId(), timestamp, authenticationStatus));
                TimsLogger.debug("#DCP.readPlacesAuthentication# at " + ConversionTime.dateToString(timestamp, "dd/MM/yyyy HH:mm:ss") + " => authenticationStatus=" + authenticationStatus);
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readPlacesAuthentication");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readPlacesAuthentication (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readPlacesAuthentication# " + this.placeAuthentications.size() + " Place authentication readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readPlacesAuthentication");
        return 2;
    }

    public int readGNSSAuthentication() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readGNSSAuthentication# Can't read GNSS authentication on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 337666);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readGNSSAuthentication####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readGNSSAuthentication (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readGNSSAuthentication# Can't find EF");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfGNSSAuthenticationData;
                    continue;
                }
                Date timestamp = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                int authenticationStatus = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
                ++offset;
                this.gnssAuthentications.add(new GNSSAuthentication(0, this.conducteur.getId(), timestamp, authenticationStatus));
                TimsLogger.debug("#DCP.readGNSSAuthentication# at " + ConversionTime.dateToString(timestamp, "dd/MM/yyyy HH:mm:ss") + " => authenticationStatus=" + authenticationStatus);
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readGNSSAuthentication");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readGNSSAuthentication (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readGNSSAuthentication# " + this.gnssAuthentications.size() + " GNSS authentications readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readGNSSAuthentication");
        return 2;
    }

    public int readBorderCrossing() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readBorderCrossing# Can't read bordercrossing on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 337922);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readBorderCrossing####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readBorderCrossing (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readBorderCrossing# Can't find EF");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfBorderCrossingData;
                    continue;
                }
                int countryLeft = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int countryEntered = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                Date timestamp = new Date((long)Fonctions.bytesToInt(this.fileBuffer, ++offset, 4) * 1000L);
                int gnssAccuracy = Fonctions.bytesToInt(this.fileBuffer, offset + 4, 1);
                String hexCoordinate = Fonctions.parseHexAscii(this.fileBuffer, offset + 5, offset + 10);
                int authenticationStatus = Fonctions.bytesToInt(this.fileBuffer, offset + 11, 1);
                int odometerValue = Fonctions.bytesToInt(this.fileBuffer, offset += 12, 3);
                this.borderCrossings.add(new BorderCrossing(0, this.conducteur.getId(), countryLeft, countryEntered, timestamp, gnssAccuracy, hexCoordinate, authenticationStatus, odometerValue));
                this.addGNSSPlace(this.fileBuffer, (offset += 3) - 15, GNSSPlace.POINT_TYPE.BORDER_CROSSING, true, true);
                TimsLogger.debug("#DCP.readBorderCrossing# at " + ConversionTime.dateToString(timestamp, "dd/MM/yyyy HH:mm:ss") + " => country : " + countryLeft + " -> " + countryEntered + " (" + authenticationStatus + ")");
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readBorderCrossing");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readBorderCrossing (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readBorderCrossing# " + this.borderCrossings.size() + " borderCrossings readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readBorderCrossing");
        return 2;
    }

    public int readLoadUnload() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readLoadUnload# Can't read load unload on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 338178);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readLoadUnload####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readLoadUnload (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readLoadUnload# Can't find EF");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfLoadUnloadOperationData;
                    continue;
                }
                Date timestamp = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                int operationType = Fonctions.bytesToInt(this.fileBuffer, offset + 4, 1);
                Date timestampGNSS = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset + 5, 4) * 1000L);
                int gnssAccuracy = Fonctions.bytesToInt(this.fileBuffer, offset + 9, 1);
                String hexCoordinate = Fonctions.parseHexAscii(this.fileBuffer, offset + 10, offset + 15);
                int authenticationStatus = Fonctions.bytesToInt(this.fileBuffer, offset + 16, 1);
                int odometerValue = Fonctions.bytesToInt(this.fileBuffer, offset + 17, 3);
                this.loadUnloads.add(new LoadUnload(0, this.conducteur.getId(), timestamp, operationType, gnssAccuracy, hexCoordinate, authenticationStatus, odometerValue));
                this.addGNSSPlace(this.fileBuffer, (offset += 20) - 15, GNSSPlace.POINT_TYPE.LOAD_UNLOAD, true, true);
                TimsLogger.debug("#DCP.readLoadUnload# at " + ConversionTime.dateToString(timestamp, "dd/MM/yyyy HH:mm:ss") + " => operationType=" + operationType + ", km=" + odometerValue + " (authStatus=" + authenticationStatus + ")");
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readLoadUnload");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readLoadUnload (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readLoadUnload# " + this.loadUnloads.size() + " loadUnloads readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readLoadUnload");
        return 2;
    }

    public int readLoadEntriesType() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readLoadEntriesType# Can't read entrytype on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 339970);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readLoadEntriesType####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readLoadEntriesType (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readLoadEntriesType# Can't find EF");
            }
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            while (offset < offsetEnd) {
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += DriverCardProperty.sizeOfLoadTypeEntryData;
                    continue;
                }
                Date timestamp = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                int loadTypeEntered = Fonctions.bytesToInt(this.fileBuffer, offset + 4, 1);
                offset += 5;
                this.entriesType.add(new EntryType(0, this.conducteur.getCleConducteur(), timestamp, loadTypeEntered));
                TimsLogger.debug("#DCP.readLoadEntriesType# at " + ConversionTime.dateToString(timestamp, "dd/MM/yyyy HH:mm:ss") + " => loadTypeEntered=" + loadTypeEntered);
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readLoadEntriesType");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readLoadEntriesType (error)");
            return 3;
        }
        TimsLogger.debug("#DCP.readLoadEntriesType# " + this.entriesType.size() + " entriesType readed");
        Transport.ps.endOperation(PerformanceScanner.READING, "readLoadEntriesType");
        return 2;
    }

    public int readVuConfiguration() {
        if (!this.hasDFG2V2) {
            TimsLogger.debug("#DCP.readVuConfiguration# Can't read Vu configuration on not a G2V2 card");
            return 2;
        }
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 344066);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readVuConfiguration####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "readVuConfiguration (no data)");
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#DCP.readVuConfiguration# Can't find EF");
            }
            return 2;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            TimsLogger.debug("#DCP.readVuConfiguration# from " + (offset += 2) + " to " + offsetEnd);
        }
        catch (Exception ex) {
            TimsLogger.debug("Exception in readVuConfiguration");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "readVuConfiguration (error)");
            return 3;
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "readVuConfiguration");
        return 2;
    }

    public void addGNSSPlace(byte[] buffer, int offset, GNSSPlace.POINT_TYPE type, boolean hasOdometer, boolean hasAuthenticationStatus) {
        if (this.gnssPlaces == null) {
            this.gnssPlaces = new ArrayList();
        }
        int length = 11 + (hasOdometer ? 3 : 0) + (hasAuthenticationStatus ? 1 : 0);
        byte[] gnss = Arrays.copyOfRange(buffer, offset, offset + length);
        TimsLogger.debug("#DCS.GNSSPlace# " + Fonctions.hexify(gnss));
        Date timestamp = new Date((long)Fonctions.bytesToInt(gnss, 0, 4) * 1000L);
        int gnssAccuracy = Fonctions.bytesToInt(gnss, 4, 1);
        String hexCoordinate = Fonctions.parseHexAscii(gnss, 5, 10);
        int odometerValue = hasOdometer ? Fonctions.bytesToInt(gnss, hasAuthenticationStatus ? 12 : 11, 3) : 0;
        byte[] coordBuf = Fonctions.parseStringToByteArray(hexCoordinate);
        String sexagesimalLatitude = String.valueOf(Fonctions.bytesToInt(coordBuf, 0, 3));
        while (sexagesimalLatitude.length() < 5) {
            sexagesimalLatitude = "0" + sexagesimalLatitude;
        }
        int sLatLength = sexagesimalLatitude.length();
        String degreLatitude = sexagesimalLatitude.substring(0, sLatLength - 3);
        String minutLatitude = sexagesimalLatitude.substring(sLatLength - 3, sLatLength - 1);
        String secondLatitude = sexagesimalLatitude.substring(sLatLength - 1);
        float decimalLatitude = Float.parseFloat(degreLatitude) + Float.parseFloat(minutLatitude) / 60.0f + Float.parseFloat(secondLatitude) / 3600.0f;
        String sexagesimalLongitude = String.valueOf(Fonctions.bytesToInt(coordBuf, 3, 3));
        while (sexagesimalLongitude.length() < 5) {
            sexagesimalLongitude = "0" + sexagesimalLongitude;
        }
        int slLength = sexagesimalLongitude.length();
        String degreLongitude = sexagesimalLongitude.substring(0, slLength - 3);
        String minutLongitude = sexagesimalLongitude.substring(slLength - 3, slLength - 1);
        String secondLongitude = sexagesimalLongitude.substring(slLength - 1);
        float decimalLongitude = Float.parseFloat(degreLongitude) + Float.parseFloat(minutLongitude) / 60.0f + Float.parseFloat(secondLongitude) / 3600.0f;
        int vehicleId = this.findVehicle(timestamp);
        this.gnssPlaces.add(new GNSSPlace(0, this.conducteur.getCleConducteur(), vehicleId, timestamp, type, gnssAccuracy, decimalLongitude, decimalLatitude, 0, odometerValue));
        TimsLogger.debug(" => add " + type.getValue() + " at " + timestamp + " => " + hexCoordinate + " (coord" + sexagesimalLongitude + " (" + decimalLongitude + ") , " + sexagesimalLatitude + " (" + decimalLatitude + ") / acc " + gnssAccuracy + " / km " + odometerValue + ")");
    }

    private int findVehicle(Date timestamp) {
        if (this.vehicleUsed == null || this.vehicleUsed.size() == 0) {
            return 0;
        }
        for (VehicleUsed tmp : this.vehicleUsed) {
            if (tmp.getDateDebut().compareTo(timestamp) > 0) {
                return 0;
            }
            if (tmp.getDateDebut().compareTo(timestamp) > 0 || tmp.getDateFin().compareTo(timestamp) < 0) continue;
            TimsLogger.debug("#DCS.FindVehicle# found vehicle for " + ConversionTime.dateToString(timestamp, "dd/MM/yy HH:mm:ss") + " => " + tmp.getImmatriculation() + " (" + tmp.getCleVehicule() + ")");
            return tmp.getCleVehicule();
        }
        return 0;
    }

    public int readDrivingLicense() {
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 336128);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readDrivingLicense####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "driving license (no data)");
            TimsLogger.warn("#readDrivingLicense# Can't find drivingLicenseInfos");
            return 6;
        }
        offset += 5;
        byte[] issuingAuhtority = new byte[36];
        int j = 0;
        while (j < issuingAuhtority.length) {
            issuingAuhtority[j] = this.fileBuffer[offset + j];
            ++j;
        }
        int type = Fonctions.bytesToInt(this.fileBuffer, offset += issuingAuhtority.length, 1);
        ++offset;
        byte[] number = new byte[16];
        int j2 = 0;
        while (j2 < number.length) {
            number[j2] = this.fileBuffer[offset + j2];
            ++j2;
        }
        offset += number.length;
        this.licenseNumber = new String(number).trim();
        TimsLogger.debug("#DCS.readDrivingLicense# info : " + new String(issuingAuhtority).trim() + " " + type + " " + this.licenseNumber);
        Transport.ps.endOperation(PerformanceScanner.READING, "drivingLicense");
        return 2;
    }

    public int readVehiclesUsed() {
        Transport.ps.startOperation();
        this.vehicleUsed = new Vector();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 328960);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readVehiclesUsed####### at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "vehicle (no data)");
            TimsLogger.warn("#readVehiclesUsed# Can't find vehicleUsed");
            return 6;
        }
        offset += 3;
        try {
            Vector<Vehicule> allVehicule = Vehicule.loadList(0);
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += 2;
            SimpleDateFormat dateFormatBddHeure = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormatBddHeure.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
            while (offset < offsetEnd) {
                Vehicule tmpV = new Vehicule();
                VehicleUsed tmp = new VehicleUsed();
                tmp.setSource(VehicleUsed.CARTE);
                tmp.setCleConducteur(this.conducteur.getCleConducteur());
                tmp.setNom(this.conducteur.getNom());
                tmp.setPrenom(this.conducteur.getPrenom());
                tmp.setNumeroCarte(this.conducteur.getNumeroCarte());
                int kmDebut = Fonctions.bytesToInt(this.fileBuffer, offset, 3);
                tmp.setKmDebut(kmDebut);
                int kmFin = Fonctions.bytesToInt(this.fileBuffer, offset += 3, 3);
                tmp.setKmFin(kmFin);
                tmp.setKmEffectue(kmFin - kmDebut);
                Date insert = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset += 3, 4) * 1000L);
                tmp.setDateDebut(insert);
                Date withdraw = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4) * 1000L);
                tmp.setDateFin(withdraw);
                offset += 4;
                offset = offset + 1 + 1;
                byte[] immatriculation = new byte[13];
                int j = 0;
                while (j < immatriculation.length) {
                    immatriculation[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String sImmatriculation = new String(immatriculation).trim().replace("?", "").replace(" ", "");
                tmp.setImmatriculation(sImmatriculation);
                int ioCounter = Fonctions.bytesToInt(this.fileBuffer, offset += immatriculation.length, 2);
                offset += 2;
                if (this.maxIo < ioCounter) {
                    this.maxIo = ioCounter;
                }
                if (kmDebut == 0 && kmFin == 0 || !this.checkDay(insert) || !this.checkDay(withdraw) || kmFin > 9999999 || kmDebut > 9999999) {
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.debug("#DCP.readVehiclesUsed# Erreur de prise v\u00e9hicule");
                    tmp.print();
                    continue;
                }
                if (this.conducteur.getIoCounter() > ioCounter) {
                    TimsLogger.debug("on saute l'utilisation");
                    continue;
                }
                if (!sImmatriculation.equals(null)) {
                    tmpV = this.getVehicule(allVehicule, sImmatriculation);
                }
                if (tmpV != null) {
                    tmp.setCleVehicule(tmpV.getCleVehicule());
                } else {
                    TimsLogger.debug("#DCS.readVehiclesUsed# unknow vehicle in database (" + sImmatriculation + ") on " + insert + " (" + withdraw + ")");
                    if (!sImmatriculation.equals("") && !this.unknownImmatriculation.contains(sImmatriculation)) {
                        this.unknownImmatriculation.add(sImmatriculation);
                    }
                }
                if (this.conducteur.getIoCounter() == ioCounter) {
                    this.lastVehiclesUsed = VehicleUsed.loadListDriver(this.conducteur.getCleConducteur(), tmp.getCleVehicule(), tmp.getDateDebut(), null);
                }
                this.vehicleUsed.add(tmp);
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("Exception in readVehicles");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "vehicle (error)");
            return 3;
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "vehicle");
        return 2;
    }

    private Vehicule getVehicule(Vector<Vehicule> tmp, String sImmatriculation) {
        Vehicule toReturn = null;
        int x = 0;
        while (x < tmp.size()) {
            if (sImmatriculation.equals(tmp.get(x).getRegistrationNumber())) {
                toReturn = tmp.get(x);
                break;
            }
            ++x;
        }
        return toReturn;
    }

    public int readPlaces() {
        this.places = new Vector();
        int toReturn = this.readPlaces(1);
        if (this.hasDFG2) {
            // empty if block
        }
        return toReturn;
    }

    public int readPlaces(int version) {
        int atId = version == 1 ? 329216 : 329218;
        Transport.ps.startOperation();
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, atId);
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#######readPlaces####### (G" + version + ") " + Integer.toHexString(atId) + " at " + offset);
        }
        if (offset == -1) {
            Transport.ps.endOperation(PerformanceScanner.READING, "places (no data)");
            TimsLogger.warn("#readPlaces# Can't find places");
            return 6;
        }
        offset += 3;
        try {
            int offsetEnd = Fonctions.bytesToInt(this.fileBuffer, offset, 2) + offset + 2;
            offset += 2;
            offset += version == 2 ? 2 : 1;
            while (offset < offsetEnd) {
                Date lastChange;
                int km;
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 1) == 0) {
                    offset += version == 2 ? DriverCardProperty.sizeOfPlaceG2 : DriverCardProperty.sizeOfPlaceG1;
                    continue;
                }
                if (version == 2) {
                    TimsLogger.debug("#DCS.readPlaces# offset = " + offset);
                }
                Date time = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                int type = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
                int pays = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                int region = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                if ((km = Fonctions.bytesToInt(this.fileBuffer, ++offset, 3)) == 0xFFFFFF) {
                    km = 0;
                }
                offset += 3;
                if (version == 2) {
                    TimsLogger.debug("#DCS.readPlaces(2)# add GNSS at " + time);
                    this.addGNSSPlace(this.fileBuffer, offset, GNSSPlace.POINT_TYPE.PLACE_DETAIL, false, false);
                    offset += 11;
                    continue;
                }
                Place tmp = new Place(0, this.conducteur.getCleConducteur(), type, new Date(time.getTime()), km, pays, region);
                if (Transport.debug >= 1) {
                    tmp.affiche();
                }
                if ((lastChange = ConversionTime.stringToDateDb(this.conducteur.getDernierChangement())) != null && !tmp.getDateTime().after(lastChange)) continue;
                this.places.add(tmp);
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("Exception in readPlaces");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "places (error)");
            return 3;
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "places");
        return 2;
    }

    public int readActivity() {
        int toReturn = this.readActivity(1);
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readActivity(int version) {
        ChangementActivite change;
        Transport.ps.startOperation();
        int atId = version == 2 ? 328706 : 328704;
        try {
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("UTC"));
            this.kmJour = new Hashtable();
            this.errors = new Vector();
            boolean dernierJour = false;
            int length = DriverCardProperty.sizeOfDriverActivityData;
            int offset = this.cardProperty.getOffsetFile(this.fileBuffer, atId);
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#######readActivity####### read " + Integer.toHexString(atId) + " at " + offset);
            }
            if (offset == -1) {
                Transport.ps.endOperation(PerformanceScanner.READING, "activity (no data)");
                TimsLogger.warn("#readActivity# Can't find activities");
                return 3;
            }
            int activityPointerOldestDayRecord = Fonctions.bytesToInt(this.fileBuffer, offset += 5, 2);
            int activityPointerNewestDayRecord = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
            TimsLogger.debug("#CDP# offset begin : " + Integer.toHexString(offset += 2) + ", oldest activity at " + Integer.toHexString(offset + activityPointerOldestDayRecord) + ", newest activity at " + Integer.toHexString(offset + activityPointerNewestDayRecord));
            int offsetDebutTab = offset;
            offset = 0;
            if ((offset + activityPointerOldestDayRecord) % (length -= 9) == activityPointerNewestDayRecord) {
                byte[] tmpbuf2bytes = new byte[]{this.fileBuffer[offsetDebutTab + ((offset += 2) + activityPointerOldestDayRecord) % length], this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length]};
                ++offset;
                int activityRecordLength = Fonctions.bytesToInt(tmpbuf2bytes, 0, 2);
                offset -= 4;
                if (activityRecordLength == 0) {
                    return 6;
                }
                TimsLogger.debug("#CDP# une seule journ\u00e9e");
            }
            boolean emptyDay = false;
            boolean lastIsError = false;
            int emptyDayCount = 0;
            while (!dernierJour) {
                TimsLogger.debug("#CDP# BEGIN DAY - offset day 0x" + Integer.toHexString(offsetDebutTab + (offset + activityPointerOldestDayRecord) % length) + " offsetDebutTab : 0x" + Integer.toHexString(offsetDebutTab) + " offset : 0x" + Integer.toHexString(offset) + " activityPointerOldestDayRecord : 0x" + Integer.toHexString(activityPointerOldestDayRecord) + " length : " + length);
                ++this.dayCount;
                boolean report = false;
                int debut = this.activityChangeInfo.size();
                int lastUTCTimeActivity = 0;
                if ((offset + activityPointerOldestDayRecord) % length == activityPointerNewestDayRecord) {
                    dernierJour = true;
                }
                byte[] tmpbuf2bytes = new byte[]{this.fileBuffer[offsetDebutTab + ((offset += 2) + activityPointerOldestDayRecord) % length], this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length]};
                int activityRecordLength = Fonctions.bytesToInt(tmpbuf2bytes, 0, 2);
                byte[] tmpbufARD = new byte[]{this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length], this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length], this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length], this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length]};
                ++offset;
                int dateInt = Fonctions.bytesToInt(tmpbufARD, 0, 4);
                TimsLogger.debug(" #CDP# date timestamp " + dateInt);
                cal.setTimeInMillis((long)dateInt * 1000L);
                Date dateJour = cal.getTime();
                if (dateJour.getTime() == 0L && activityRecordLength == 16) {
                    TimsLogger.debug("#CDP.readActivity# emptyDay has been detected");
                    offset += activityRecordLength - 8;
                    emptyDay = true;
                    ++emptyDayCount;
                    continue;
                }
                if (!this.checkDay(dateJour) && !emptyDay) {
                    if (lastIsError) {
                        TimsLogger.debug("#CDP.readActivity# " + dateJour + " out of range for the second time in a row");
                        return 11;
                    }
                    offset += activityRecordLength - 8;
                    TimsLogger.debug("#CDP.readActivity# " + dateJour + " out of range");
                    lastIsError = true;
                    continue;
                }
                emptyDay = false;
                int decalageHoraire = this.setDecalageHoraire(dateJour);
                tmpbuf2bytes[0] = this.fileBuffer[offsetDebutTab + ((offset += 2) + activityPointerOldestDayRecord) % length];
                tmpbuf2bytes[1] = this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length];
                ++offset;
                int km = Fonctions.bytesToInt(tmpbuf2bytes, 0, 2);
                this.kmJour.put(dateJour, km);
                TimsLogger.debug(" #CDP# " + dateJour + " (" + (activityRecordLength - 12) / 2 + " act) - +" + decalageHoraire);
                int i = 0;
                while (i < (activityRecordLength - 12) / 2) {
                    block32: {
                        ChangementActivite activityChange;
                        block28: {
                            block30: {
                                int nbJour;
                                ChangementActivite lastAct;
                                block31: {
                                    block29: {
                                        tmpbuf2bytes[0] = this.fileBuffer[offsetDebutTab + (offset + activityPointerOldestDayRecord) % length];
                                        tmpbuf2bytes[1] = this.fileBuffer[offsetDebutTab + (++offset + activityPointerOldestDayRecord) % length];
                                        ++offset;
                                        activityChange = DriverCardProperty.getDetailActivite(tmpbuf2bytes, dateJour, "CAP", this.toRead.getName());
                                        if (Transport.apiMode == 0 && Transport.debug >= 3) {
                                            TimsLogger.debug(" || " + activityChange.getHeure() + "(" + activityChange.getTypeActivite() + ") =>");
                                        }
                                        if (lastUTCTimeActivity > activityChange.getHeure()) {
                                            boolean chevauchement = false;
                                            if (Transport.apiMode == 0 && Transport.debug >= 1) {
                                                TimsLogger.debug(" ** lastUTCTimeActivity > activityChange.getHeure() (" + lastUTCTimeActivity + " > " + activityChange.getHeure() + ") * (" + this.eventFault.size() + " event), ");
                                            }
                                            for (CardEventsFaults event : this.eventFault) {
                                                if (event.getType() != 3 || Math.abs(ConversionTime.getDaysBetween(event.getDateDebut(), dateJour)) > 1) continue;
                                                if (Transport.apiMode == 0 && Transport.debug >= 1) {
                                                    TimsLogger.debug("c'est a priori un chevauchement temporel **");
                                                    TimsLogger.debug(String.valueOf(event.getType()) + " " + event.getImmatriculationVehicule() + " " + event.getDateDebut() + " " + event.getDateFin());
                                                }
                                                chevauchement = true;
                                            }
                                            if (!chevauchement) {
                                                Date lastDay;
                                                String toAdd = ConversionTime.dateToString(dateJour, "dd/MM/yyyy");
                                                if (this.conducteur != null && dateJour.after(ConversionTime.addDay(lastDay = ConversionTime.stringToDate(this.conducteur.getDernierChangement(), "yyyy-MM-dd"), -1)) && !this.errors.contains(toAdd)) {
                                                    TimsLogger.info("erreur d\u00e9tect\u00e9e sur " + toAdd);
                                                    this.errors.add(toAdd);
                                                }
                                                activityChange.setHeure(lastUTCTimeActivity + 1);
                                            }
                                        }
                                        lastUTCTimeActivity = activityChange.getHeure();
                                        if (!activityChange.setHeure(activityChange.getHeure() + decalageHoraire) || report) break block29;
                                        ChangementActivite tmp = (ChangementActivite)this.activityChangeInfo.get(this.activityChangeInfo.size() - 1).clone();
                                        tmp.setHeure(1440);
                                        TimsLogger.debug(" & " + tmp.getHeure() + "(" + tmp.getTypeActivite() + ")");
                                        this.activityChangeInfo.add(tmp);
                                        report = true;
                                        break block28;
                                    }
                                    if (activityChange.getHeure() != decalageHoraire) break block28;
                                    if (this.activityChangeInfo.size() == 0) break block30;
                                    lastAct = this.activityChangeInfo.get(this.activityChangeInfo.size() - 1);
                                    nbJour = ConversionTime.getDaysBetween(lastAct.getDate(), activityChange.getDate());
                                    if (nbJour != 0) break block31;
                                    if (lastAct.getTypeActivite() != activityChange.getTypeActivite()) break block28;
                                    break block32;
                                }
                                if (nbJour == 1) {
                                    if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                        activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                        break block28;
                                    } else {
                                        ChangementActivite tmp = (ChangementActivite)this.activityChangeInfo.get(this.activityChangeInfo.size() - 1).clone();
                                        tmp.setHeure(1440);
                                        TimsLogger.debug(" && " + tmp.getHeure() + "(" + tmp.getTypeActivite() + ")");
                                        this.activityChangeInfo.add(tmp);
                                    }
                                    break block28;
                                } else if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                    activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                }
                                break block28;
                            }
                            activityChange.setHeure(0);
                        }
                        TimsLogger.verbose(" + " + activityChange.getHeure() + "(" + activityChange.getTypeActivite() + ")");
                        this.activityChangeInfo.add(activityChange);
                    }
                    ++i;
                }
                if (this.jourToEte) {
                    this.setDecalageToEte(debut);
                }
                if (this.jourToHiver) {
                    this.setDecalageToHiver(debut);
                }
                TimsLogger.debug("#CDP# END DAY");
            }
            for (String error : this.errors) {
                TimsLogger.warn("#CDP# error on " + error);
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("Exception in readActivity");
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.READING, "activity (error)");
            return 3;
        }
        if (this.activityChangeInfo.size() != 0 && (change = this.activityChangeInfo.get(this.activityChangeInfo.size() - 1)).getTypeActivite() != 7 && change.getTypeActivite() != 4) {
            TimsLogger.debug("#CDP# la derni\u00e8re activit\u00e9 n'est pas du repos, pour \u00e9viter tout pb, on la passe en inconnu...");
            change.setTypeActivite(7);
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "activity");
        return 2;
    }

    private boolean checkDay(Date day) {
        return day.after(ConversionTime.stringToDate("01/01/2000", "dd/MM/yyyy")) && day.before(ConversionTime.addDay(new Date(), 365));
    }

    public int setDecalageHoraire(Date dateJour) {
        this.jourToEte = false;
        this.jourToHiver = false;
        this.jourHiverToEte = Fonctions.getDateHeureEte(dateJour);
        this.jourEteToHiver = Fonctions.getDateHeureHiver(dateJour);
        if (dateJour.after(this.jourHiverToEte) && dateJour.before(this.jourEteToHiver)) {
            return 120;
        }
        if (this.jourHiverToEte.equals(dateJour)) {
            this.jourToEte = true;
            return 60;
        }
        if (this.jourEteToHiver.equals(dateJour)) {
            this.jourToHiver = true;
            return 120;
        }
        return 60;
    }

    public void setDecalageToEte(int debut) {
        TimsLogger.debug("#CDP.setDecalageToEte# avant");
        int y = debut;
        while (y < this.activityChangeInfo.size()) {
            if (Transport.debug >= 1) {
                this.activityChangeInfo.get(y).affiche();
            }
            ++y;
        }
        TimsLogger.debug("############################");
        boolean decalage = false;
        boolean report = false;
        int x = debut;
        while (x < this.activityChangeInfo.size()) {
            ChangementActivite tmp = this.activityChangeInfo.get(x);
            if (decalage) {
                if (this.activityChangeInfo.get(x).setHeure(this.activityChangeInfo.get(x).getHeure() + 60) && !report) {
                    ChangementActivite chg = (ChangementActivite)this.activityChangeInfo.get(x - 1).clone();
                    chg.setHeure(1440);
                    this.activityChangeInfo.add(x, chg);
                    report = true;
                    ++x;
                }
            } else if (tmp.getHeure() > 120) {
                ChangementActivite activite = (ChangementActivite)this.activityChangeInfo.get(x - 1).clone();
                String sDecalage = "DECALAGE HORAIRE";
                ChangementActivite activiteDecalage = new ChangementActivite(4, this.jourHiverToEte, 120, sDecalage, sDecalage, sDecalage, sDecalage, sDecalage);
                this.activityChangeInfo.add(x, activiteDecalage);
                activite.setHeure(180);
                this.activityChangeInfo.add(++x, activite);
                ++x;
                decalage = true;
                if (tmp.setHeure(tmp.getHeure() + 60) && !report) {
                    ChangementActivite chg = (ChangementActivite)this.activityChangeInfo.get(x - 1).clone();
                    chg.setHeure(1440);
                    this.activityChangeInfo.add(x, chg);
                    report = true;
                    ++x;
                }
            }
            ++x;
        }
        TimsLogger.debug("#CDP.setDecalageToEte# apres");
        int y2 = debut;
        while (y2 < this.activityChangeInfo.size()) {
            if (Transport.debug >= 1) {
                this.activityChangeInfo.get(y2).affiche();
            }
            ++y2;
        }
        TimsLogger.debug("############################");
    }

    public void setDecalageToHiver(int debut) {
        TimsLogger.debug("#CDP.setDecalageToHiver# D\u00e9calage to HIVER");
        TimsLogger.debug("#CDP.setDecalageToHiver# Before");
        int y = debut;
        while (y < this.activityChangeInfo.size()) {
            if (Transport.debug >= 1) {
                this.activityChangeInfo.get(y).affiche();
            }
            ++y;
        }
        boolean previousDay = false;
        boolean decalage = false;
        int x = debut;
        int duree = 0;
        while (x < this.activityChangeInfo.size()) {
            ChangementActivite tmp = this.activityChangeInfo.get(x);
            if (decalage) {
                boolean dayChanged = this.activityChangeInfo.get(x).setHeure(this.activityChangeInfo.get(x).getHeure() - 60);
                TimsLogger.debug("#CDP.setDecalageToHiver# " + dayChanged + " " + previousDay);
                if (dayChanged && !previousDay) {
                    previousDay = true;
                    TimsLogger.debug("#CDP.setDecalageToHiver# on change de jour !");
                } else if (previousDay) {
                    ChangementActivite midnight;
                    if (!dayChanged) {
                        TimsLogger.debug("#CDP.setDecalageToHiver# dayChanged&previousDay");
                        midnight = (ChangementActivite)this.activityChangeInfo.get(x - 1).clone();
                        midnight.setHeure(1440);
                        this.activityChangeInfo.add(x, midnight);
                        ++x;
                        previousDay = false;
                    } else if (x == this.activityChangeInfo.size() - 1) {
                        TimsLogger.debug("#CDP.setDecalageToHiver# activityChangeInfo.size()-1");
                        midnight = (ChangementActivite)this.activityChangeInfo.get(x).clone();
                        midnight.setHeure(1440);
                        this.activityChangeInfo.add(midnight);
                        ++x;
                        previousDay = false;
                    }
                }
            } else {
                int heureFin = x < this.activityChangeInfo.size() - 1 ? this.activityChangeInfo.get(x + 1).getHeure() : 1440;
                duree = heureFin - this.activityChangeInfo.get(x).getHeure();
                if ((tmp.getTypeActivite() == 4 || tmp.getTypeActivite() == 7) && duree > 60) {
                    decalage = true;
                }
            }
            ++x;
        }
        TimsLogger.debug("#CDP# After");
        int y2 = debut;
        while (y2 < this.activityChangeInfo.size()) {
            if (Transport.debug >= 1) {
                this.activityChangeInfo.get(y2).affiche();
            }
            ++y2;
        }
        TimsLogger.debug("#CDP# D\u00e9calage to HIVER");
    }

    public boolean addDriver() {
        if (Transport.apiMode == 1) {
            TimsLogger.debug("#DCS.addDriver# apiMode enabled, force creation");
            this.conducteur.insert();
            return this.conducteur.loadByCard(this.conducteur.getNumeroCarte(), this.conducteur.getMemberState(), 0);
        }
        Conducteur newDriver = new Conducteur();
        if (newDriver.loadByCard(this.conducteur.getNumeroCarte(), this.conducteur.getMemberState(), 1)) {
            String agencyDes = LanguageTranslator.getString("generics.unknown");
            Agence agency = Agence.find(Agence.getList(), this.conducteur.getCleAgence());
            if (agency != null) {
                agencyDes = agency.getDescription();
            }
            SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("card.archiveDriver", agencyDes), LanguageTranslator.getString("card.reading.title", this.conducteur.getNom()));
            tmp.run();
            if (tmp.option == 0) {
                newDriver.setNom(this.conducteur.getNom());
                newDriver.setPrenom(this.conducteur.getPrenom());
                newDriver.setNumeroCarte(this.conducteur.getNumeroCarte());
                newDriver.setMemberState(this.conducteur.getMemberState());
                newDriver.setReplacement(this.conducteur.getReplacement());
                newDriver.setRenewal(this.conducteur.getRenewal());
                newDriver.setDateDebutValiditeCarte(this.conducteur.getDateDebutValiditeCarte());
                newDriver.setDateFinValiditeCarte(this.conducteur.getDateFinValiditeCarte());
                newDriver.setDateNaissance(this.conducteur.getDateNaissance());
                if (this.licenseNumber != null) {
                    this.conducteur.setNumeroPermis(this.licenseNumber);
                }
                newDriver.setDateSortie("");
                newDriver.setArchive(0);
                this.conducteur = newDriver;
                return this.conducteur.update();
            }
            newDriver = new Conducteur();
            newDriver.setNom(this.conducteur.getNom());
            newDriver.setPrenom(this.conducteur.getPrenom());
            newDriver.setNumeroCarte(this.conducteur.getNumeroCarte());
            newDriver.setMemberState(this.conducteur.getMemberState());
            newDriver.setReplacement(this.conducteur.getReplacement());
            newDriver.setRenewal(this.conducteur.getRenewal());
            newDriver.setDateDebutValiditeCarte(this.conducteur.getDateDebutValiditeCarte());
            newDriver.setDateFinValiditeCarte(this.conducteur.getDateFinValiditeCarte());
            newDriver.setDateNaissance(this.conducteur.getDateNaissance());
            if (this.licenseNumber != null) {
                this.conducteur.setNumeroPermis(this.licenseNumber);
            }
            TimsLogger.debug("#DCS.readIdentification# New card driver detected");
            this.conducteur = newDriver;
        }
        if (Conducteur.loadList(new Integer[0]).size() < LicenceManager.DRIVER_AUTHORIZED) {
            Object[] choix = new String[]{LanguageTranslator.getString("button.quit"), LanguageTranslator.getString("button.affect"), LanguageTranslator.getString("button.create")};
            if (!ConnexionSettings.getInstance().isAjoutable("CONDUCTEUR")) {
                choix = new String[]{LanguageTranslator.getString("button.quit"), LanguageTranslator.getString("button.affect")};
            }
            int choixCreation = JOptionPane.showOptionDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.unknownDriver", this.conducteur.getNom(), this.conducteur.getPrenom()), LanguageTranslator.getString("card.reading.title", this.conducteur.getNom()), 0, 1, null, choix, null);
            switch (choixCreation) {
                case 2: {
                    DialogCreationConducteur creation = new DialogCreationConducteur((Frame)MainFrameTransport.getInstance(), this.conducteur);
                    creation.setVisible(true);
                    if (creation.enregistrement) {
                        return this.conducteur.loadByCard(this.conducteur.getNumeroCarte(), this.conducteur.getMemberState(), 0);
                    }
                    return false;
                }
                case 1: {
                    AffectationConducteur affectation = new AffectationConducteur((Frame)MainFrameTransport.getInstance(), this.conducteur);
                    affectation.preSelection();
                    affectation.setVisible(true);
                    if (affectation.enregistrer) {
                        return this.conducteur.loadByCard(this.conducteur.getNumeroCarte(), this.conducteur.getMemberState(), 0);
                    }
                    return false;
                }
            }
            return false;
        }
        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("driver.maxExceeded", String.valueOf(LicenceManager.DRIVER_AUTHORIZED)), LanguageTranslator.getString("message.numberedError", "91"), 0, new ImageIcon(MainFrameTransport.getInstance().getIconImage()));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int saveInfos() {
        String dateTelechargement;
        Transport.ps.startOperation();
        Date lastExport = null;
        int cleConducteur = this.conducteur.getCleConducteur();
        String string = dateTelechargement = this.conducteur.getDernierChangement() == null || this.conducteur.getDernierChangement().equals("") ? "1970-01-01 00:00:00" : this.conducteur.getDernierChangement().substring(0, 19);
        if (dateTelechargement.compareTo(this.getDernierChangement()) >= 0) {
            Transport.ps.endOperation(PerformanceScanner.INSERT, "card total");
            return 1;
        }
        if (System.getProperty("horoquartz", "0").equals("1")) {
            lastExport = BddTransport.getInstance().getLastExport(cleConducteur);
        }
        int random = (int)(Math.random() * 1000.0);
        String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
        while (new File(dayFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
        }
        String vehicleUsedFn = String.valueOf(Transport.savePath) + "priseVehicule" + random + ".txt";
        String placeFn = String.valueOf(Transport.savePath) + "place" + random + ".txt";
        String specFn = String.valueOf(Transport.savePath) + "spec" + random + ".txt";
        String gnssFn = String.valueOf(Transport.savePath) + "gnss" + random + ".txt";
        String loadFn = String.valueOf(Transport.savePath) + "load" + random + ".txt";
        try {
            FileWriter fluxDay = new FileWriter(dayFn);
            FileWriter fluxVehicle = new FileWriter(vehicleUsedFn);
            FileWriter fluxPlaces = new FileWriter(placeFn);
            FileWriter fluxSpecific = new FileWriter(specFn);
            FileWriter fluxGnss = new FileWriter(gnssFn);
            FileWriter fluxLoad = new FileWriter(loadFn);
            int x = this.getBegin();
            if (Transport.apiMode == 0) {
                this.getProgression().setVisible(true);
                this.getProgression().getBar().setMinimum(0);
                this.getProgression().getBar().setMaximum(this.dayCount);
            }
            int traitementJour = 0;
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            while (x < this.activityChangeInfo.size()) {
                int duree;
                if (Transport.apiMode == 0) {
                    this.getProgression().getBar().setValue(traitementJour);
                    this.getProgression().getBar().setString(LanguageTranslator.getString("card.analysis", String.valueOf(traitementJour)));
                }
                ChangementActivite tmp = this.activityChangeInfo.get(x);
                int heureFin = 1440;
                if (x != this.activityChangeInfo.size() - 1 && ConversionTime.dateToString(this.activityChangeInfo.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    heureFin = this.activityChangeInfo.get(x + 1).getHeure();
                }
                if ((duree = heureFin - tmp.getHeure()) != 0) {
                    ActiviteConducteur toAdd = new ActiviteConducteur(cleConducteur, this.conducteur.getCleAgence(), tmp.getTypeActivite(), "", tmp.getHeure(), heureFin, duree, ConversionTime.dateToString(tmp.getDate(), "yyyy-MM-dd"), tmp.getSource(), tmp.getNomSource(), tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), 0);
                    toAdd.affiche();
                    tmpJour.add(toAdd);
                }
                if (x == this.activityChangeInfo.size() - 1 || !ConversionTime.dateToString(this.activityChangeInfo.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    int km;
                    String dateJour = ConversionTime.dateToString(this.activityChangeInfo.get(x).getDate(), "yyyy-MM-dd");
                    boolean manualInput = false;
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    int n = km = this.kmJour.get(this.activityChangeInfo.get(x).getDate()) == null ? 0 : this.kmJour.get(this.activityChangeInfo.get(x).getDate());
                    if (!this.conducteur.getDateSortie().equals("") && ConversionTime.compare(dateJour, this.conducteur.getDateSortie().substring(0, 10), "yyyy-MM-dd") > 0) {
                        TimsLogger.debug("#CardDriverData.stockActivite# conducteur deja sorti =" + dateJour);
                    } else if (Transport.bdd.getJourCle(this.conducteur.getCleConducteur(), dateJour) != "") {
                        GestionChevauchement chev = new GestionChevauchement(tmpJour, this.conducteur, dateJour, km, fluxDay, this.toRead.getName());
                        if (chev.activityAdded() && this.firstDay == null) {
                            this.firstDay = dateJour;
                        }
                    } else if (!this.conducteur.getDateEntree().equals("") && ConversionTime.compare(dateJour, this.conducteur.getDateEntree().substring(0, 10), "yyyy-MM-dd") < 0) {
                        TimsLogger.debug("#CardDriverData.stockActivite# conducteur pas encore rentr\u00e9 =" + dateJour + " (" + this.conducteur.getDateEntree() + ")");
                    } else {
                        int y = 0;
                        while (y < tmpJour.size()) {
                            ActiviteConducteur act = tmpJour.get(y);
                            if (this.firstDay == null && act.getCleType() != 4 && act.getCleType() != 7) {
                                this.firstDay = act.getDateJour();
                                TimsLogger.debug("#DriverCardSaving.saveInfos# Premier jour d'activit\u00e9 (hors repos et inconnu) : " + this.firstDay);
                            }
                            if (act.isManualInput()) {
                                manualInput = true;
                            }
                            switch (act.getCleType()) {
                                case 1: {
                                    conduite += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 2: {
                                    travail += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 3: {
                                    dispo += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 4: {
                                    repos += act.getDuree();
                                    break;
                                }
                                case 5: {
                                    de += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 7: {
                                    inconnu += act.getDuree();
                                    break;
                                }
                                default: {
                                    TimsLogger.warn("#DCP.stockActivite()# activit\u00e9s inconnue " + act.getCleType());
                                }
                            }
                            ++y;
                        }
                        Jour detailJour = new Jour(0, this.conducteur.getCleConducteur(), dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, km, 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), this.toRead.getName(), manualInput);
                        if (System.getProperty("SGBDR", "mysql").equals("oracle") && !detailJour.insert()) {
                            TimsLogger.warn("#DCP.stockActivite()# unable to save day");
                            Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                            return 4;
                        }
                        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                            TimsLogger.debug("to Hex : " + detailJour.getDate() + " => " + Fonctions.parseHexAscii(ActiviteConducteur.toCondensed(tmpJour), 0, -1));
                            fluxDay.write(detailJour.getSQLInsert());
                            fluxDay.write("\n");
                        }
                        if (System.getProperty("horoquartz", "0").equals("1") && lastExport != null && (this.activityChangeInfo.get(x).getDate().before(lastExport) || this.activityChangeInfo.get(x).getDate().equals(lastExport))) {
                            BddTransport.getInstance().updateExportHoroquartz(this.conducteur.getCleConducteur(), detailJour.getDate());
                        }
                    }
                    ++traitementJour;
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour.clear();
                }
                ++x;
            }
            if (this.lastVehiclesUsed != null) {
                TimsLogger.debug("#DCS.readVehiclesUsed# On supprime " + this.lastVehiclesUsed.size() + " prises v\u00e9hicules au titre de la derni\u00e8re insertion");
                for (VehicleUsed delete : this.lastVehiclesUsed) {
                    delete.delete("driver_vehicle_used");
                }
            }
            int y = 0;
            while (y < this.vehicleUsed.size()) {
                VehicleUsed tmp = this.vehicleUsed.get(y);
                String begin = ConversionTime.dateToString(tmp.getDateDebut(), "yyyy-MM-dd HH:mm:ss");
                if (!this.conducteur.getDateSortie().equals("") && ConversionTime.compare(begin.substring(0, 10), this.conducteur.getDateSortie().substring(0, 10), "yyyy-MM-dd") > 0) {
                    TimsLogger.debug("#DCP.stockActivite# conducteur deja sorti =" + tmp.getDateDebut());
                } else if (this.conducteur.getDateEntree().equals("") || ConversionTime.compare(begin, this.conducteur.getDateEntree().substring(0, 10), "yyyy-MM-dd") >= 0) {
                    if (System.getProperty("SGBDR", "mysql").equals("oracle") && !tmp.insert("driver_vehicle_used")) {
                        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                        return 4;
                    }
                    if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                        String sqlUtilVehicule = tmp.getSQLInsert();
                        fluxVehicle.write(sqlUtilVehicule);
                        fluxVehicle.write("\n");
                    }
                }
                ++y;
            }
            TimsLogger.debug("#CDP.saveInfos()# set maxIO to " + this.maxIo);
            this.conducteur.setIoCounter(this.maxIo);
            for (Place ins : this.places) {
                if (!this.conducteur.getDateSortie().equals("") && ins.getDateTime().after(ConversionTime.stringToDate(this.conducteur.getDateSortie(), "yyyy-MM-dd"))) {
                    TimsLogger.debug("#DCP.stockActivite# conducteur deja sorti =" + ins.getDateTime());
                    continue;
                }
                if (!this.conducteur.getDateEntree().equals("") && ins.getDateTime().before(ConversionTime.stringToDate(this.conducteur.getDateEntree(), "yyyy-MM-dd"))) {
                    TimsLogger.debug("#DCP.stockActivite# conducteur pas encore rentr\u00e9 =" + ins.getDateTime() + " (" + this.conducteur.getDateEntree() + ")");
                    continue;
                }
                if (System.getProperty("SGBDR", "mysql").equals("oracle") && !ins.insert()) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                    return 4;
                }
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                TimsLogger.debug("#DCS.saveInfos()# on ajoute le lieux " + ins.getSqlString());
                String sqlPlaces = ins.getSqlString();
                fluxPlaces.write(sqlPlaces);
                fluxPlaces.write("\n");
            }
            for (SpecificCondition ins : this.specificCondition) {
                if (!this.shouldAdd(ins.getSpecificTimestamp())) continue;
                if (System.getProperty("SGBDR", "mysql").equals("oracle") && !ins.insert()) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                    return 4;
                }
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                TimsLogger.debug("#DCS.saveInfos()# on ajoute la condition " + ins.getSqlString());
                String sqlSec = ins.getSqlString();
                fluxSpecific.write(sqlSec);
                fluxSpecific.write("\n");
            }
            if (this.gnssPlaces != null) {
                TimsLogger.debug("#DCS.saveInfos()# G2 : GNSS presents");
                for (GNSSPlace toAdd : this.gnssPlaces) {
                    if (!this.shouldAdd(toAdd.getPointTime())) continue;
                    if (System.getProperty("SGBDR", "mysql").equals("oracle") && !toAdd.insert()) {
                        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                        return 4;
                    }
                    if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                    TimsLogger.debug("#DCS.saveInfos()# on ajoute la coordonn\u00e9e GNSS " + toAdd.getSqlString());
                    String sql = toAdd.getSqlString();
                    fluxGnss.write(sql);
                    fluxGnss.write("\n");
                }
            }
            if (this.loadUnloads != null) {
                TimsLogger.debug("#DCS.saveInfos()# G2 : GNSS presents");
                for (LoadUnload toAdd : this.loadUnloads) {
                    if (!this.shouldAdd(toAdd.getTimestamp())) continue;
                    if (System.getProperty("SGBDR", "mysql").equals("oracle") && !toAdd.insert()) {
                        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
                        return 4;
                    }
                    if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                    TimsLogger.debug("#DCS.saveInfos()# on ajoute le chargement/d\u00e9chargement " + toAdd.getSqlString());
                    String sql = toAdd.getSqlString();
                    fluxGnss.write(sql);
                    fluxGnss.write("\n");
                }
            }
            fluxDay.close();
            fluxVehicle.close();
            fluxPlaces.close();
            fluxSpecific.close();
            fluxGnss.close();
            fluxLoad.close();
            if (Transport.apiMode == 0) {
                this.getProgression().getBar().setMinimum(0);
                this.getProgression().getBar().setMaximum(8);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    this.getProgression().getBar().setValue(2);
                    this.getProgression().getBar().setString(LanguageTranslator.getString("card.daySaving"));
                }
                if (!Transport.bdd.loadDay(dayFn)) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                    return 10;
                }
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card day");
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    this.getProgression().getBar().setValue(3);
                    this.getProgression().getBar().setString(LanguageTranslator.getString("card.vehicleUsedSaving"));
                }
                if (!Transport.bdd.loadVehicleUsed(vehicleUsedFn, "driver_vehicle_used")) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                    return 10;
                }
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card vehicles used");
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    this.getProgression().getBar().setValue(4);
                    this.getProgression().getBar().setString(LanguageTranslator.getString("card.specificSaving"));
                }
                if (!Transport.bdd.loadSpecific(specFn)) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                    return 10;
                }
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card specific");
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    this.getProgression().getBar().setValue(5);
                    this.getProgression().getBar().setString(LanguageTranslator.getString("card.placeSaving"));
                }
                if (!Transport.bdd.loadDriverPlaces(placeFn)) {
                    Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                    return 10;
                }
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card places");
                if (this.gnssPlaces != null) {
                    Transport.ps.startOperation();
                    if (Transport.apiMode == 0) {
                        this.getProgression().getBar().setValue(6);
                        this.getProgression().getBar().setString(LanguageTranslator.getString("card.gnssSaving"));
                    }
                    if (!Transport.bdd.loadGnss(gnssFn)) {
                        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                        return 10;
                    }
                    Transport.ps.endOperation(PerformanceScanner.INSERT, "gnss places");
                }
                if (this.loadUnloads != null) {
                    Transport.ps.startOperation();
                    if (Transport.apiMode == 0) {
                        this.getProgression().getBar().setValue(7);
                        this.getProgression().getBar().setString(LanguageTranslator.getString("card.loadUnload"));
                    }
                    if (!Transport.bdd.loadLoadUnload(loadFn)) {
                        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn, loadFn);
                        return 10;
                    }
                    Transport.ps.endOperation(PerformanceScanner.INSERT, "load places");
                }
            }
            Transport.ps.startOperation();
            if (Transport.apiMode == 0) {
                this.getProgression().getBar().setValue(7);
                this.getProgression().getBar().setString(LanguageTranslator.getString("card.serviceUpdating"));
            }
            this.majService();
            this.updateHardness();
            Transport.ps.endOperation(PerformanceScanner.UPDATE, "service");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Transport.ps.endOperation(PerformanceScanner.INSERT, "card total (error)");
            Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
            return 4;
        }
        Transport.ps.endOperation(PerformanceScanner.INSERT, "card total");
        Fonctions.deleteFile(dayFn, vehicleUsedFn, placeFn, specFn, gnssFn);
        return 2;
    }

    private boolean shouldAdd(Date date) {
        if (!date.after(ConversionTime.stringToDateDb(this.conducteur.getDernierChangement(), true))) {
            TimsLogger.debug("#DCP.shouldAdd# = date d\u00e9j\u00e0 ins\u00e9r\u00e9e");
            return false;
        }
        if (!this.conducteur.getDateSortie().equals("") && date.after(ConversionTime.stringToDateDb(this.conducteur.getDateSortie(), false))) {
            TimsLogger.debug("#DCP.shouldAdd# conducteur deja sorti =" + date);
            return true;
        }
        if (!this.conducteur.getDateEntree().equals("") && date.before(ConversionTime.stringToDateDb(this.conducteur.getDateEntree(), false))) {
            TimsLogger.debug("#DCP.shouldAdd# conducteur pas encore rentr\u00e9 =" + date + " (" + this.conducteur.getDateEntree() + ")");
            return false;
        }
        return true;
    }

    public void majService() {
        if (this.firstDay == null) {
            TimsLogger.debug("#DCS.majService()# pas de date de d\u00e9but pour l'analyse des services");
            return;
        }
        TraitementTempsService tts = new TraitementTempsService(this.conducteur, this.firstDay, this.getDernierChangement(), true);
        try {
            Transport.ps.startOperation();
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DCS.majService# service calculation time");
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
    }

    public void updateHardness() {
        String firstYear = ConversionTime.dateToString(this.getFirstActivityToInsert(), "yyyy");
        String secondYear = this.getDernierChangement().substring(0, 4);
        if ("1".equals(System.getProperty("hardness.automatic.recalculate", "0"))) {
            GlobalHardnessCalculator ghc = new GlobalHardnessCalculator(null, this.conducteur, this.getFirstActivityToInsert());
            ghc.launch();
            if (!firstYear.equals(secondYear)) {
                ghc = new GlobalHardnessCalculator(null, this.conducteur, ConversionTime.stringToDate(String.valueOf(secondYear) + "-01-01", "yyyy-MM-dd"));
                ghc.launch();
            }
        } else {
            HardnessAttribution.disable(this.conducteur.getCleConducteur(), -1, firstYear);
            if (!firstYear.equals(secondYear)) {
                HardnessAttribution.disable(this.conducteur.getCleConducteur(), -1, secondYear);
            }
        }
    }

    public int getBegin() {
        TimsLogger.debug("#DCP.getBegin# On entre dans getBegin : " + this.activityChangeInfo.size() + " activit\u00e9s");
        if (this.beginIdxReminder == -1) {
            int x = 0;
            Date dernierChangement = ConversionTime.stringToDate(this.conducteur.getDernierChangement(), "yyyy-MM-dd");
            while (x < this.activityChangeInfo.size()) {
                Date dateAct = this.activityChangeInfo.get(x).getDate();
                if (x != 0 && dateAct.after(this.activityChangeInfo.get(x - 1).getDate())) {
                    --this.dayCount;
                }
                if (dateAct.after(dernierChangement) || dateAct.equals(dernierChangement)) break;
                ++x;
            }
            this.beginIdxReminder = x;
        }
        return this.beginIdxReminder;
    }

    public String getCardNumber() {
        if (!this.fileReaden) {
            this.readFile();
        }
        int offset = this.cardProperty.getOffsetFile(this.fileBuffer, 335872) + 6;
        byte[] cardNumber = new byte[16];
        int i = 0;
        while (i < cardNumber.length) {
            cardNumber[i] = this.fileBuffer[offset + i];
            ++i;
        }
        return new String(cardNumber).trim();
    }

    public String getMemberState() {
        int offset;
        int cardIssuingMemberState;
        if (!this.fileReaden) {
            this.readFile();
        }
        if (Pays.LIBELLE.length <= (cardIssuingMemberState = Fonctions.bytesToInt(this.fileBuffer, offset = this.cardProperty.getOffsetFile(this.fileBuffer, 335872) + 5, 1))) {
            return Pays.LIBELLE[0][0];
        }
        return Pays.LIBELLE[cardIssuingMemberState][0];
    }

    public Date getCardDownload() {
        int offset;
        if (!this.fileReaden) {
            this.readFile();
        }
        if ((offset = this.cardProperty.getOffsetFile(this.fileBuffer, 331264) + 5) == -1) {
            return null;
        }
        int dateDownload = Fonctions.bytesToInt(this.fileBuffer, offset, 4);
        return new Date((long)dateDownload * 1000L);
    }

    public int updateDBValues(int cardProcessCode) {
        String dernierChangement;
        String dateDownload;
        block10: {
            block9: {
                try {
                    dateDownload = this.getDateDownload();
                    dernierChangement = this.getDernierChangement();
                    if (cardProcessCode != 1 || ConversionTime.compare(dateDownload, this.conducteur.getDernierTelechargement(), "yyyy-MM-dd HH:mm:ss") > 0) break block9;
                    TimsLogger.debug("#DCP.updateValue# ancien fichier");
                    if (!CardDownload.exists(this.toRead.getName())) {
                        TimsLogger.debug("#DCP.updateValue# jamais t\u00e9l\u00e9charg\u00e9, on ajoute");
                        if (!this.transferFile()) {
                            return 5;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return 5;
                }
            }
            if (cardProcessCode == 1) {
                TimsLogger.debug("#DCP.updateValue# pas d'activit\u00e9 suppl\u00e9mentaire mais t\u00e9l\u00e9chargement apr\u00e8s le dernier t\u00e9l\u00e9chargement connu");
            } else {
                TimsLogger.debug("#DCP.updateValue# nouveau fichier, nouvelle activit\u00e9");
                this.conducteur.setIoCounter(this.maxIo);
            }
            if (this.transferFile()) break block10;
            return 5;
        }
        this.conducteur.getDateSortie().equals("");
        Service.getNightHour(this.conducteur.getCleConducteur(), dernierChangement, dernierChangement);
        this.conducteur.setDernierChangement(dernierChangement);
        this.conducteur.setDernierTelechargement(dateDownload);
        if (!this.conducteur.update()) {
            return 5;
        }
        return 2;
    }

    public boolean transferFile() {
        String fileName = FileManager.moveFile(this.conducteur, this.toRead);
        if (fileName == null) {
            return false;
        }
        CardDownload tmp = new CardDownload(this.conducteur, ConnexionSettings.getInstance().getUserCle(), this.getDateDownload(), fileName);
        return tmp.insert();
    }

    /*
     * Unable to fully structure code
     */
    public String getDernierChangement() {
        x = this.activityChangeInfo.size();
        if (x != 0) ** GOTO lbl5
        return "1970-01-01 00:00:00";
lbl-1000:
        // 1 sources

        {
            --x;
lbl5:
            // 2 sources

            ** while (x > 0 && !Fonctions.isActiv((int)this.activityChangeInfo.get((int)(x - 1)).getTypeActivite()))
        }
lbl6:
        // 1 sources

        if (x == this.activityChangeInfo.size()) {
            return String.valueOf(ConversionTime.dateToString(this.activityChangeInfo.get(x - 1).getDate(), "yyyy-MM-dd")) + " " + ConversionTime.heureIntToString(this.activityChangeInfo.get(x - 1).getHeure(), ":") + ":00";
        }
        if (x != 0) {
            return String.valueOf(ConversionTime.dateToString(this.activityChangeInfo.get(x).getDate(), "yyyy-MM-dd")) + " " + ConversionTime.heureIntToString(this.activityChangeInfo.get(x).getHeure(), ":") + ":00";
        }
        return "1970-01-01 00:00:00";
    }

    public String getDateDownload() {
        if (!this.fileReaden) {
            this.readFile();
        }
        String nomFichier = this.toRead.getName();
        String dateBDD = "";
        String tmp = nomFichier.substring(nomFichier.length() - 14, nomFichier.length() - 4);
        String jour = tmp.substring(4, 6);
        String mois = tmp.substring(2, 4);
        String year = "20";
        if (Integer.parseInt(tmp.substring(0, 2)) >= 70) {
            year = "19";
        }
        String annee = String.valueOf(year) + tmp.substring(0, 2);
        String heure = String.valueOf(tmp.substring(6, 8)) + ":" + tmp.substring(8, 10);
        dateBDD = String.valueOf(annee) + "-" + mois + "-" + jour + " " + heure + ":00";
        TimsLogger.debug("#CardDataProcessing.recupererDate# " + tmp + " donne " + dateBDD);
        return dateBDD;
    }

    public void getApercu() {
        if (!this.fileReaden) {
            this.readFile();
        }
        String message = null;
        String title = null;
        if (this.readEvents() != 2) {
            message = LanguageTranslator.getString("card.eventsError");
            title = LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readEvents());
        } else if (this.readFaults() != 2) {
            message = LanguageTranslator.getString("card.faultsError");
            title = LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + this.readFaults());
        } else {
            int result = this.readActivity();
            if (result == 2) {
                new ApercuCarte((JFrame)MainFrameTransport.getInstance(), this.activityChangeInfo);
            } else if (result == 6) {
                message = LanguageTranslator.getString("card.noData");
                title = LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(2)) + 6);
            }
        }
        if (message != null) {
            MessageSystemManager.warning((Component)MainFrameTransport.getInstance(), message, title);
        }
    }

    public Vector<Jour> getDays(int cleConducteur) {
        if (!this.fileReaden) {
            this.readFile();
        }
        Vector<Jour> toReturn = new Vector<Jour>();
        if (this.readEvents() != 2) {
            return null;
        }
        if (this.readFaults() != 2) {
            return null;
        }
        int result = this.readActivity();
        if (result == 2) {
            int x = 0;
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            while (x < this.activityChangeInfo.size()) {
                int duree;
                ChangementActivite tmp = this.activityChangeInfo.get(x);
                int heureFin = 1440;
                if (x != this.activityChangeInfo.size() - 1 && ConversionTime.dateToString(this.activityChangeInfo.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    heureFin = this.activityChangeInfo.get(x + 1).getHeure();
                }
                if ((duree = heureFin - tmp.getHeure()) != 0) {
                    ActiviteConducteur toAdd = new ActiviteConducteur(cleConducteur, 0, tmp.getTypeActivite(), "", tmp.getHeure(), heureFin, duree, ConversionTime.dateToString(tmp.getDate(), "yyyy-MM-dd"), tmp.getSource(), tmp.getNomSource(), tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), 0);
                    tmpJour.add(toAdd);
                }
                if (x == this.activityChangeInfo.size() - 1 || !ConversionTime.dateToString(this.activityChangeInfo.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    String dateJour = ConversionTime.dateToString(this.activityChangeInfo.get(x).getDate(), "yyyy-MM-dd");
                    boolean manualInput = false;
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    int km = this.kmJour.get(this.activityChangeInfo.get(x).getDate()) == null ? 0 : this.kmJour.get(this.activityChangeInfo.get(x).getDate());
                    int y = 0;
                    while (y < tmpJour.size()) {
                        ActiviteConducteur act = tmpJour.get(y);
                        if (this.firstDay == null && act.getCleType() != 4 && act.getCleType() != 7) {
                            this.firstDay = act.getDateJour();
                        }
                        if (act.isManualInput()) {
                            manualInput = true;
                        }
                        switch (act.getCleType()) {
                            case 1: {
                                conduite += act.getDuree();
                                nuit += Fonctions.getTempsNuit(act);
                                break;
                            }
                            case 2: {
                                travail += act.getDuree();
                                nuit += Fonctions.getTempsNuit(act);
                                break;
                            }
                            case 3: {
                                dispo += act.getDuree();
                                nuit += Fonctions.getTempsNuit(act);
                                break;
                            }
                            case 4: {
                                repos += act.getDuree();
                                break;
                            }
                            case 5: {
                                de += act.getDuree();
                                nuit += Fonctions.getTempsNuit(act);
                                break;
                            }
                            case 7: {
                                inconnu += act.getDuree();
                                break;
                            }
                            default: {
                                TimsLogger.warn("#DCP.stockActivite()# activit\u00e9s inconnue " + act.getCleType());
                            }
                        }
                        ++y;
                    }
                    Jour detailJour = new Jour(0, cleConducteur, dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, km, 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), this.toRead.getName(), manualInput);
                    toReturn.add(detailJour);
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour = new Vector();
                }
                ++x;
            }
        } else if (result == 6) {
            return null;
        }
        return toReturn;
    }

    public ProgressBar getProgression() {
        if (this.progression == null) {
            this.progression = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("card.reading.title", String.valueOf(this.conducteur.getNom()) + " " + this.conducteur.getPrenom()));
            this.progression.setVisible(true);
        }
        return this.progression;
    }

    public Conducteur getDriver() {
        return this.conducteur;
    }

    public Date getFirstActivity() {
        TimsLogger.debug("#getFirstActivityToInsert# activities count = " + this.activityChangeInfo.size() + (this.activityChangeInfo.size() != 0 ? " and first is on " + this.activityChangeInfo.get(0).getDate() : ""));
        return this.activityChangeInfo.size() != 0 ? this.activityChangeInfo.get(0).getDate() : null;
    }

    public Date getFirstActivityToInsert() {
        TimsLogger.debug("#getFirstActivityToInsert# activities count = " + this.activityChangeInfo.size() + (this.activityChangeInfo.size() != 0 ? " and first is on " + this.activityChangeInfo.get(0).getDate() : ""));
        return this.activityChangeInfo.size() != 0 && this.getBegin() != this.activityChangeInfo.size() ? this.activityChangeInfo.get(this.getBegin()).getDate() : null;
    }

    class ConfirmMessage
    implements Runnable {
        String message = null;
        String title = null;
        int response = 0;

        public ConfirmMessage(String message, String title) {
            this.message = message;
            this.title = title;
        }

        @Override
        public void run() {
            this.response = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), this.message, this.title, 2);
        }

        public int getResponse() {
            return this.response;
        }
    }
}

