/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import com.sun.comm.Win32Driver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import org.apache.commons.lang.UnhandledException;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.CardCommunicator;
import transpo.system.util.Fonctions;

public class RS232Reader
extends CardCommunicator {
    public SerialPort port;
    private InputStream fluxLecture;
    private OutputStream outStream;
    private final String portName = "COM15";
    protected static boolean init = false;
    private int byteToRead = 0;

    @Override
    public boolean connect() {
        if (init) {
            return true;
        }
        Win32Driver w32Driver = new Win32Driver();
        w32Driver.initialize();
        CommPortIdentifier portId = null;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)"COM15");
        }
        catch (NoSuchPortException ex) {
            TimsLogger.warn("No Port Name COM15");
            return false;
        }
        try {
            this.port = (SerialPort)portId.open("GM TIMS", 5000);
            this.port.setFlowControlMode(0);
            this.port.setSerialPortParams(9600, 8, 1, 2);
            this.outStream = this.port.getOutputStream();
            this.fluxLecture = this.port.getInputStream();
        }
        catch (PortInUseException ex) {
            TimsLogger.warn("Port Name COM15 in use");
            return false;
        }
        catch (Exception ex) {
            TimsLogger.warn("Error unknow");
            ex.printStackTrace();
            return false;
        }
        init = true;
        TimsLogger.info("Port Name COM15 open");
        return true;
    }

    @Override
    public boolean reset() {
        TimsLogger.debug("#RS232READER.start()# Send ATR");
        boolean toReturn = false;
        try {
            int readed;
            int totalPurged = 0;
            TimsLogger.debug("#RS232READER.start()# Purge 1 : ");
            while (this.fluxLecture.available() != 0) {
                readed = this.fluxLecture.read();
                ++totalPurged;
                TimsLogger.debug(" " + Integer.toHexString(readed));
            }
            TimsLogger.debug("\r\n#RS232READER.start()# On provoque un reset (" + totalPurged + " purg\u00e9s)");
            this.port.setRTS(false);
            Thread.sleep(100L);
            this.port.setRTS(true);
            Thread.sleep(500L);
            while (this.fluxLecture.available() == 0) {
            }
            totalPurged = 0;
            TimsLogger.debug("#RS232READER.start()# Purge 2 : ");
            while (this.fluxLecture.available() != 0) {
                readed = this.fluxLecture.read();
                ++totalPurged;
                TimsLogger.debug(" " + Integer.toHexString(readed));
            }
            TimsLogger.debug("(" + totalPurged + " purg\u00e9s)");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return toReturn;
        }
    }

    @Override
    public String transmit(String command) {
        TimsLogger.debug("#RS232READER.transmit# " + command + " " + Fonctions.parseString(command));
        byte[] toSend = Fonctions.parseStringToByteArray(command);
        command = Fonctions.parseString(command);
        try {
            this.outStream.write(toSend);
            this.outStream.flush();
            this.buffer = this.readInput(toSend);
            return Fonctions.returnIntCode(this.buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "0000";
        }
    }

    private byte[] readInput(byte[] filter) {
        Vector<Byte> tmp = new Vector<Byte>();
        String read = "";
        try {
            int readed;
            int match = 0;
            while (read.length() != filter.length) {
                int readed2 = this.fluxLecture.read();
                if (readed2 == filter[match]) {
                    ++match;
                }
                read = String.valueOf(read) + (char)readed2;
            }
            int cfr_ignored_0 = filter.length;
            read = "";
            while (this.fluxLecture.available() == 0) {
            }
            int understood = this.fluxLecture.read();
            while (understood == 96) {
                understood = this.fluxLecture.read();
            }
            if ((byte)understood == filter[1] || (byte)understood == filter[1] + 1) {
                TimsLogger.debug("#RS232READER.transmit# Commande OK");
                if (this.byteToRead != 0) {
                    TimsLogger.verbose(" ... on va lire " + this.byteToRead + " octets");
                    while (this.byteToRead != tmp.size()) {
                        readed = this.fluxLecture.read();
                        tmp.add((byte)readed);
                        TimsLogger.debug("-(" + (byte)readed + ")- ");
                    }
                } else {
                    TimsLogger.verbose(" ... no data to read");
                }
                this.byteToRead = 0;
            } else {
                readed = this.fluxLecture.read();
                tmp.add((byte)understood);
                tmp.add((byte)readed);
                TimsLogger.verbose("#RS232READER.transmit# Pas de retour INS, retour code erreur " + Integer.toHexString(understood) + " " + Integer.toHexString(readed));
            }
            byte[] toReturn = new byte[tmp.size()];
            int x = 0;
            for (Byte b : tmp) {
                toReturn[x] = b;
                ++x;
            }
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String selectFile(String file) {
        String pe = "04";
        String le = "0" + file.length() / 2;
        if (le.equals("02")) {
            pe = "02";
        }
        this.byteToRead = 0;
        String stepOne = this.transmit("00A4" + pe + "0C" + le);
        if (stepOne.equals("0000")) {
            this.byteToRead = 2;
            return this.transmit(file);
        }
        return "0000";
    }

    @Override
    public String updateBinary(String data) {
        String le = String.valueOf(data.length() / 2);
        while (le.length() < 2) {
            le = "0" + le;
        }
        this.byteToRead = 0;
        String stepOne = this.transmit("00D60000" + le);
        if (stepOne.equals("0000")) {
            this.byteToRead = 2;
            return this.transmit(data);
        }
        return "0000";
    }

    @Override
    public String readBinary(String p1, String p2, String le) {
        this.byteToRead = Integer.parseInt(le, 16) + 2;
        return super.readBinary(p1, p2, le);
    }

    @Override
    public String computeDigitalSignature(int size) {
        this.byteToRead = size + 2;
        return super.computeDigitalSignature(size);
    }

    @Override
    public String performHashOfFile() {
        this.byteToRead = 2;
        return this.transmit("802A900000");
    }

    @Override
    public void waitForWithdraw() {
        throw new UnhandledException("Fonction non support\u00e9e", null);
    }
}

