/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.CardCommunicator;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class SmartCardCommunicator
extends CardCommunicator {
    protected Card card;

    public SmartCardCommunicator(Card card) {
        this.card = card;
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public boolean reset() {
        try {
            ATR returned = this.card.getATR();
            TimsLogger.debug(returned.toString());
        }
        catch (Exception ex) {
            TimsLogger.warn("#CCIDReader.start# wait for insertion error \n");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String transmit(String command) {
        TimsLogger.debug("#SmartCardCommunicator.transmit# TRANSMIT " + command);
        CommandAPDU comm = new CommandAPDU(Fonctions.parseStringToByteArray(command));
        try {
            ResponseAPDU response = this.card.getBasicChannel().transmit(comm);
            this.buffer = response.getBytes();
            TimsLogger.debug("#SmartCardCommunicator.transmit# RECEIVE " + Fonctions.parseHexAscii(this.buffer));
            return Fonctions.returnIntCode(this.buffer);
        }
        catch (CardException ex) {
            TimsLogger.error("#SmartCardCommunicator.transmit# CARDEXCEPTION " + command + " encountered an error " + ex.getMessage());
            ex.printStackTrace();
            return "0000";
        }
    }

    @Override
    public void waitForWithdraw() {
    }

    public class SelectSource
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private String srcName;
        private boolean canceled;

        SelectSource(JFrame f, String[] defSrcName) {
            super(f, LanguageTranslator.getString("card.tranfer.reader"), true);
            Vector<String> srcNames = new Vector<String>();
            int i = 0;
            while (i < defSrcName.length) {
                srcNames.add(defSrcName[i]);
                ++i;
            }
            JPanel pnl = new JPanel(new BorderLayout());
            JPanel pnlBtn = new JPanel();
            JButton btnValid = new JButton(LanguageTranslator.getString("button.valid"));
            JButton btnCancel = new JButton(LanguageTranslator.getString("button.quit"));
            final JCheckBox cbPref = new JCheckBox(LanguageTranslator.getString("preference.save"));
            cbPref.setToolTipText(LanguageTranslator.getString("preference.explaination"));
            final JList list = new JList(srcNames);
            list.setSelectionMode(0);
            if (srcNames.size() != 0) {
                list.setSelectedValue(defSrcName, true);
            }
            pnl.add((Component)new JScrollPane(list), "Center");
            pnl.add((Component)cbPref, "North");
            pnlBtn.add(btnValid);
            pnlBtn.add(btnCancel);
            this.getRootPane().setDefaultButton(btnValid);
            pnl.add((Component)pnlBtn, "South");
            btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectSource.this.canceled = false;
                    SelectSource.this.srcName = (String)list.getSelectedValue();
                    if (cbPref.isSelected()) {
                        Preferences prefs = Preferences.userRoot().node("TIMS");
                        prefs.put("preference.reader", SelectSource.this.srcName);
                    }
                    SelectSource.this.dispose();
                }
            });
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectSource.this.canceled = true;
                    SelectSource.this.dispose();
                }
            });
            this.getContentPane().add((Component)pnl, "South");
            this.pack();
            this.setLocationRelativeTo(f);
        }

        String getSrcName() {
            return this.srcName;
        }

        boolean isCanceled() {
            return this.canceled;
        }
    }
}

