/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import transpo.system.TimsLogger;
import transpo.system.Transport;

public class MailSender {
    private static String SMTP_SERVER = "smtp.office365.com";
    private static String USERNAME = "pgh@pgh.fr";
    private static String PASSWORD = "9ZlDGjEAX8DC";
    private static String PORT = "587";
    private static String FROM = "pgh@pgh.fr";
    private static String TRANSPORT_TYPE = "smtp";
    private static boolean AUTH = true;
    private static boolean TLS = true;
    private final javax.mail.Transport transport;
    private final Session session;

    public MailSender() throws MessagingException, FileNotFoundException {
        if (System.getProperty("SMTP") != null) {
            try {
                TimsLogger.debug("#MailSender# smpt file => " + System.getProperty("SMTP"));
                FileInputStream in = new FileInputStream(System.getProperty("SMTP"));
                Properties given = new Properties();
                given.load(in);
                SMTP_SERVER = given.getProperty("mail.smtp.host", SMTP_SERVER);
                AUTH = given.getProperty("mail.smtp.auth", AUTH ? "1" : "0").equals("1");
                TLS = given.getProperty("mail.smtp.starttls.enable", TLS ? "1" : "0").equals("1");
                TRANSPORT_TYPE = given.getProperty("mail.ssl", "0").equals("1") ? "smtps" : "smtp";
                PORT = given.getProperty("mail.smtp.port", PORT);
                USERNAME = given.getProperty("username", USERNAME);
                PASSWORD = given.getProperty("password", PASSWORD);
                FROM = given.getProperty("from", FROM);
            }
            catch (Exception e) {
                TimsLogger.warn("#MailSender# erreur => " + e.getMessage());
                e.printStackTrace();
            }
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", SMTP_SERVER);
        props.put("mail.smtp.port", PORT);
        props.put("mail.smtp.auth", new Boolean(AUTH).toString());
        props.put("mail.smtp.starttls.enable", new Boolean(TLS).toString());
        this.session = Session.getInstance((Properties)props);
        this.session.setDebug(true);
        this.session.setDebugOut(new PrintStream(new FileOutputStream(new File(String.valueOf(Transport.savePath) + "\\MailSender - log.txt"))));
        TimsLogger.info("#MailSender# Save log to " + Transport.savePath + "\\MailSender - log.txt");
        this.session.getDebugOut().print("new MailSender session opened on " + new Date() + "\n");
        this.transport = this.session.getTransport(TRANSPORT_TYPE);
        this.transport.connect(SMTP_SERVER, USERNAME, PASSWORD);
    }

    public MailSender(String smtp, String user, String password, boolean auth) throws MessagingException, FileNotFoundException {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", smtp);
        props.put("mail.smtp.auth", new Boolean(auth).toString());
        this.session = Session.getInstance((Properties)props, null);
        this.session.setDebug(true);
        this.session.setDebugOut(new PrintStream(new FileOutputStream(new File(String.valueOf(Transport.savePath) + "\\MailSender - log.txt"))));
        this.session.getDebugOut().print("new MailSender session opened on " + new Date() + "\n");
        this.transport = this.session.getTransport("smtp");
        this.transport.connect(smtp, user, password);
    }

    public void sendMessage(ArrayList<String> to, String subject, String text, ArrayList<File> joins, boolean returnRecept) throws MessagingException {
        this.sendMessage(to, null, null, subject, text, joins, returnRecept);
    }

    public void sendMessage(ArrayList<String> to, ArrayList<String> cc, ArrayList<String> bcc, String subject, String text, ArrayList<File> joins, boolean returnRecept) throws MessagingException {
        String fr = "";
        for (String r : to) {
            fr = String.valueOf(fr) + r + ",";
        }
        TimsLogger.info("#MailSender.sendMessage# send '" + subject + "' to " + to.size() + " recipients (" + fr + ") with " + (joins == null ? "0" : Integer.valueOf(joins.size())) + " files");
        MimeMessage toSend = new MimeMessage(this.session);
        toSend.setFrom((Address)InternetAddress.parse((String)FROM, (boolean)false)[0]);
        toSend.setSentDate(new Date());
        toSend.setHeader("Content-Transfert-Encoding", "8bit");
        for (String recipient : to) {
            toSend.addRecipient(Message.RecipientType.TO, (Address)InternetAddress.parse((String)recipient, (boolean)false)[0]);
        }
        if (cc != null) {
            for (String recipient : cc) {
                TimsLogger.debug("#MailSender.sendMessage# add CC " + recipient);
                toSend.addRecipient(Message.RecipientType.CC, (Address)InternetAddress.parse((String)recipient, (boolean)false)[0]);
            }
        }
        if (bcc != null) {
            for (String recipient : bcc) {
                TimsLogger.debug("#MailSender.sendMessage# add BCC " + recipient);
                toSend.addRecipient(Message.RecipientType.BCC, (Address)InternetAddress.parse((String)recipient, (boolean)false)[0]);
            }
        }
        toSend.setSubject(subject);
        if (joins != null && joins.size() != 0) {
            this.attach(joins, (Message)toSend, text);
        } else {
            toSend.setContent((Object)text.replaceAll("\r\n", "<br/>"), "text/html");
        }
        if (returnRecept) {
            toSend.setHeader("Disposition-Notification-To", FROM);
            toSend.setHeader("Return-Receipt-To", FROM);
        }
        toSend.saveChanges();
        this.session.setDebug(false);
        this.transport.sendMessage((Message)toSend, toSend.getAllRecipients());
        this.session.setDebug(true);
    }

    private void attach(ArrayList<File> joins, Message toSend, String content) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)content.replaceAll("\r\n", "<br/>"), "text/html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (File toJoin : joins) {
            TimsLogger.debug("#MailSender.attach# join " + toJoin.getAbsolutePath());
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(toJoin);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(toJoin.getName());
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        toSend.setContent((Multipart)multipart);
    }
}

