/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Pays;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;

public class UEVProperty {
    public static final int EVER_READ = 1;
    public static final int READ_SUCCESS = 2;
    public static final int INFORMATION_ERROR = 3;
    public static final int SAVING_ERROR = 4;
    public static final int UNKNOWN_ERROR = 5;
    public static final int NO_DATA = 6;
    public static final int BAD_FILE = 7;
    public static final int WRITING_ERROR = 8;
    public static final int READ_CANCELLED = 9;
    public static final int DATA_ERROR = 10;
    public static final String ETAT_NON_INSERE = "NON INSEREE";
    public static final String ETAT_INSERE = "INSEREE";
    public static final String ETAT_SM = "S. MAN";
    public static final String ETAT_SEUL = "SEUL";
    public static final String ETAT_INCONNU = "INCONNU";
    public static final String ETAT_EQUIPAGE = "EQUIPAGE";
    public static final String LECTEUR_CONDUCTEUR = "CONDUCTEUR";
    public static final String LECTEUR_CONVOYEUR = "CONVOYEUR";
    public static int ID_IDENTIFICATION = 30209;
    public static int ID_ACTIVITE = 30210;
    public static int ID_EVT_ANOMALIE = 30211;
    public static int ID_SPEED = 30212;
    public static int ID_TECHNIQUE = 30213;
    public static int MemberStateCertificateSize = 194;
    public static int VUCertificateSize = 194;
    public static int vehicleIdentificationNumberSize = 17;
    public static int vehicleMemberStateSize = 1;
    public static final int RT_ActivityChangeInfo = 1;
    public static final int RT_CardSlotStatus = 2;
    public static final int RT_CurrentDateTime = 3;
    public static final int RT_MemberStateCertificate = 4;
    public static final int RT_OdometerValueMidnight = 5;
    public static final int RT_DateOfDayDonwloaded = 6;
    public static final int RT_SensorPaired = 7;
    public static final int RT_Signature = 8;
    public static final int RT_SpecificConditionRecord = 9;
    public static final int RT_VehicleIdentificationNumber = 10;
    public static final int RT_VehicleRegistrationNumber = 11;
    public static final int RT_VuCalibrationRecord = 12;
    public static final int RT_VuCardIWRecord = 13;
    public static final int RT_VuCardRecord = 14;
    public static final int RT_VuCertificate = 15;
    public static final int RT_VuCompanyLockRecord = 16;
    public static final int RT_VuControlActivityRecord = 17;
    public static final int RT_VuDetailedSpeedBlock = 18;
    public static final int RT_VuDownloadablePeriod = 19;
    public static final int RT_VuDownloadActivityData = 20;
    public static final int RT_VuEventRecord = 21;
    public static final int RT_VuGNSSCDRecord = 22;
    public static final int RT_VuITSConsentRecord = 23;
    public static final int RT_VuFaultRecord = 24;
    public static final int RT_VuIdetification = 25;
    public static final int RT_VuOverSpeedingControlData = 26;
    public static final int RT_VuOverSpeedingEventRecord = 27;
    public static final int RT_VuPlaceDailyWorkPeriodRecord = 28;
    public static final int RT_VuTimeAdjustmentGNSSRecord = 29;
    public static final int RT_VuTimeAdjustmentRecord = 30;
    public static final int RT_VuPowerSupplyInterruptionRecord = 31;
    public static final int RT_SensorPairedRecord = 32;
    public static final int RT_SensorExternalGNSSCoupledRecord = 33;

    public static int getOffset(byte[] fileBuffer, int idOffset) {
        int offset = 0;
        try {
            while (offset < fileBuffer.length && Fonctions.bytesToInt(fileBuffer, offset, 2) != idOffset) {
                int begin;
                if (Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_IDENTIFICATION) {
                    begin = offset;
                    offset = offset + 2 + 194 + 194 + 17 + 1 + 14 + 4 + 4 + 4 + 1 + 4 + 18 + 36;
                    offset += Fonctions.bytesToInt(fileBuffer, offset, 1) * 98 + 1;
                    offset += Fonctions.bytesToInt(fileBuffer, offset, 1) * 31 + 1 + 128;
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.verbose("#UEVP.getOffset# identification at " + begin + " / 0x" + Integer.toHexString(begin) + " (end at " + offset + ")");
                    continue;
                }
                if (Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_ACTIVITE) {
                    begin = offset;
                    while (offset < fileBuffer.length && Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_ACTIVITE) {
                        if (Transport.apiMode == 0) {
                            TimsLogger.verbose("#UEVP.getOffset# day activity at " + offset + " / 0x" + Integer.toHexString(offset) + " (end at " + offset + ")");
                        }
                        offset = offset + 2 + 4 + 3;
                        offset += Fonctions.bytesToInt(fileBuffer, offset, 2) * 129 + 2;
                        offset += Fonctions.bytesToInt(fileBuffer, offset, 2) * 2 + 2;
                        offset += Fonctions.bytesToInt(fileBuffer, offset, 1) * 28 + 1;
                        offset += Fonctions.bytesToInt(fileBuffer, offset, 2) * 5 + 2 + 128;
                    }
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.verbose("#UEVP.getOffset# activity at " + begin + " / 0x" + Integer.toHexString(begin) + " (end at " + offset + ")");
                    continue;
                }
                if (Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_EVT_ANOMALIE) {
                    begin = offset;
                    int faultNb = Fonctions.bytesToInt(fileBuffer, offset += 2, 1);
                    int eventNb = Fonctions.bytesToInt(fileBuffer, offset += faultNb * 82 + 1, 1);
                    int speedNb = Fonctions.bytesToInt(fileBuffer, offset += eventNb * 83 + 1 + 4 + 4 + 1, 1);
                    int adjustementNb = Fonctions.bytesToInt(fileBuffer, offset += speedNb * 31 + 1, 1);
                    offset += adjustementNb * 98 + 1 + 128;
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.verbose("#UEVP.getOffset# anomalie at " + begin + " / 0x" + Integer.toHexString(begin) + " (end at " + offset + ", " + faultNb + " fault (offset end " + Integer.toHexString(begin + faultNb * 82 + 3) + ") and " + eventNb + " event (offset end " + Integer.toHexString(begin + faultNb * 82 + eventNb * 83 + 13) + ") and " + speedNb + " speed (offset end " + Integer.toHexString(begin + faultNb * 82 + eventNb * 83 + speedNb * 31 + 14) + ") and " + adjustementNb + " adjustement)");
                    continue;
                }
                if (Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_SPEED) {
                    begin = offset;
                    offset += 2;
                    offset += Fonctions.bytesToInt(fileBuffer, offset, 2) * 64 + 2 + 128;
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.verbose("#UEVP.getOffset# speed at " + begin + " / 0x" + Integer.toHexString(begin) + " (end at " + offset + ")");
                    continue;
                }
                if (Fonctions.bytesToInt(fileBuffer, offset, 2) == ID_TECHNIQUE) {
                    begin = offset;
                    offset = offset + 2 + 36 + 36 + 16 + 8 + 4 + 4 + 4 + 8 + 8 + 8 + 4;
                    offset += Fonctions.bytesToInt(fileBuffer, offset, 1) * 167 + 1 + 128;
                    if (Transport.apiMode != 0) continue;
                    TimsLogger.verbose("#UEVP.getOffset# technic at " + begin + " / 0x" + Integer.toHexString(begin) + " (end at " + offset + ")");
                    continue;
                }
                if (Transport.apiMode == 0) {
                    TimsLogger.verbose("#UEVP.getOffset# unknown " + Fonctions.bytesToInt(fileBuffer, offset, 2) + " at " + offset + " / 0x" + Integer.toHexString(offset));
                }
                offset = -2;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (offset > fileBuffer.length + 2) {
                return -1;
            }
            return -3;
        }
        if (offset >= fileBuffer.length) {
            return -1;
        }
        return offset;
    }

    public static void printOffsetRecords(byte[] toParse) {
        int x = 0;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 34) {
                if (recordType == 118) {
                    TimsLogger.debug("#UEVProperty.printOffsetRecords# Printing records of offset " + Integer.toHexString(Fonctions.bytesToInt(toParse, x, 2)));
                    recordType = toParse[x += 2];
                } else {
                    TimsLogger.debug("#UEVProperty.printOffsetRecords# Unrecognize recort type " + recordType);
                    break;
                }
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            x += 2;
            if (noOfRecords != 0) {
                int y = 0;
                while (y < noOfRecords) {
                    UEVProperty.printRecord(recordType, Arrays.copyOfRange(toParse, x, x + recordSize));
                    ++y;
                }
            }
            TimsLogger.debug("#UEVProperty.printOffsetRecords# recordType: " + Integer.toHexString(recordType) + "(from " + Integer.toHexString(begin) + " to " + Integer.toHexString(x += recordSize * noOfRecords - 1) + "), recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), noOfRecords: " + noOfRecords);
            ++x;
        }
    }

    private static void printRecord(int recordType, byte[] toPrint) {
        switch (recordType) {
            case 1: {
                UEVProperty.printActivityChangeInfo(toPrint);
                break;
            }
            case 2: {
                UEVProperty.printCardSlotStatus(toPrint);
                break;
            }
            case 3: {
                UEVProperty.printCurrentDateTime(toPrint);
                break;
            }
            case 4: {
                UEVProperty.printMemberStateCertificate(toPrint);
                break;
            }
            case 5: {
                UEVProperty.printOdometerValueMidnight(toPrint);
                break;
            }
            case 6: {
                UEVProperty.printDateOfDayDonwloaded(toPrint);
                break;
            }
            case 7: {
                UEVProperty.printSensorPaired(toPrint);
                break;
            }
            case 8: {
                UEVProperty.printSignature(toPrint);
                break;
            }
            case 9: {
                UEVProperty.printSpecificConditionRecord(toPrint);
                break;
            }
            case 10: {
                UEVProperty.printVehicleIdentificationNumber(toPrint);
                break;
            }
            case 11: {
                UEVProperty.printVehicleRegistrationNumber(toPrint);
                break;
            }
            case 12: {
                UEVProperty.printVuCalibrationRecord(toPrint);
                break;
            }
            case 13: {
                UEVProperty.printVuCardIWRecord(toPrint);
                break;
            }
            case 14: {
                UEVProperty.printVuCardRecord(toPrint);
                break;
            }
            case 15: {
                UEVProperty.printVuCertificate(toPrint);
                break;
            }
            case 16: {
                UEVProperty.printVuCompanyLockRecord(toPrint);
                break;
            }
            case 17: {
                UEVProperty.printVuControlActivityRecord(toPrint);
                break;
            }
            case 18: {
                UEVProperty.printVuDetailedSpeedBlock(toPrint);
                break;
            }
            case 19: {
                UEVProperty.printVuDownloadablePeriod(toPrint);
                break;
            }
            case 20: {
                UEVProperty.printVuDownloadActivityData(toPrint);
                break;
            }
            case 21: {
                UEVProperty.printVuEventRecord(toPrint);
                break;
            }
            case 22: {
                UEVProperty.printVuGNSSCDRecord(toPrint);
                break;
            }
            case 23: {
                UEVProperty.printVuITSConsentRecord(toPrint);
                break;
            }
            case 24: {
                UEVProperty.printVuFaultRecord(toPrint);
                break;
            }
            case 25: {
                UEVProperty.printVuIdentification(toPrint);
                break;
            }
            case 26: {
                UEVProperty.printVuOverSpeedingControlData(toPrint);
                break;
            }
            case 27: {
                UEVProperty.printVuOverSpeedingEventRecord(toPrint);
                break;
            }
            case 28: {
                UEVProperty.printVuPlaceDailyWorkPeriodRecord(toPrint);
                break;
            }
            case 29: {
                UEVProperty.printVuTimeAdjustmentGNSSRecord(toPrint);
                break;
            }
            case 30: {
                UEVProperty.printVuTimeAdjustmentRecord(toPrint);
                break;
            }
            case 31: {
                UEVProperty.printVuPowerSupplyInterruptionRecord(toPrint);
                break;
            }
            case 32: {
                UEVProperty.printSensorPairedRecord(toPrint);
                break;
            }
            case 33: {
                UEVProperty.printSensorExternalGNSSCoupledRecord(toPrint);
            }
        }
    }

    public static void printActivityChangeInfo(byte[] toPrint) {
    }

    public static void printCardSlotStatus(byte[] toPrint) {
    }

    public static void printCurrentDateTime(byte[] toPrint) {
        TimsLogger.debug("#currentDateTime# " + ConversionTime.getDate(Fonctions.bytesToInt(toPrint, 0, 4)));
    }

    public static void printMemberStateCertificate(byte[] toPrint) {
        TimsLogger.debug("#MemberStateCertificate# ");
    }

    public static void printOdometerValueMidnight(byte[] toPrint) {
        TimsLogger.debug("#odometerValueMidnight# " + Fonctions.bytesToInt(toPrint, 0, 3));
    }

    public static void printDateOfDayDonwloaded(byte[] toPrint) {
        TimsLogger.debug("#dateOfDayDonwloaded# " + ConversionTime.getDate(Fonctions.bytesToInt(toPrint, 0, 4)));
    }

    public static void printSensorPaired(byte[] toPrint) {
    }

    public static void printSignature(byte[] toPrint) {
        TimsLogger.debug("#printSignature#");
    }

    public static void printSpecificConditionRecord(byte[] toPrint) {
    }

    public static void printVehicleIdentificationNumber(byte[] toPrint) {
    }

    public static void printVehicleRegistrationNumber(byte[] toPrint) {
    }

    public static void printVuCalibrationRecord(byte[] toPrint) {
    }

    public static void printVuCardIWRecord(byte[] toPrint) {
    }

    public static void printVuCardRecord(byte[] toPrint) {
    }

    public static void printVuCertificate(byte[] toPrint) {
    }

    public static void printVuCompanyLockRecord(byte[] toPrint) {
    }

    public static void printVuControlActivityRecord(byte[] toPrint) {
    }

    public static void printVuDetailedSpeedBlock(byte[] toPrint) {
    }

    public static void printVuDownloadablePeriod(byte[] toPrint) {
    }

    public static void printVuDownloadActivityData(byte[] toPrint) {
    }

    public static void printVuEventRecord(byte[] toPrint) {
    }

    public static void printVuGNSSCDRecord(byte[] toPrint) {
    }

    public static void printVuITSConsentRecord(byte[] toPrint) {
    }

    public static void printVuFaultRecord(byte[] toPrint) {
    }

    public static void printVuIdentification(byte[] toPrint) {
    }

    public static void printVuOverSpeedingControlData(byte[] toPrint) {
    }

    public static void printVuOverSpeedingEventRecord(byte[] toPrint) {
    }

    public static void printVuPlaceDailyWorkPeriodRecord(byte[] toPrint) {
    }

    public static void printVuTimeAdjustmentGNSSRecord(byte[] toPrint) {
    }

    public static void printVuTimeAdjustmentRecord(byte[] toPrint) {
    }

    public static void printVuPowerSupplyInterruptionRecord(byte[] toPrint) {
    }

    public static void printSensorPairedRecord(byte[] toPrint) {
    }

    public static void printSensorExternalGNSSCoupledRecord(byte[] toPrint) {
    }

    public static String getLecteur(String value) {
        String lecteur = "";
        if (value.equals("0")) {
            lecteur = LECTEUR_CONDUCTEUR;
        }
        if (value.equals("1")) {
            lecteur = LECTEUR_CONVOYEUR;
        }
        return lecteur;
    }

    public static String getEtatConduite(String value) {
        if (value.equals("0")) {
            return ETAT_SEUL;
        }
        return ETAT_EQUIPAGE;
    }

    public static String getEtatCarte(String value) {
        if (value.equals("0")) {
            return ETAT_INSERE;
        }
        return ETAT_NON_INSERE;
    }

    public static int getActivite(String value) {
        if (value.equals("00")) {
            return 4;
        }
        if (value.equals("01")) {
            return 3;
        }
        if (value.equals("10")) {
            return 2;
        }
        if (value.equals("11")) {
            return 1;
        }
        return 0;
    }

    public static int getHeure(String binaryValue) {
        return Integer.parseInt(binaryValue, 2);
    }

    public static String getBinaryActivity(String octet) {
        while (octet.length() < 16) {
            octet = "0" + octet;
        }
        return octet;
    }

    public static ChangementActivite getDetailActivite(byte[] activite, Date day, String source, String sourceName) {
        int tmpInt = Fonctions.bytesToInt(activite, 0, 2);
        String binaryActivite = UEVProperty.getBinaryActivity(Integer.toBinaryString(tmpInt));
        String s = binaryActivite.substring(0, 1);
        String c = binaryActivite.substring(1, 2);
        String p = binaryActivite.substring(2, 3);
        String aa = binaryActivite.substring(3, 5);
        String tttttttttt = binaryActivite.substring(5, 16);
        String lecteur = UEVProperty.getLecteur(s);
        String conduite = UEVProperty.getEtatConduite(c);
        String carte = UEVProperty.getEtatCarte(p);
        int typeActivite = UEVProperty.getActivite(aa);
        int heure = UEVProperty.getHeure(tttttttttt);
        ChangementActivite retour = new ChangementActivite(typeActivite, day, heure, lecteur, conduite, carte, source, sourceName);
        return retour;
    }

    public static int getVuGeneration(String fileName) throws IOException {
        FileReader c = new FileReader(fileName);
        BufferedReader r = new BufferedReader(c);
        r.read();
        int second = r.read();
        int generation = 1;
        if (second >= 32) {
            generation = 2;
        }
        TimsLogger.debug("UEVProperty.getVuGeneration# " + Integer.toHexString(second) + " -> " + generation);
        r.close();
        c.close();
        return generation;
    }

    public static String extractFileNameG1(byte[] fileBuffer) throws Exception {
        String result = "-1";
        int offset = 0;
        offset = UEVProperty.getOffset(fileBuffer, ID_IDENTIFICATION);
        if (offset < -1) {
            throw new Exception("Buffer doesn't seems to be a VuFile representation");
        }
        int UEVIssuingMemberState = Fonctions.bytesToInt(fileBuffer, offset += MemberStateCertificateSize + VUCertificateSize + vehicleIdentificationNumberSize + 2, 1);
        String memberState = Pays.LIBELLE[0][0];
        if (Pays.LIBELLE.length > UEVIssuingMemberState) {
            memberState = Pays.LIBELLE[UEVIssuingMemberState][0];
        }
        result = memberState;
        offset += vehicleMemberStateSize + 1;
        byte[] vehicleRegistrationNumberchar = new byte[13];
        int j = 0;
        while (j < vehicleRegistrationNumberchar.length) {
            vehicleRegistrationNumberchar[j] = fileBuffer[offset + j];
            ++j;
        }
        result = String.valueOf(result) + new String(vehicleRegistrationNumberchar).trim();
        while (result.length() < 16) {
            result = String.valueOf(result) + "_";
        }
        result = String.valueOf(result) + ConversionTime.dateToString(ConversionTime.getDate(Fonctions.bytesToInt(fileBuffer, offset += 13, 4)), "yyMMddHHmm") + ".V1B";
        return result;
    }
}

