/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.CompanyCard;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.UevCalibration;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.VuFileParserG2;
import transpo.system.uev.exception.VuFileNotFoundException;
import transpo.system.uev.object.ActivityChangeInfo;
import transpo.system.uev.object.ActivityInfo;
import transpo.system.uev.object.VuActivityDailyRecord;
import transpo.system.uev.object.VuCalibration;
import transpo.system.uev.object.VuCardRecord;
import transpo.system.uev.object.VuCompanyLockData;
import transpo.system.uev.object.VuDetailedBlockSpeed;
import transpo.system.uev.object.VuEventRecord;
import transpo.system.uev.object.VuFaultRecord;
import transpo.system.uev.object.VuFile;
import transpo.system.uev.object.VuOverSpeedingEvent;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.ui.views.vehicule.DialogCreationVehicule;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.reader.FileReadResult;

public class VuProcessingG2 {
    public static final int CANCEL = 0;
    public static final int SUCCESS = 1;
    public static final int UNKNOWN_VEHICLE = 2;
    public static final int OLDER_FILE = 6;
    public static final int SAVE_ERROR = 7;
    public static final int SET_ERROR = 9;
    private BddTransport db = null;
    public Preferences prefs = Preferences.userRoot().node("TIMS");
    public File toRead = null;
    public VuFile readed = null;
    Vehicule currentVehicule = null;
    private Date beginActivity = null;
    private Date endActivity = null;
    private Date previousDownload = null;
    private Vector<String> errors = null;
    private HashMap<Date, Integer> kmDay = new HashMap();
    private Date jourEteToHiver = null;
    private Date jourHiverToEte = null;
    private ProgressBar progression = null;
    private int lastKnownKm = 0;
    private int dayUsedCount = 0;
    private int totalKm = 0;
    private boolean olderActivity = false;
    private boolean missingActivity = false;
    private Date dateTelechargement = null;
    private Vector<JourUEV> dayToSave = null;
    private Vector<VehicleUsed> ioToSave = null;
    private Vector<UevEventsFaults> efToSave = null;
    private Vector<UevSpeed> speedToSave = null;
    private Vector<UevCalibration> calibrationToSave = null;
    private Vector<UevOffence> offenceToSave = null;
    private Vector<String> unknownDriver = new Vector();
    private Vector<Conducteur> drivers = null;
    private Vector<VehicleUsed> vehiclesDB;

    public VuProcessingG2(File toRead) throws HeadlessException {
        this.toRead = toRead;
        this.errors = new Vector();
        this.db = BddTransport.getInstance();
    }

    public VuFile getVuFile() {
        return this.parseFile();
    }

    public VuFile parseFile() {
        if (this.readed != null) {
            return this.readed;
        }
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(this.toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            byte[] fileBuffer = new byte[taille];
            fs.read(fileBuffer, 0, taille);
            channel.close();
            fs.close();
            this.readed = VuFileParserG2.parseFile(fileBuffer, this.toRead.getName());
            if (this.readed.getIdentification() != null) {
                this.previousDownload = this.readed.getIdentification().getVuDownloadActivityData().getDownloadTime();
                this.readed.getIdentification().print();
            }
            if (this.readed.getEvent() != null) {
                this.readed.getEvent().print();
            }
            if (this.readed.getActivity() != null) {
                this.readed.printActivity();
            }
            if (this.readed.getTechnical() != null) {
                this.readed.getTechnical().print();
            }
            if (this.readed.getActivity() != null) {
                this.beginActivity = this.readed.getActivity().get(0).getDay();
                this.endActivity = this.readed.getActivity().get(this.readed.getActivity().size() - 1).getDay();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.readed;
    }

    public FileReadResult run() {
        TimsLogger.debug("#VuProcessingG2.run# Read uev file " + this.toRead.getName());
        Transport.ps.startOperation();
        int readingState = this.checkFileUEV();
        if (readingState == 7) {
            TimsLogger.warn(LanguageTranslator.getString("#UEVDP.run# vehicle.badFile"));
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("vehicle.badFile"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 7), this.toRead.getName());
        }
        if (readingState == 1) {
            TimsLogger.info("#UEVDP.run# File ever read");
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return new FileReadResult(this.toRead.getName(), 1, LanguageTranslator.getString("uev.everRead"), LanguageTranslator.getString("uev.everRead"), this.toRead.getName());
        }
        this.parseFile();
        int saved = 1;
        readingState = this.loadOrCreateVehicle();
        if (readingState == 1) {
            this.dateTelechargement = ConversionTime.stringToDate(this.currentVehicule.getDateTelechargement() == "" ? "1970-01-01" : this.currentVehicule.getDateTelechargement().substring(0, 10), "yyyy-MM-dd");
            try {
                BddTransport.getInstance().startTransaction();
                saved = this.dataProcess();
                if (saved == 1) {
                    BddTransport.getInstance().commit();
                }
                BddTransport.getInstance().rollback();
            }
            catch (Exception exp) {
                BddTransport.getInstance().rollback();
                TimsLogger.error("#UEVDP.run()# Exception in dataProcess()");
                exp.printStackTrace();
                return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 3), LanguageTranslator.getString("uev.informationError"), this.toRead.getName());
            }
        } else if (readingState == 0) {
            TimsLogger.info("#VuProcessingG2.run# abandon cr\u00e9ation du v\u00e9hicule");
            new FileReadResult(this.toRead.getName(), 4, null, LanguageTranslator.getString("uev.readCancel"), "");
        }
        if (saved == 1) {
            TimsLogger.info("#VuProcessingG2.run# File read success " + this.toRead.getName());
            long duration = Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return new FileReadResult(this.toRead.getName(), 1, LanguageTranslator.getString("uev.activityFromTo", this.beginActivity == null ? "?" : ConversionTime.dateToString(this.beginActivity, "dd/MM/yyyy"), this.endActivity == null ? "?" : ConversionTime.dateToString(this.endActivity, "dd/MM/yyyy")), "", String.valueOf(LanguageTranslator.getString("uev.activitySaved")) + " (" + duration + " ms)");
        }
        return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 8), "", this.toRead.getName());
    }

    private int loadOrCreateVehicle() {
        String vuVersion;
        String vehicleRegistrationImmat = this.getVuFile().getIdentification().getVehicleRegistrationIdentification().getVehicleRegistrationNumber();
        String vehicleIdentification = this.getVuFile().getIdentification().getVehicleIdentificationNumber();
        String vuBrand = this.getVuFile().getTechnical() == null ? "" : this.getVuFile().getTechnical().getVuIdentification().getName();
        String string = vuVersion = this.getVuFile().getTechnical() == null ? "" : this.getVuFile().getTechnical().getVuIdentification().getVuSoftwareIdentification().getVuSoftwareVersion();
        if (vehicleRegistrationImmat.equals("")) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.reading.error"), LanguageTranslator.getString("uev.reading.title", String.valueOf(vehicleRegistrationImmat) + " " + vehicleIdentification));
            return 2;
        }
        this.currentVehicule = new Vehicule();
        if (!this.currentVehicule.loadByIdentification(vehicleIdentification) && !this.currentVehicule.loadByImmat(vehicleRegistrationImmat, false)) {
            this.currentVehicule.setRegistrationNumber(vehicleRegistrationImmat);
            this.currentVehicule.setIdentificationNumber(vehicleIdentification);
            if (this.getVuFile().getTechnical() != null) {
                this.currentVehicule.setVuBrand(vuBrand);
                this.currentVehicule.setVuVersion(vuVersion);
            }
            if (Transport.apiMode == 1) {
                this.currentVehicule.insert();
                return this.currentVehicule.loadByImmat(vehicleRegistrationImmat, false) ? 1 : 2;
            }
            if (JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.unknownVehicle", vehicleRegistrationImmat), LanguageTranslator.getString("uev.reading.title", vehicleRegistrationImmat), 0, 3) == 0) {
                DialogCreationVehicule creation = new DialogCreationVehicule((Frame)MainFrameTransport.getInstance(), this.currentVehicule);
                creation.setVisible(true);
                if (creation.enregistrement) {
                    return this.currentVehicule.loadByImmat(vehicleRegistrationImmat, false) ? 1 : 2;
                }
            }
            return 0;
        }
        this.currentVehicule.updateTechnical(vehicleIdentification, vehicleRegistrationImmat, this.currentVehicule.getBrand(), vuBrand, vuVersion);
        return 1;
    }

    public int dataProcess() {
        if (Transport.apiMode == 0) {
            this.getProgression().setVisible(true);
            this.getProgression().getBar().setMinimum(0);
            this.getProgression().getBar().setMaximum(10);
        }
        String missingFile = "";
        if (this.getVuFile().getActivity() == null) {
            missingFile = String.valueOf(missingFile) + ",\"" + LanguageTranslator.getString("generics.activity") + "\"";
        }
        if (this.getVuFile().getEvent() == null) {
            missingFile = String.valueOf(missingFile) + ",\"" + LanguageTranslator.getString("vehicle.fault") + "\"";
        }
        if (this.getVuFile().getSpeed() == null) {
            missingFile = String.valueOf(missingFile) + ",\"" + LanguageTranslator.getString("generics.speed") + "\"";
        }
        if (this.getVuFile().getTechnical() == null) {
            missingFile = String.valueOf(missingFile) + ",\"" + LanguageTranslator.getString("vehicle.calibration") + "\"";
        }
        if (!missingFile.equals("") && !this.printErrorAndContinue(6, missingFile.substring(1))) {
            return 4;
        }
        try {
            this.setPbValue(3, null);
            this.save();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 7;
        }
        try {
            if (!this.setTelechargement()) {
                throw new Exception();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 9;
        }
        return 1;
    }

    int checkFileUEV() {
        int retour = -1;
        if (this.toRead == null || !this.toRead.getName().substring(this.toRead.getName().lastIndexOf(".")).toUpperCase().equals(".V1B")) {
            return 7;
        }
        if (UevDownload.loadList("NOM_FICHIER='" + this.toRead.getName() + "'").size() != 0) {
            retour = 1;
        }
        return retour;
    }

    private boolean setTelechargement() {
        boolean toReturn = true;
        String fileName = FileManager.moveFile(this.currentVehicule, this.toRead);
        if (fileName == null) {
            return false;
        }
        UevDownload toAdd = new UevDownload(this.currentVehicule, ConnexionSettings.getInstance().getUserCle(), this.getDlDate(this.toRead.getName()), fileName, this.beginActivity, this.endActivity, this.previousDownload);
        if (!toAdd.insert()) {
            toReturn = false;
        }
        if (ConversionTime.stringToDateDb(this.currentVehicule.getDateTelechargement(), true).before(this.readed.getDownloadDate())) {
            this.currentVehicule.setDateTelechargement(ConversionTime.dateToStringDb(this.readed.getDownloadDate()));
        }
        this.currentVehicule.setLastKnownKm(this.lastKnownKm);
        TimsLogger.debug("#UEVDP.setTelechargement# km moyen avant : " + this.currentVehicule.getAverageDailyKm() + ", totalKm=" + this.totalKm + " sur " + this.dayUsedCount + " jours dans le fichier, nouvelle moyenne = " + this.getDailyKm());
        this.currentVehicule.setAverageDailyKm(this.getDailyKm());
        this.currentVehicule.update();
        return toReturn;
    }

    private int getDailyKm() {
        if (this.currentVehicule.getAverageDailyKm() == 0 || this.dayUsedCount >= 180) {
            return this.totalKm / (this.dayUsedCount == 0 ? 1 : this.dayUsedCount);
        }
        int kmBefore = (180 - this.dayUsedCount) * this.currentVehicule.getAverageDailyKm();
        int done = kmBefore + this.totalKm;
        return done / 180;
    }

    public Date getDlDate(String nomFichier) {
        String dateBDD = "";
        String tmp = nomFichier.substring(nomFichier.length() - 14, nomFichier.length() - 4);
        String jour = tmp.substring(4, 6);
        String mois = tmp.substring(2, 4);
        String year = "20";
        if (Integer.parseInt(tmp.substring(0, 2)) >= 70) {
            year = "19";
        }
        String annee = String.valueOf(year) + tmp.substring(0, 2);
        String heure = String.valueOf(tmp.substring(6, 8)) + ":" + tmp.substring(8, 10);
        dateBDD = String.valueOf(annee) + "-" + mois + "-" + jour + " " + heure;
        return ConversionTime.stringToDate(dateBDD, "yyyy-MM-dd HH:mm");
    }

    /*
     * WARNING - void declaration
     */
    private void save() throws Exception {
        TimsLogger.debug("#UEVDP.saveInfos# d\u00e9but sauvegarde");
        Transport.ps.startOperation();
        int random = (int)(Math.random() * 1000.0);
        String vehicleTFn = String.valueOf(Transport.savePath) + "vehicle" + random + ".txt";
        while (new File(vehicleTFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            vehicleTFn = String.valueOf(Transport.savePath) + "vehicle" + random + ".txt";
        }
        String dayFn = String.valueOf(Transport.savePath) + "day_uev" + random + ".txt";
        String eventFaultFn = String.valueOf(Transport.savePath) + "eventFault" + random + ".txt";
        String speedFn = String.valueOf(Transport.savePath) + "speed" + random + ".txt";
        String calibrationFn = String.valueOf(Transport.savePath) + "calibration" + random + ".txt";
        String offenceFn = String.valueOf(Transport.savePath) + "offence" + random + ".txt";
        FileWriter fIOUEV = new FileWriter(vehicleTFn);
        FileWriter fDay = new FileWriter(dayFn);
        FileWriter fEventFault = new FileWriter(eventFaultFn);
        FileWriter fSpeed = new FileWriter(speedFn);
        FileWriter fCalibration = new FileWriter(calibrationFn);
        FileWriter fOffence = new FileWriter(offenceFn);
        Vector<CompanyCard> ccList = CompanyCard.loadList(new int[0]);
        UevSession last = UevSession.getLastUevSession(this.currentVehicule.getCleVehicule());
        Vector<UevSession> sessions = this.getSessionList();
        for (UevSession toCheck : sessions) {
            if (last != null && toCheck.getOpen().before(last.getOpen())) continue;
            if (CompanyCard.find(ccList, toCheck.getCompanyCard(), 17) == null) {
                new CompanyCard(0, this.currentVehicule.getAgencyId(), toCheck.getCompanyCard(), 17, null, null, null, toCheck.getCompany().trim(), toCheck.getCompanyAddress().trim(), 17, false, null);
                if (Transport.apiMode == 0) {
                    TimsLogger.info("carte entreprise inconnue " + toCheck.getCompanyCard());
                }
            }
            if (last != null && toCheck.getOpen().equals(last.getOpen()) && !last.getClose().equals(toCheck.getClose())) {
                last.setClose(toCheck.getClose());
                last.update();
            } else {
                toCheck.insert();
            }
            if (Transport.apiMode != 0) continue;
            TimsLogger.debug(String.valueOf(ConversionTime.dateToStringFr(toCheck.getOpen())) + " ->  " + ConversionTime.dateToStringFr(toCheck.getClose()) + " => " + toCheck.getCompany() + " (" + toCheck.getCompanyAddress() + ") " + toCheck.getCompanyCard());
        }
        this.sort();
        for (JourUEV toSave : this.getDayToSave()) {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                toSave.insert();
                continue;
            }
            TimsLogger.debug(toSave.getSQLInsert());
            fDay.write(String.valueOf(toSave.getSQLInsert()) + "\n");
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.noCardChecking"));
        Date begin = this.beginActivity;
        if (this.getIoToSave().size() != 0) {
            begin = this.getIoToSave().get(0).getDateDebut();
        }
        Vector<VehicleUsed> existingVehicleUsed = VehicleUsed.loadListVehicle(0, this.currentVehicule.getCleVehicule(), begin, this.endActivity);
        for (VehicleUsed vehicleUsed : this.getIoToSave()) {
            TimsLogger.debug("IO check " + vehicleUsed.getDateDebut());
            VehicleUsed existing = VehicleUsed.exist(vehicleUsed, existingVehicleUsed);
            if (existing != null) {
                if (existing.getDateFin() == null && vehicleUsed.getDateFin().getTime() > 100000L) {
                    existing.delete("vehicle_used");
                    TimsLogger.debug("IO \u00e0 " + vehicleUsed.getDateDebut() + " existe d\u00e9j\u00e0 dans la base mais pas de date de fin");
                } else {
                    TimsLogger.debug("IO \u00e0 " + vehicleUsed.getDateDebut() + " existe d\u00e9j\u00e0 dans la base");
                    continue;
                }
            }
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                vehicleUsed.getSQLInsert();
                continue;
            }
            fIOUEV.write(String.valueOf(vehicleUsed.getSQLInsert()) + "\n");
        }
        for (UevEventsFaults uevEventsFaults : this.getEfToSave()) {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                uevEventsFaults.insert();
            } else {
                fEventFault.write(String.valueOf(uevEventsFaults.getSQLString()) + "\n");
            }
            if (!Fonctions.getLibelleEventFault(uevEventsFaults.getTypeId()).equals(LanguageTranslator.getString("eventType.04"))) continue;
            long ms = uevEventsFaults.getEnd().getTime() - uevEventsFaults.getBegin().getTime();
            int length = (int)(ms / 60000L);
            boolean found = false;
            for (UevOffence toCheck : this.getOffenceToSave()) {
                if (toCheck.getOffenceTypeId() != 1 || Math.abs(uevEventsFaults.getBegin().getTime() - toCheck.getBegin().getTime()) > 120000L || Math.abs(uevEventsFaults.getEnd().getTime() - toCheck.getEnd().getTime()) > 120000L) continue;
                found = true;
                break;
            }
            if (found) continue;
            TimsLogger.error("#VuPG2.save# cardless offence not found" + uevEventsFaults.getBegin() + " " + uevEventsFaults.getEnd());
            this.getOffenceToSave().add(new UevOffence(this.currentVehicule.getCleVehicule(), 0, uevEventsFaults.getBegin(), uevEventsFaults.getEnd(), length, length, 3, 1));
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.speedInsert"));
        for (UevSpeed uevSpeed : this.getSpeedToSave()) {
            Conducteur tmpC;
            block31: {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    uevSpeed.insert();
                } else {
                    fSpeed.write(String.valueOf(uevSpeed.getSQLString()) + "\n");
                }
                tmpC = null;
                try {
                    tmpC = Conducteur.getDriver(this.getDrivers(), uevSpeed.getNumeroCarteConducteur(), -1);
                }
                catch (Exception ex) {
                    if (Transport.debug < 2) break block31;
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("unknow driver " + uevSpeed.getNumeroCarteConducteur());
                    }
                    this.unknownDriver.add(uevSpeed.getNumeroCarteConducteur());
                }
            }
            long ms = uevSpeed.getDateFin().getTime() - uevSpeed.getDateDebut().getTime();
            int length = (int)(ms / 60000L);
            this.getOffenceToSave().add(new UevOffence(this.currentVehicule.getCleVehicule(), tmpC != null ? tmpC.getCleConducteur() : 0, uevSpeed.getDateDebut(), uevSpeed.getDateFin(), length, uevSpeed.getVitesseMax(), 0, 2));
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.technicInsert"));
        Object var19_31 = null;
        for (UevCalibration uevCalibration : this.getCalibrationToSave()) {
            void var19_32;
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                uevCalibration.insert();
            } else {
                fCalibration.write(String.valueOf(uevCalibration.getSQLString()) + "\n");
            }
            if (var19_32 != null && var19_32.equals(uevCalibration.getAncienneDate().substring(0, 10))) continue;
            String string = uevCalibration.getAncienneDate().substring(0, 10);
            Intervention toAdd = new Intervention(0, 1, this.currentVehicule.getCleVehicule(), ConversionTime.stringToDate(uevCalibration.getAncienneDate(), "yyyy-MM-dd"), uevCalibration.getNouveauKM() > 10000000 ? uevCalibration.getAncienKM() : uevCalibration.getNouveauKM(), uevCalibration.getNom(), 0.0f, 0.0f, 0, null);
            toAdd.update();
        }
        for (UevOffence uevOffence : this.getOffenceToSave()) {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                uevOffence.insert();
                continue;
            }
            fOffence.write(String.valueOf(uevOffence.getSQLString()) + "\n");
        }
        fDay.close();
        fIOUEV.close();
        fEventFault.close();
        fSpeed.close();
        fCalibration.close();
        fOffence.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            Transport.ps.startOperation();
            this.setPbValue(4, LanguageTranslator.getString("uev.informationInsert"));
            this.db.loadVehicleDay(dayFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(5, LanguageTranslator.getString("uev.IOInsert"));
            this.db.loadVehicleUsed(vehicleTFn, "vehicle_used");
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(6, LanguageTranslator.getString("uev.eventsFaultsInsert"));
            this.db.loadVehicleEventsFaults(eventFaultFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(7, LanguageTranslator.getString("uev.speedInsert"));
            this.db.loadVehicleSpeed(speedFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(8, LanguageTranslator.getString("uev.technicInsert"));
            this.db.loadVehicleCalibration(calibrationFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev calibration");
            Transport.ps.startOperation();
            this.setPbValue(9, LanguageTranslator.getString("uev.offence"));
            this.db.loadVehicleOffence(offenceFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev calibration");
        }
        new File(vehicleTFn).delete();
        new File(dayFn).delete();
        new File(eventFaultFn).delete();
        new File(speedFn).delete();
        new File(calibrationFn).delete();
        if (Transport.apiMode == 0) {
            this.getProgression().dispose();
        }
        Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
    }

    private void sort() {
        Vector<JourUEV> daysToSort;
        this.dayToSave = new Vector();
        this.ioToSave = new Vector();
        this.efToSave = new Vector();
        this.calibrationToSave = new Vector();
        this.offenceToSave = new Vector();
        if (this.getVuFile().getActivity() != null && (daysToSort = this.convertActivity()).size() != 0) {
            boolean firstDay = true;
            Object daysToDelete = "";
            TimsLogger.debug("#VuPG2.sort# " + daysToSort.size() + " days to sort");
            for (JourUEV toAdd : daysToSort) {
                if (firstDay && toAdd.getActivities().size() != 0) {
                    JourUEV in = JourUEV.load(toAdd.getVehicleId(), toAdd.getDay());
                    int addedIdx = 0;
                    if (in != null && in.getActivities().size() != 0) {
                        UevActivity getUntil = toAdd.getActivities().get(0);
                        for (UevActivity toCheck : in.getActivities()) {
                            if (toCheck.getHeureDebut() >= getUntil.getHeureFin()) break;
                            toAdd.getActivities().add(addedIdx, toCheck);
                            ++addedIdx;
                            if (toCheck.getHeureFin() != getUntil.getHeureFin()) continue;
                            toAdd.getActivities().remove(addedIdx);
                        }
                    }
                    TimsLogger.debug("#UEVDP# premier journ\u00e9e trait\u00e9e " + addedIdx + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es");
                    firstDay = false;
                }
                daysToDelete = String.valueOf(daysToDelete) + ",\"" + ConversionTime.dateToStringDb(toAdd.getDay()) + "\"";
                this.dayToSave.add(toAdd);
            }
            if (!((String)daysToDelete).equals("")) {
                BddTransport.getInstance().delUEVActivityAndDay(this.currentVehicule, ((String)daysToDelete).substring(1));
            }
            for (ActivityInfo ai : this.getVuFile().getActivity()) {
                if (ai.getVuCardRecords() == null) continue;
                TimsLogger.debug("#VuPG2.sort# " + ai.getVuCardRecords().size() + " io to sort");
                for (VuCardRecord vcr : ai.getVuCardRecords()) {
                    VehicleUsed vu = VehicleUsed.fromVuCardRecord(vcr, this.currentVehicule);
                    if (!this.ioToSave.contains(vu)) {
                        TimsLogger.debug("#VuPG2.sort# on ins\u00e8re le vu " + vcr.getInsertion() + " " + vcr.getWithdraw() + " sur le jour " + ai.getDay());
                        this.ioToSave.add(vu);
                        continue;
                    }
                    TimsLogger.debug("#VuPG2.sort# on ignore le vu " + vcr.getInsertion() + " sur le jour " + ai.getDay());
                }
            }
        }
        if (this.getVuFile().getEvent() != null) {
            MainElement toSave;
            UevEventsFaults uevToCheck;
            if (this.getVuFile().getEvent().getVuEvents() != null) {
                TimsLogger.debug("#VuPG2.sort# " + this.getVuFile().getEvent().getVuEvents().size() + " events to sort");
                uevToCheck = new UevEventsFaults();
                for (VuEventRecord ver : this.getVuFile().getEvent().getVuEvents()) {
                    toSave = new UevEventsFaults(0, this.currentVehicule.getCleVehicule(), ver.getBegin(), ver.getEnd(), ver.getType(), ver.getPurpose(), ver.getDriverBegin().getCardNumber().getCardNumber(), ver.getCodriverBegin().getCardNumber().getCardNumber(), ver.getDriverEnd().getCardNumber().getCardNumber(), ver.getCodriverEnd().getCardNumber().getCardNumber(), ver.getSimilarEvent());
                    if (this.efToSave.contains(toSave)) {
                        TimsLogger.debug("#VuPG2.sort# events ever known in V1B file " + ((UevEventsFaults)toSave).getBegin());
                        continue;
                    }
                    if (uevToCheck.load(this.currentVehicule.getCleVehicule(), ver.getBegin())) {
                        TimsLogger.debug("#VuPG2.sort# events ever known in V1B file " + ((UevEventsFaults)toSave).getBegin());
                        continue;
                    }
                    this.efToSave.add((UevEventsFaults)toSave);
                }
            }
            if (this.getVuFile().getEvent().getVuFaults() != null) {
                TimsLogger.debug("#VuPG2.sort# " + this.getVuFile().getEvent().getVuEvents().size() + " faults to sort");
                uevToCheck = new UevEventsFaults();
                for (VuFaultRecord ver : this.getVuFile().getEvent().getVuFaults()) {
                    toSave = new UevEventsFaults(0, this.currentVehicule.getCleVehicule(), ver.getBegin(), ver.getEnd(), ver.getType(), ver.getPurpose(), ver.getDriverBegin().getCardNumber().getCardNumber(), ver.getCodriverBegin().getCardNumber().getCardNumber(), ver.getDriverEnd().getCardNumber().getCardNumber(), ver.getCodriverEnd().getCardNumber().getCardNumber(), ver.getSimilarEvent());
                    if (this.efToSave.contains(toSave)) {
                        TimsLogger.debug("#VuPG2.sort# faults ever known in V1B file " + ((UevEventsFaults)toSave).getBegin());
                        continue;
                    }
                    if (uevToCheck.load(this.currentVehicule.getCleVehicule(), ver.getBegin())) {
                        TimsLogger.debug("#VuPG2.sort# faults ever known in V1B file " + ((UevEventsFaults)toSave).getBegin());
                        continue;
                    }
                    this.efToSave.add((UevEventsFaults)toSave);
                }
            }
            if (this.getVuFile().getEvent().getVuOverSpeeding() != null) {
                TimsLogger.debug("#VuPG2.sort# " + this.getVuFile().getEvent().getVuOverSpeeding().size() + " overspeedings to sort");
                UevSpeed speedToCheck = new UevSpeed();
                for (VuOverSpeedingEvent os : this.getVuFile().getEvent().getVuOverSpeeding()) {
                    toSave = new UevSpeed(0, this.currentVehicule.getCleVehicule(), os.getBegin(), os.getEnd(), os.getType(), os.getPurpose(), os.getMaxSpeed(), os.getAverageSpeed(), os.getCard().getCardNumber().getCardNumber(), os.getSimilarEvent());
                    if (this.getSpeedToSave().contains(toSave)) {
                        TimsLogger.debug("#VuPG2.sort# overspeeding ever known in V1B file " + os.getBegin());
                        continue;
                    }
                    if (speedToCheck.load(this.currentVehicule.getCleVehicule(), os.getBegin())) {
                        TimsLogger.debug("#VuPG2.sort# overspeeding ever known in DB " + os.getBegin());
                        continue;
                    }
                    TimsLogger.debug("#VuPG2.sort# unkown overspeed " + os.getBegin());
                    this.getSpeedToSave().add((UevSpeed)toSave);
                }
            }
        }
        if (this.getVuFile().getTechnical() != null && this.getVuFile().getTechnical().getVuCalibrationList() != null) {
            TimsLogger.debug("#VuPG2.sort# " + this.getVuFile().getTechnical().getVuCalibrationList().size() + " calibrations to sort");
            UevCalibration last = null;
            if (this.currentVehicule.getNbEtalonnage() >= 1) {
                Vector<UevCalibration> db = Transport.bdd.getEtalonnage(this.currentVehicule.getCleVehicule());
                last = db.get(db.size() - 1);
            }
            if (last != null) {
                last.print();
            }
            boolean calibrationDelayChecked = false;
            boolean lastFound = last == null;
            for (VuCalibration c : this.getVuFile().getTechnical().getVuCalibrationList()) {
                UevCalibration toAdd = UevCalibration.createFromVuCalibration(c, this.currentVehicule.getCleVehicule());
                toAdd.print();
                if (!lastFound) {
                    TimsLogger.debug("#VuProcessingG2.sort()# on saute l'\u00e9talonnage " + c.getNewDate() + "- (" + c.getPurpose() + ")");
                    if (!last.equals(toAdd)) continue;
                    lastFound = true;
                    TimsLogger.debug("#VuProcessingG2.sort()# on ajoute \u00e0 partir de la");
                    continue;
                }
                if (c.getPurpose() != 4 && c.getPurpose() != 3 && c.getPurpose() != 2) continue;
                TimsLogger.debug("#VuPG2.sort()# on ajoute l'\u00e9talonnage " + c.getOldDate() + "-" + c.getPurpose());
                this.getCalibrationToSave().add(toAdd);
                if (calibrationDelayChecked || last == null) continue;
                Date theoric = ConversionTime.add(ConversionTime.stringToDate(last.getAncienneDate(), "yyyy-MM-dd"), 1, 2);
                Date done = ConversionTime.stringToDate(toAdd.getAncienneDate(), "yyyy-MM-dd");
                TimsLogger.debug("#VuPG2.sort# Le prochain \u00e9talonnage doit avoir lieu avant le " + theoric + " (il a lieu le " + done + ")");
                if (theoric.before(done)) {
                    TimsLogger.debug("#VuPG2.sort# infraction \u00e9talonnage le " + theoric);
                    this.getOffenceToSave().add(new UevOffence(this.currentVehicule.getCleVehicule(), 0, theoric, theoric, 0, 0, 3, 0));
                }
                calibrationDelayChecked = true;
            }
        }
        if (this.getVuFile().getSpeed() != null) {
            Date begin = null;
            int max = 0;
            int second = 0;
            Date first = this.getVuFile().getSpeed().getVuDetailedBlockSpeed().get(0).getMinut();
            if (this.ioToSave.size() == 0 || first.before(this.ioToSave.get(0).getDateDebut())) {
                TimsLogger.debug("VuPg2.Sort# absence d'I/O entre le  " + first + " et le " + (this.ioToSave.size() == 0 ? "jour" : this.ioToSave.get(0).getDateDebut()));
            }
            for (VuDetailedBlockSpeed vusb : this.getVuFile().getSpeed().getVuDetailedBlockSpeed()) {
                int x = 0;
                while (x < 59) {
                    if (vusb.getSpeedAt(x) > 90) {
                        if (begin == null) {
                            begin = ConversionTime.add(vusb.getMinut(), 13, x);
                            second = x;
                        }
                        max = Math.max(max, vusb.getSpeedAt(x));
                    } else if (begin != null) {
                        Date end = ConversionTime.add(vusb.getMinut(), 13, x);
                        VehicleUsed input = this.searchDriver(begin);
                        UevSpeed toCheck = new UevSpeed(0, this.currentVehicule.getCleVehicule(), begin, end, 99, 99, max, 0, input == null ? null : input.getNumeroCarte(), 0);
                        if (!this.isKnownOverSpeed(toCheck) && !toCheck.load(this.currentVehicule.getCleVehicule(), begin)) {
                            Conducteur tmpC;
                            block50: {
                                tmpC = null;
                                try {
                                    if (toCheck.getNumeroCarteConducteur() != null) {
                                        tmpC = Conducteur.getDriver(this.getDrivers(), toCheck.getNumeroCarteConducteur(), -1);
                                    }
                                }
                                catch (Exception ex) {
                                    if (Transport.debug < 2) break block50;
                                    if (Transport.apiMode == 0) {
                                        TimsLogger.debug("#VuPG2.Sort# unknow driver " + toCheck.getNumeroCarteConducteur());
                                    }
                                    this.unknownDriver.add(toCheck.getNumeroCarteConducteur());
                                }
                            }
                            TimsLogger.debug("VuPg2.Sort# overspeed ajout exc\u00e8s de " + ConversionTime.dateToString(begin, "dd/MM/YYYY HH:mm:ss") + " (" + second + " sec) / " + ConversionTime.dateToString(end, "dd/MM/YYYY HH:mm:ss") + " (" + x + " sec) => max constat\u00e9 " + max + " conducteur " + (input == null ? "?" : input.getNumeroCarte()));
                            this.getOffenceToSave().add(new UevOffence(this.currentVehicule.getCleVehicule(), tmpC == null ? 0 : tmpC.getCleConducteur(), begin, end, 0, max, 0, 3));
                        } else {
                            TimsLogger.debug("VuPg2.Sort# overspeed d\u00e9j\u00e0 connu exc\u00e8s de " + ConversionTime.dateToString(begin, "dd/MM/YYYY HH:mm:ss") + " (" + second + " sec) / " + ConversionTime.dateToString(end, "dd/MM/YYYY HH:mm:ss") + " (" + x + " sec) => max constat\u00e9 " + max + " conducteur " + (input == null ? "?" : input.getNumeroCarte()));
                        }
                        begin = null;
                        max = 0;
                    }
                    ++x;
                }
            }
        }
        for (JourUEV day : this.dayToSave) {
            int currentVu = 0;
            for (UevActivity act : day.getActivities()) {
                if (act.getCleType() != 1) continue;
                long begin = act.getBeginTimestamp();
                long end = act.getEndTimestamp();
                TimsLogger.debug("check " + act.getDateJour() + " " + ConversionTime.heureIntToString(act.getHeureDebut(), ":") + " " + ConversionTime.heureIntToString(act.getHeureFin(), ":") + " (" + begin + ":" + end + ")");
                while (currentVu < this.ioToSave.size()) {
                    VehicleUsed current = this.ioToSave.get(currentVu);
                    if (current.getDateDebut().getTime() < begin) {
                        if (current.getDateFin().getTime() > begin) {
                            if (current.getDateFin().getTime() > end) {
                                TimsLogger.debug("all found " + ConversionTime.dateToString(current.getDateDebut(), "HH:mm") + " " + ConversionTime.dateToString(current.getDateFin(), "HH:mm"));
                                begin = end;
                                break;
                            }
                            TimsLogger.debug("begin found " + ConversionTime.dateToString(current.getDateDebut(), "HH:mm") + " " + ConversionTime.dateToString(current.getDateFin(), "HH:mm"));
                            begin = current.getDateFin().getTime();
                        }
                    } else if (current.getDateDebut().getTime() < end && current.getDateFin().getTime() > end) {
                        TimsLogger.debug("end found " + ConversionTime.dateToString(current.getDateDebut(), "HH:mm") + " " + ConversionTime.dateToString(current.getDateFin(), "HH:mm"));
                        end = current.getDateDebut().getTime();
                    }
                    ++currentVu;
                }
                if (begin == end) continue;
                TimsLogger.debug("#Not found #" + ConversionTime.dateToString(new Date(begin), "HH:mm") + " " + ConversionTime.dateToString(new Date(end), "HH:mm"));
            }
        }
    }

    private boolean isKnownOverSpeed(UevSpeed toCheck) {
        for (UevSpeed s : this.getSpeedToSave()) {
            if (!s.like(toCheck)) continue;
            return true;
        }
        return false;
    }

    private VehicleUsed searchDriver(Date begin) {
        int i = this.ioToSave.size() - 1;
        while (i >= 0) {
            TimsLogger.debug("VuPg2.searchDriver# check " + this.ioToSave.get(i).getDateDebut() + " " + this.ioToSave.get(i).getDateFin());
            if (this.ioToSave.get(i).getDateDebut().before(begin) && (this.ioToSave.get(i).getDateFin().getTime() < 100000L || this.ioToSave.get(i).getDateFin().after(begin))) {
                TimsLogger.debug("VuPg2.searchDriver# found " + this.ioToSave.get(i).getNumeroCarte());
                return this.ioToSave.get(i);
            }
            if (this.ioToSave.get(i).getDateFin().getTime() >= 100000L && this.ioToSave.get(i).getDateFin().before(begin)) break;
            --i;
        }
        i = this.getVehicleUsedDB().size() - 1;
        while (i >= 0) {
            VehicleUsed toCheck = this.getVehicleUsedDB().get(i);
            if (toCheck.getDateDebut().before(begin) && (toCheck.getDateFin() == null || toCheck.getDateFin().getTime() < 100000L || toCheck.getDateFin().after(begin))) {
                TimsLogger.debug("VuPg2.searchDriver# found in db " + toCheck.getNumeroCarte());
                return toCheck;
            }
            if (toCheck.getDateFin() != null && toCheck.getDateFin().getTime() >= 100000L && toCheck.getDateFin().before(begin)) break;
            --i;
        }
        TimsLogger.debug("VuPg2.searchDriver# not found " + begin);
        return null;
    }

    private Vector<VehicleUsed> getVehicleUsedDB() {
        if (this.vehiclesDB == null) {
            this.vehiclesDB = VehicleUsed.loadListVehicle(0, this.currentVehicule.getCleVehicule(), ConversionTime.addDay(this.dateTelechargement, -45), this.dateTelechargement, true);
        }
        return this.vehiclesDB;
    }

    private Vector<VehicleUsed> getIoToSave() {
        return this.ioToSave;
    }

    private Vector<JourUEV> getDayToSave() {
        return this.dayToSave;
    }

    private Vector<UevEventsFaults> getEfToSave() {
        return this.efToSave;
    }

    private Vector<UevSpeed> getSpeedToSave() {
        if (this.speedToSave == null) {
            this.speedToSave = new Vector();
        }
        return this.speedToSave;
    }

    private Vector<UevCalibration> getCalibrationToSave() {
        return this.calibrationToSave;
    }

    private Vector<UevOffence> getOffenceToSave() {
        return this.offenceToSave;
    }

    private Vector<JourUEV> convertActivity() {
        Vector<JourUEV> converted = new Vector<JourUEV>();
        Vector<UevActivity> toReport = new Vector<UevActivity>();
        int x = 0;
        while (x < this.getVuFile().getActivity().size()) {
            ActivityInfo toConvert = this.getVuFile().getActivity().get(x);
            boolean hasNextDay = x < this.getVuFile().getActivity().size() - 1;
            int timeAdjustement = Fonctions.getTimeAdjustement(toConvert.getDay());
            int midnightKm = toConvert.getOdometerValueMidnight();
            int dailyKm = 0;
            int totalService = 0;
            if (x > 0) {
                dailyKm = midnightKm - this.getVuFile().getActivity().get(x - 1).getOdometerValueMidnight();
            }
            String dateDb = ConversionTime.dateToStringDb(toConvert.getDay());
            VuActivityDailyRecord act = toConvert.getActivities();
            Vector<UevActivity> dailyActivities = new Vector<UevActivity>();
            dailyActivities.addAll(toReport);
            toReport = new Vector();
            if (act != null) {
                int y = 0;
                while (y < act.size()) {
                    ActivityChangeInfo aci = act.get(y);
                    boolean hasNextAct = y < act.size() - 1;
                    int beginTime = aci.getMinut() + timeAdjustement;
                    if (aci.getMinut() == 0) {
                        if (dailyActivities.size() == 0) {
                            beginTime = 0;
                        } else {
                            UevActivity last = (UevActivity)dailyActivities.get(dailyActivities.size() - 1);
                            if (last.getCleType() == aci.getTimsActivityId()) {
                                beginTime = last.getHeureDebut();
                            }
                            dailyActivities.remove(dailyActivities.size() - 1);
                        }
                    }
                    int endTime = 1440;
                    if (hasNextAct) {
                        endTime = act.get(y + 1).getMinut() + timeAdjustement;
                    }
                    int length = endTime - beginTime;
                    if (beginTime > 1440) {
                        endTime = endTime - 1440 + (hasNextAct ? 0 : timeAdjustement);
                        TimsLogger.debug("#VuG2.convertAct# " + toConvert.getDay() + " => Full report " + (beginTime -= 1440) + " (original minut " + aci.getMinut() + ")");
                        toReport.add(new UevActivity(0, aci.getTimsActivityId(), "", "", beginTime, endTime, length, aci.getCardStateLibelle(), aci.getDrivingStateLibelle(), aci.getReaderStateLibelle(), ConversionTime.addDay(dateDb, "yyyy-MM-dd", 1)));
                    } else if (endTime > 1440) {
                        dailyActivities.add(new UevActivity(0, aci.getTimsActivityId(), "", "", beginTime, 1440, 1440 - beginTime, aci.getCardStateLibelle(), aci.getDrivingStateLibelle(), aci.getReaderStateLibelle(), dateDb));
                        TimsLogger.debug("#VuG2.convertAct# " + toConvert.getDay() + " => Partial report " + beginTime + " (original minut " + aci.getMinut() + ")");
                        toReport.add(new UevActivity(0, aci.getTimsActivityId(), "", "", 0, endTime - 1440, endTime - 1440, aci.getCardStateLibelle(), aci.getDrivingStateLibelle(), aci.getReaderStateLibelle(), ConversionTime.addDay(dateDb, "yyyy-MM-dd", 1)));
                    } else {
                        dailyActivities.add(new UevActivity(0, aci.getTimsActivityId(), "", "", beginTime, endTime, length, aci.getCardStateLibelle(), aci.getDrivingStateLibelle(), aci.getReaderStateLibelle(), dateDb));
                    }
                    ++y;
                }
            }
            if (dailyActivities.size() != 0) {
                TimsLogger.debug("#VuG2.convertAct# Conversion result on " + toConvert.getDay() + " (" + dateDb + ")");
                for (UevActivity t : dailyActivities) {
                    TimsLogger.debug("#VuG2.convertAct# " + dateDb + " : " + t.getHeureDebut() + " -> " + t.getHeureFin() + " (" + t.getDescription() + ")");
                    if (!Fonctions.isActiv(t.getCleType())) continue;
                    totalService += t.getDuree();
                }
                converted.add(new JourUEV(0, this.currentVehicule.getCleVehicule(), ConnexionSettings.getInstance().getUserCle(), toConvert.getDay(), toConvert.getOdometerValueMidnight(), dailyKm, totalService, null, dailyActivities));
            }
            ++x;
        }
        return converted;
    }

    private boolean printErrorAndContinue(int status, String name) {
        if (status == 6) {
            if (Transport.apiMode == 0) {
                SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("uev.noInformation", name), LanguageTranslator.getString("generics.warning"));
                tmp.run();
                if (tmp.option == 1) {
                    if (Transport.apiMode == 0) {
                        this.getProgression().dispose();
                    }
                    return false;
                }
            } else {
                this.errors.add(LanguageTranslator.getString("uev.noInformation", name));
                TimsLogger.info(LanguageTranslator.getString("uev.noInformation", name));
            }
        } else if (status == 10) {
            MessageSystemManager.error(null, LanguageTranslator.getString("uev.structure.error"), LanguageTranslator.getString("generics.error"));
            return false;
        }
        return true;
    }

    public Vector<UevSession> getSessionList() {
        if (this.getVuFile() == null || this.getVuFile().getIdentification().getVuCompanyLocksData() == null) {
            return null;
        }
        Vector<UevSession> toReturn = new Vector<UevSession>();
        for (VuCompanyLockData session : this.getVuFile().getIdentification().getVuCompanyLocksData()) {
            toReturn.add(UevSession.createFromVuCompanyLock(session, this.currentVehicule.getCleVehicule()));
        }
        return toReturn;
    }

    public HashMap<Date, Integer> getActiveDay() {
        if (this.getVuFile() == null || this.getVuFile().getIdentification().getVuCompanyLocksData() == null) {
            return null;
        }
        HashMap<Date, Integer> activeDay = new HashMap<Date, Integer>();
        for (ActivityInfo act : this.getVuFile().getActivity()) {
            if (act.getActivities().size() == 0) continue;
            activeDay.put(ConversionTime.dateTruncate(act.getDay()), act.getOdometerValueMidnight());
        }
        return activeDay;
    }

    public ProgressBar getProgression() {
        if (this.progression == null) {
            this.progression = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.reading.title", this.currentVehicule.getRegistrationNumber()));
            this.progression.setVisible(true);
        }
        return this.progression;
    }

    private void setPbValue(int value, String text) {
        if (Transport.apiMode == 1) {
            return;
        }
        if (value != -1) {
            this.getProgression().getBar().setValue(value);
        }
        if (text != null) {
            this.getProgression().getBar().setString(text);
        }
    }

    private Vector<Conducteur> getDrivers() {
        if (this.drivers == null) {
            this.drivers = Conducteur.loadListWithArchive(new Integer[0]);
        }
        return this.drivers;
    }

    public TreeMap<String, Hashtable<Integer, String>> getDetailedSpeed() throws VuFileNotFoundException {
        if (this.getVuFile().getSpeed() == null) {
            throw new VuFileNotFoundException(Integer.toHexString(UEVProperty.ID_SPEED));
        }
        TreeMap<String, Hashtable<Integer, String>> tmp = new TreeMap<String, Hashtable<Integer, String>>();
        SimpleDateFormat fDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat fHour = new SimpleDateFormat("HH'h'mm");
        for (VuDetailedBlockSpeed b : this.getVuFile().getSpeed().getVuDetailedBlockSpeed()) {
            int y = 0;
            byte[] byArray = b.getSpeed();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ex;
                byte i = byArray[n2];
                Date sec = ConversionTime.add(b.getMinut(), 13, y);
                String date = fDate.format(sec);
                int min = ConversionTime.heureStringToInt(fHour.format(sec), "h");
                int vitesse = Fonctions.oneByteToInt(i);
                if (!tmp.containsKey(date)) {
                    tmp.put(date, new Hashtable());
                }
                if ((ex = tmp.get(date).get(min)) == null) {
                    tmp.get(date).put(min, String.valueOf(vitesse));
                } else {
                    tmp.get(date).put(min, String.valueOf(ex) + ";" + vitesse);
                }
                ++y;
                ++n2;
            }
        }
        return tmp;
    }

    public Vector<UevSpeed> getSpeed(Vehicule v) {
        this.parseFile();
        if (this.getVuFile().getEvent().getVuOverSpeeding() != null) {
            TimsLogger.debug("#VuPG2.getSpeed# " + this.getVuFile().getEvent().getVuOverSpeeding().size() + " overspeedings to sort");
            for (VuOverSpeedingEvent os : this.getVuFile().getEvent().getVuOverSpeeding()) {
                TimsLogger.debug("#VuPG2.getSpeed# " + os.getBegin() + "=> max : " + os.getMaxSpeed());
                UevSpeed toSave = new UevSpeed(0, v.getCleVehicule(), os.getBegin(), os.getEnd(), os.getType(), os.getPurpose(), os.getMaxSpeed(), os.getAverageSpeed(), os.getCard().getCardNumber().getCardNumber(), os.getSimilarEvent());
                if (this.getSpeedToSave().contains(toSave)) {
                    TimsLogger.debug("#VuPG2.getSpeed# overspeeding ever known in V1B file " + os.getBegin());
                    continue;
                }
                this.getSpeedToSave().add(toSave);
            }
        }
        return this.getSpeedToSave();
    }

    public Vector<UevSpeed> getOverSpeed() {
        this.parseFile();
        this.loadOrCreateVehicle();
        this.sort();
        return this.speedToSave;
    }
}

