/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.comm;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Pays;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.DriverCardSaving;
import transpo.system.uev.VuFileParserG2;
import transpo.system.uev.comm.UEVConnection;
import transpo.system.uev.comm.UevProperty;
import transpo.system.uev.comm.UevStructure;
import transpo.system.uev.comm.WindowsRS232Connector;
import transpo.system.uev.object.IdentificationInfo;
import transpo.system.ui.viewable.ProgressView;
import transpo.system.util.Fonctions;

public class UEVAcquisition {
    private UEVConnection uevConnection = null;
    private UevStructure tableFichier = new UevStructure();
    private ProgressView progressView = null;
    private String driverCardFilePath = "temp.C1B";
    private String uevFilePath = "temp.V1B";
    private boolean fromLast = true;

    public UEVAcquisition() {
        this.uevConnection = new UEVConnection(new WindowsRS232Connector());
    }

    public void setProgressView(ProgressView progressView) {
        this.progressView = progressView;
    }

    public int process() {
        String dd;
        String finalName;
        boolean driverCard;
        FileOutputStream outputStream;
        File file;
        int toReturn;
        block35: {
            block34: {
                SimpleDateFormat formatter;
                block33: {
                    toReturn = 1;
                    if (this.progressView != null) {
                        this.progressView.setVisible(true);
                        this.progressView.setMinimum(0);
                        this.progressView.setText("initialisation");
                    }
                    file = new File(this.uevFilePath);
                    outputStream = new FileOutputStream(file);
                    driverCard = false;
                    finalName = "";
                    formatter = new SimpleDateFormat("yyMMddHHmm");
                    dd = null;
                    if (this.uevConnection.etablishConnexion() == 1 && this.uevConnection.openDiagnosticSession() == 1 && this.uevConnection.downloadRequest() == 1) break block33;
                    return -1;
                }
                try {
                    this.tableFichier.makeFirstTable();
                    File c1b = new File(this.driverCardFilePath);
                    FileOutputStream c1bOS = new FileOutputStream(c1b);
                    if (this.progressView != null) {
                        this.progressView.setMaximum(this.tableFichier.arrayRead.length);
                    }
                    String identificationFile = Fonctions.parseString("7621");
                    int trameNb = 0;
                    while (trameNb < this.tableFichier.arrayRead.length) {
                        if (this.progressView != null) {
                            this.progressView.incrementValue(1);
                        }
                        if (this.progressView != null) {
                            this.progressView.setText("lecture " + this.tableFichier.arrayRead[trameNb]);
                        }
                        int trameCount = 1;
                        TimsLogger.verbose("readUev() select trame = " + this.tableFichier.arrayRead[trameNb] + " part " + trameCount);
                        int response = this.uevConnection.sendCommand(this.tableFichier.arrayRead[trameNb]);
                        if (response != 1 && response != 250) {
                            TimsLogger.warn("readUev() return error " + response);
                            toReturn = response;
                            break;
                        }
                        if (response == 250) {
                            TimsLogger.warn("readUev() DATA_UNAVAILABLE");
                        } else {
                            String buffer;
                            String receivedDate = buffer.substring((buffer = this.uevConnection.getLastResponse()).length() >= 255 ? 4 : 2);
                            String toWrite = String.valueOf(Fonctions.parseString("76")) + Fonctions.parseString(this.tableFichier.arrayRead[trameNb].substring(2, 4));
                            toWrite = String.valueOf(toWrite) + receivedDate;
                            if (this.tableFichier.arrayRead[trameNb].equals("3621")) {
                                identificationFile = String.valueOf(identificationFile) + receivedDate;
                            }
                            TimsLogger.verbose("#UEVAcquisition.readUev()# on ecrit dans le fichier " + Fonctions.parseAscii(toWrite));
                            TimsLogger.verbose("#UEVAcquisition.readUev()# length " + toWrite.length() + " " + toWrite.getBytes().length);
                            ((OutputStream)outputStream).write(toWrite.getBytes());
                            while (this.uevConnection.getLastResponse().length() >= 255) {
                                if (this.progressView != null) {
                                    this.progressView.setText("lecture " + this.tableFichier.arrayRead[trameNb] + " part " + trameCount);
                                }
                                TimsLogger.verbose("readUev() select trame = " + this.tableFichier.arrayRead[trameNb] + " part " + ++trameCount);
                                String receipt = Integer.toHexString(trameCount);
                                while (receipt.length() != 4) {
                                    receipt = "0" + receipt;
                                }
                                response = this.uevConnection.sendCommand(receipt = "8376" + receipt);
                                if (response != 1 && response != 250) {
                                    TimsLogger.warn("readUev() return error " + response);
                                    toReturn = response;
                                    break;
                                }
                                if (response == 250) {
                                    TimsLogger.warn("readUev() DATA_UNAVAILABLE");
                                    continue;
                                }
                                buffer = this.uevConnection.getLastResponse();
                                String part = this.tableFichier.arrayRead[trameNb].substring(2, 4);
                                if (part.equalsIgnoreCase("01") && trameCount == 2) {
                                    int cardIssuingMemberState = UevProperty.bytesToInt(buffer.getBytes(), 158, 1);
                                    String pays = Pays.LIBELLE[cardIssuingMemberState][0];
                                    TimsLogger.verbose("readUev() code pays = " + cardIssuingMemberState + " (" + pays + ")");
                                    String immat = buffer.substring(160, 173);
                                    TimsLogger.verbose("readUev() immat = " + immat);
                                    byte[] byteBuffer = buffer.getBytes();
                                    int dateInt = Fonctions.bytesToInt(byteBuffer, 173, 4);
                                    Date dateNow = new Date((long)dateInt * 1000L);
                                    dateInt = Fonctions.bytesToInt(byteBuffer, 177, 4);
                                    Date dateMin = new Date((long)dateInt * 1000L);
                                    dateInt = Fonctions.bytesToInt(byteBuffer, 181, 4);
                                    Date dateMax = new Date((long)dateInt * 1000L);
                                    dateInt = Fonctions.bytesToInt(byteBuffer, 186, 4);
                                    Date lastDl = new Date((long)dateInt * 1000L);
                                    dd = formatter.format(dateNow);
                                    finalName = String.valueOf(pays) + immat + dd + ".V1B";
                                    if (this.fromLast) {
                                        this.tableFichier.makeTable(lastDl.getTime(), new Date().getTime());
                                    } else {
                                        this.tableFichier.makeTable(dateMin.getTime(), new Date().getTime());
                                    }
                                    char slotStatus = buffer.charAt(181);
                                    if (slotStatus == 'A' || slotStatus == '\u0014') {
                                        driverCard = true;
                                    } else {
                                        TimsLogger.debug("Carte out");
                                    }
                                }
                                if (part.equalsIgnoreCase("21")) {
                                    identificationFile = String.valueOf(identificationFile) + buffer.substring(4);
                                }
                                if (this.tableFichier.arrayRead[trameNb].substring(2, 4).equalsIgnoreCase("06")) {
                                    toWrite = buffer.substring(4);
                                    ((OutputStream)c1bOS).write(toWrite.getBytes());
                                    c1bOS.flush();
                                }
                                toWrite = buffer.substring(4);
                                TimsLogger.verbose("#UEVAcquisition.readUev()# on ecrit dans le fichier " + Fonctions.parseAscii(toWrite));
                                ((OutputStream)outputStream).write(toWrite.getBytes());
                            }
                            TimsLogger.verbose("#UEVAcquisition.readUev()# fin de r\u00e9ponse pour le fichier " + this.tableFichier.arrayRead[trameNb]);
                            if (this.tableFichier.arrayRead[trameNb].equals("3621")) {
                                TimsLogger.debug("#UEVAcquisition.readUev()# on lit l'identification et on construit le tableau");
                                IdentificationInfo info = VuFileParserG2.parseIdentification(identificationFile.getBytes());
                                TimsLogger.debug("#UEVAcquisition.readUev()# " + info.getVehicleRegistrationIdentification().toString() + " <> " + info.getVuDownloadActivityData() + " <> " + info.getVuDownloadablePeriod().getMinDownloadableTime() + " <> " + info.getVuDownloadablePeriod().getMaxDownloadableTime());
                                long begin = info.getVuDownloadActivityData().getDownloadTime().getTime();
                                if (!this.fromLast || begin < info.getVuDownloadablePeriod().getMinDownloadableTime().getTime()) {
                                    begin = info.getVuDownloadablePeriod().getMinDownloadableTime().getTime();
                                }
                                TimsLogger.debug("#UEVAcquisition.readUev()# construct table from " + ConversionTime.getDate(begin / 1000L));
                                this.tableFichier.makeTable(begin, new Date().getTime());
                                if (info.getCardSlotStatus().isDriverCardInserted()) {
                                    driverCard = true;
                                }
                                String vrn = info.getVehicleRegistrationIdentification().getVehicleRegistrationNumber();
                                while (vrn.length() < 13) {
                                    vrn = String.valueOf(vrn) + "_";
                                }
                                String date = formatter.format(info.getCurrentDateTime());
                                finalName = String.valueOf(vrn) + date + ".V1B";
                            }
                        }
                        ++trameNb;
                    }
                    ((OutputStream)c1bOS).close();
                    if (this.progressView != null) {
                        this.progressView.setText("fermeture de la connexion");
                    }
                    if (this.uevConnection.endOfDownload() != 2) break block34;
                    return 2;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return 2;
                }
            }
            if (this.uevConnection.endOfCommunication() != 2) break block35;
            return 2;
        }
        outputStream.flush();
        ((OutputStream)outputStream).close();
        if (!finalName.equals("")) {
            TimsLogger.debug("renameTo " + finalName);
            file.renameTo(new File(finalName));
        }
        if (driverCard) {
            File toRename = new File(this.driverCardFilePath);
            DriverCardSaving dcs = new DriverCardSaving(toRename);
            String finalCardName = String.valueOf(dcs.getMemberState()) + dcs.getCardNumber() + dd + ".C1B";
            toRename.renameTo(new File(finalCardName));
        }
        return toReturn;
    }
}

