/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.comm;

import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.uev.comm.BasicRS232Connector;
import transpo.system.uev.comm.BasicUEVConnection;
import transpo.system.util.Fonctions;

public class UEVConnection
extends BasicUEVConnection {
    boolean init = false;

    public UEVConnection(BasicRS232Connector connector) {
        this.setConnector(connector);
    }

    @Override
    public int etablishConnexion() {
        TimsLogger.verbose("etablishConnexion() ...");
        if (this.getConnector() == null) {
            return 16;
        }
        if (this.getConnector().connect() != 1) {
            return 32;
        }
        int status = 0;
        do {
            this.getConnector().send("81EEF081E0");
            String response = this.getConnector().receive();
            if (response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE03C1EA8F9B"))) {
                TimsLogger.info("etablishConnexion() Connection etablish with the UEV");
                status = 1;
                continue;
            }
            TimsLogger.warn("etablishConnexion() Error connection with the UEV try to etablish a new connection");
            status = 48;
        } while (status != 1);
        this.init = true;
        return 1;
    }

    @Override
    public int openDiagnosticSession() {
        TimsLogger.verbose("openDiagnosticSession() ...");
        if (!this.init) {
            TimsLogger.warn("#openDiagnosticSession# You should use etablishConnection first");
        }
        int status = this.getConnector().send("80EEF0021081F1");
        String response = this.getConnector().receive();
        if (response == null) {
            return 48;
        }
        if (response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE02508131"))) {
            TimsLogger.debug("openDiagnosticSession() Diagnostic Session Open");
            return 1;
        }
        TimsLogger.debug("openDiagnosticSession() Error during etablish a Diagnostic Session");
        return 2;
    }

    @Override
    public int setBaudrateUev(int baudrate) {
        block13: {
            String response;
            block12: {
                TimsLogger.verbose("setBaudrateUev() ...");
                if (!this.init) {
                    TimsLogger.info("#setBaudrateUev# You must use etablishConnection first");
                }
                try {
                    String sBaudrate = "01EC";
                    switch (baudrate) {
                        case 19200: {
                            sBaudrate = "02ED";
                            break;
                        }
                        case 38400: {
                            sBaudrate = "03EE";
                            break;
                        }
                        case 57600: {
                            sBaudrate = "04EF";
                            break;
                        }
                        case 115200: {
                            sBaudrate = "05F0";
                            break;
                        }
                        default: {
                            sBaudrate = "01EC";
                        }
                    }
                    String command = "80EEF004870101" + sBaudrate;
                    TimsLogger.verbose("setBaudrateUev() Try to set Uev baudrate " + baudrate + " with command " + command);
                    int status = this.getConnector().send(command);
                    response = this.getConnector().receive();
                    if (response != null) break block12;
                    return 48;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return 0;
                }
            }
            if (!response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE02C70128"))) break block13;
            TimsLogger.verbose("setBaudrateUev() Baudrate (" + baudrate + ") is set ");
            this.getConnector().send("80EEF003870203ED");
            if (this.getConnector().setBaudRate(baudrate) == 1) {
                return 1;
            }
            return 2;
        }
        TimsLogger.warn("setBaudrateUev() Error setting baud rate");
        return 64;
    }

    @Override
    public int downloadRequest() {
        TimsLogger.verbose("downloadRequest() ...");
        if (!this.init) {
            TimsLogger.warn("#downloadRequest# You should use etablishConnection first");
        }
        TimsLogger.verbose("downloadRequest() Try to request a download");
        int status = this.getConnector().send("80EEF00A350000000000FFFFFFFF99");
        String response = this.getConnector().receive();
        if (response == null) {
            return 48;
        }
        if (response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE037500FFD5"))) {
            TimsLogger.debug("downloadRequest() Download Request OK");
            return 1;
        }
        TimsLogger.warn("downloadRequest() Error during the download Request");
        return 2;
    }

    @Override
    public int endOfDownload() {
        TimsLogger.verbose("endOfDownload() ...");
        if (!this.init) {
            TimsLogger.warn("You should use etablishConnection first");
        }
        TimsLogger.verbose("endOfDownload() Try to request a end of download");
        int status = this.getConnector().send("80EEF0013796");
        String response = this.getConnector().receive();
        if (response == null) {
            return 48;
        }
        if (response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE0177D6"))) {
            TimsLogger.debug("endOfDownload() endOfDownload OK");
            return 1;
        }
        TimsLogger.warn("endOfDownload() Error during the endOfDownload");
        return 2;
    }

    @Override
    public int endOfCommunication() {
        TimsLogger.verbose("endOfCommunication() ...");
        if (!this.init) {
            TimsLogger.warn("You should use etablishConnection first");
        }
        TimsLogger.verbose("endOfCommunication() Try to request end of communication");
        int status = this.getConnector().send("80EEF00182E1");
        String response = this.getConnector().receive();
        if (response == null) {
            return 48;
        }
        if (response.equalsIgnoreCase(Fonctions.HtoIConverter("80F0EE01C221"))) {
            TimsLogger.debug("endOfCommunication() endOfCommunication OK");
            return 1;
        }
        TimsLogger.warn("endOfCommunication() Error during the endOfCommunication");
        return 2;
    }

    @Override
    public int sendCommand(String command) {
        block11: {
            block10: {
                TimsLogger.verbose("sendCommand() ...");
                String length = Integer.toHexString(command.length() / 2);
                while (length.length() < 2) {
                    length = "0" + length;
                }
                String fullCmd = "80EEF0" + length + command;
                int checkSum = UEVConnection.getChecksumTc(fullCmd);
                String sCheckSum = Integer.toHexString(checkSum);
                while (sCheckSum.length() < 2) {
                    sCheckSum = "0" + sCheckSum;
                }
                fullCmd = (String.valueOf(fullCmd) + sCheckSum).toUpperCase();
                TimsLogger.verbose("sendCommand() sending..." + fullCmd);
                long time = new Date().getTime();
                int status = this.getConnector().send(fullCmd);
                long time2 = new Date().getTime();
                this.lastResponse = this.getConnector().receive();
                long time3 = new Date().getTime();
                TimsLogger.verbose("TIME => Send in " + (time2 - time) + ", receive in " + (time3 - time2) + " (" + fullCmd + ")");
                if (this.lastResponse != null) break block10;
                return 48;
            }
            try {
                TimsLogger.verbose("#UEVConnection.sendCommand()# sendCommand() response " + (this.lastResponse == null ? "0" : (this.lastResponse.length() > 10 ? "" + this.lastResponse.length() : Fonctions.parseAscii(this.lastResponse))));
                while (this.isPending()) {
                    TimsLogger.debug("sendCommand() RESPONSE_PENDING ...");
                    this.lastResponse = this.getConnector().receive();
                }
                if (!this.isNoCompanyCard()) break block11;
                TimsLogger.warn("sendCommand() #ERROR_NO_COMPANY_CARD");
                return 87;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 2;
            }
        }
        if (this.isError()) {
            TimsLogger.warn("sendCommand() status (startwith 80F0EE037F) ... ");
            String error = Fonctions.parseAscii(this.lastResponse.substring(6, 7));
            TimsLogger.warn("... error = " + error);
            return Integer.parseInt(error, 16);
        }
        if (this.lastResponse.length() > 9) {
            this.lastResponse = this.lastResponse.substring(4, this.lastResponse.length() - 1);
        } else {
            TimsLogger.debug("#UEVConnection.sendCommand()# buffString < 9 ???????? on met null.... ???? !!!!");
        }
        return 1;
    }

    private boolean isNoCompanyCard() {
        return this.isError() && this.lastResponse.substring(6, 7).equals(Fonctions.HtoIConverter("50"));
    }

    private boolean isError() {
        return this.lastResponse.startsWith(Fonctions.HtoIConverter("80F0EE037F"));
    }

    private boolean isPending() {
        return this.isError() && this.lastResponse.substring(6, 7).equals(Fonctions.HtoIConverter("78"));
    }
}

