/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.comm;

import com.sun.comm.Win32Driver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import transpo.system.TimsLogger;
import transpo.system.uev.comm.BasicRS232Connector;
import transpo.system.util.Fonctions;

public class WindowsRS232Connector
implements BasicRS232Connector {
    public SerialPort port;
    private InputStream inStream;
    private OutputStream outStream;
    private final String portName = "COM5";
    protected static boolean init = false;
    private String buffer = null;

    @Override
    public int connect() {
        if (init) {
            return 1;
        }
        TimsLogger.debug(System.getProperty("java.library.path"));
        Win32Driver w32Driver = new Win32Driver();
        w32Driver.initialize();
        CommPortIdentifier portId = null;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)"COM5");
        }
        catch (NoSuchPortException ex) {
            TimsLogger.warn("No Port Name COM5");
            return 2;
        }
        try {
            this.port = (SerialPort)portId.open("GM TIMS", 5000);
            this.port.setFlowControlMode(0);
            this.port.setSerialPortParams(9600, 8, 1, 2);
            this.outStream = this.port.getOutputStream();
            this.inStream = this.port.getInputStream();
        }
        catch (PortInUseException ex) {
            TimsLogger.warn("Port Name COM5 in use");
            return 2;
        }
        catch (Exception ex) {
            TimsLogger.warn("Error unknow");
            ex.printStackTrace();
            return 2;
        }
        init = true;
        TimsLogger.info("#Win RS 232 Connector# Port Name COM5 open");
        return 1;
    }

    @Override
    public int close() {
        this.port.close();
        return 1;
    }

    @Override
    public int setBaudRate(int baudrate) {
        try {
            this.port.setSerialPortParams(baudrate, 8, 1, 2);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return 2;
        }
        return 1;
    }

    @Override
    public int send(String command) {
        TimsLogger.verbose("#WindowsRS232Connector.send# sending ... " + command + " (" + Fonctions.parseString(command) + ")");
        byte[] toSent = Fonctions.parseStringToByteArray(command);
        int x = 0;
        while (x < toSent.length) {
            System.out.print(String.valueOf(toSent[x]));
            ++x;
        }
        byte[] toSend = Fonctions.parseStringToByteArray(command);
        command = Fonctions.parseString(command);
        try {
            this.outStream.write(toSend);
            this.outStream.flush();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
    }

    @Override
    public String receive() {
        TimsLogger.verbose("#WindowsRS232Connector.receive# ... ");
        boolean headerReaded = false;
        int sizeToBeRead = 4;
        int counter = 0;
        try {
            this.buffer = "";
            int readed = -1;
            do {
                readed = this.inStream.read();
                this.buffer = String.valueOf(this.buffer) + (char)readed;
                System.out.print(String.valueOf((char)readed) + "-" + readed + " (" + (char)(readed & 0xFF) + ")  ");
                if (headerReaded || counter != 3) continue;
                headerReaded = true;
                counter = -1;
                sizeToBeRead = readed + 1;
            } while (++counter != sizeToBeRead);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TimsLogger.verbose("#WindowsRS232Connector.receive# received " + this.buffer + " " + Fonctions.parseAscii(this.buffer) + " OK");
        return this.buffer;
    }
}

