/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.uev.object.ExtendedSerialNumber;
import transpo.system.uev.object.FullCardNumber;
import transpo.system.uev.object.SealRecord;
import transpo.system.uev.object.VehicleRegistrationIdentification;
import transpo.system.util.Fonctions;

public class VuCalibration {
    public static int V1_RECORD_SIZE = 222;
    public static int V2_RECORD_SIZE = 252;
    private int purpose = 0;
    private String name = null;
    private String address = null;
    private FullCardNumber card = null;
    private Date cardExpiry = null;
    private String vehicleIdentificationNumber = null;
    private VehicleRegistrationIdentification vehicleRegistrationIdentification = null;
    private int w;
    private int k;
    private int l;
    private String tyreSize;
    private int authorizedSpeed;
    private int oldOdometer;
    private int newOdometer;
    private Date oldDate;
    private Date newDate;
    private Date nextDate;
    private ArrayList<SealRecord> seals;
    private ExtendedSerialNumber sensorSN = null;
    private ExtendedSerialNumber sensorGNSSSN = null;
    private ExtendedSerialNumber rcmSN = null;
    private int loadType = 0;
    private int country = 0;
    private Date countryTimestamp = null;

    public int getPurpose() {
        return this.purpose;
    }

    public void setPurpose(int purpose) {
        this.purpose = purpose;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public FullCardNumber getCard() {
        return this.card;
    }

    public void setCard(FullCardNumber card) {
        this.card = card;
    }

    public Date getCardExpiry() {
        return this.cardExpiry;
    }

    public void setCardExpiry(Date cardExpiry) {
        this.cardExpiry = cardExpiry;
    }

    public String getVehicleIdentificationNumber() {
        return this.vehicleIdentificationNumber;
    }

    public void setVehicleIdentificationNumber(String vehicleIdentificationNumber) {
        this.vehicleIdentificationNumber = vehicleIdentificationNumber;
    }

    public VehicleRegistrationIdentification getVehicleRegistrationIdentification() {
        return this.vehicleRegistrationIdentification;
    }

    public void setVehicleRegistrationIdentification(VehicleRegistrationIdentification vehicleRegistrationIdentification) {
        this.vehicleRegistrationIdentification = vehicleRegistrationIdentification;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        this.l = l;
    }

    public String getTyreSize() {
        return this.tyreSize;
    }

    public void setTyreSize(String tyreSize) {
        this.tyreSize = tyreSize;
    }

    public int getAuthorizedSpeed() {
        return this.authorizedSpeed;
    }

    public void setAuthorizedSpeed(int authorizedSpeed) {
        this.authorizedSpeed = authorizedSpeed;
    }

    public int getOldOdometer() {
        return this.oldOdometer;
    }

    public void setOldOdometer(int oldOdometer) {
        this.oldOdometer = oldOdometer;
    }

    public int getNewOdometer() {
        return this.newOdometer;
    }

    public void setNewOdometer(int newOdometer) {
        this.newOdometer = newOdometer;
    }

    public Date getOldDate() {
        return this.oldDate;
    }

    public void setOldDate(Date oldDate) {
        this.oldDate = oldDate;
    }

    public Date getNewDate() {
        return this.newDate;
    }

    public void setNewDate(Date newDate) {
        this.newDate = newDate;
    }

    public Date getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(Date nextDate) {
        this.nextDate = nextDate;
    }

    public ArrayList<SealRecord> getSeals() {
        return this.seals;
    }

    public void setSeal(ArrayList<SealRecord> seals) {
        this.seals = seals;
    }

    public ExtendedSerialNumber getSensorSN() {
        return this.sensorSN;
    }

    public void setSensorSN(ExtendedSerialNumber sensorSN) {
        this.sensorSN = sensorSN;
    }

    public ExtendedSerialNumber getSensorGNSSSN() {
        return this.sensorGNSSSN;
    }

    public void setSensorGNSSSN(ExtendedSerialNumber sensorGNSSSN) {
        this.sensorGNSSSN = sensorGNSSSN;
    }

    public ExtendedSerialNumber getRcmSN() {
        return this.rcmSN;
    }

    public void setRcmSN(ExtendedSerialNumber rcmSN) {
        this.rcmSN = rcmSN;
    }

    public int getLoadType() {
        return this.loadType;
    }

    public void setLoadType(int loadType) {
        this.loadType = loadType;
    }

    public int getCountry() {
        return this.country;
    }

    public void setCountry(int country) {
        this.country = country;
    }

    public Date getCountryTimestamp() {
        return this.countryTimestamp;
    }

    public void setCountryTimestamp(Date countryTimestamp) {
        this.countryTimestamp = countryTimestamp;
    }

    public void setSeals(ArrayList<SealRecord> seals) {
        this.seals = seals;
    }

    public VuCalibration(byte[] toParse) {
        this.purpose = Fonctions.bytesToInt(toParse, 0, 1);
        this.name = Fonctions.getStringFromBuffer(toParse, 1, 36, 1);
        this.address = Fonctions.getStringFromBuffer(toParse, 37, 36, 1);
        this.card = new FullCardNumber(Arrays.copyOfRange(toParse, 73, 73 + FullCardNumber.RECORD_SIZE));
        this.cardExpiry = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 91, 4));
        this.vehicleIdentificationNumber = Fonctions.getStringFromBuffer(toParse, 95, 17);
        this.vehicleRegistrationIdentification = new VehicleRegistrationIdentification(Arrays.copyOfRange(toParse, 112, 127));
        this.w = Fonctions.bytesToInt(toParse, 127, 2);
        this.k = Fonctions.bytesToInt(toParse, 129, 2);
        this.l = Fonctions.bytesToInt(toParse, 131, 2);
        this.tyreSize = Fonctions.getStringFromBuffer(toParse, 133, 15);
        this.authorizedSpeed = Fonctions.bytesToInt(toParse, 148, 1);
        this.oldOdometer = Fonctions.bytesToInt(toParse, 149, 3);
        this.newOdometer = Fonctions.bytesToInt(toParse, 152, 3);
        this.oldDate = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 155, 4));
        this.newDate = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 159, 4));
        this.nextDate = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 163, 4));
        int offset = 167;
        if (toParse.length == V2_RECORD_SIZE) {
            this.sensorSN = new ExtendedSerialNumber(Arrays.copyOfRange(toParse, offset, offset + 8));
            this.sensorGNSSSN = new ExtendedSerialNumber(Arrays.copyOfRange(toParse, offset += 8, offset + 8));
            this.rcmSN = new ExtendedSerialNumber(Arrays.copyOfRange(toParse, offset += 8, offset + 8));
            offset += 8;
        }
        this.seals = SealRecord.parse(Arrays.copyOfRange(toParse, offset, offset + SealRecord.RECORD_SIZE * 5));
        offset += SealRecord.RECORD_SIZE * 5;
        if (toParse.length == V2_RECORD_SIZE) {
            this.loadType = Fonctions.bytesToInt(toParse, offset, 1);
            this.country = Fonctions.bytesToInt(toParse, offset + 1, 1);
            this.countryTimestamp = ConversionTime.getDate(Fonctions.bytesToInt(toParse, offset + 2, 4));
        }
    }

    public static ArrayList<VuCalibration> parse(byte[] tmp, int vuVersion) {
        int start = 0;
        ArrayList<VuCalibration> toReturn = new ArrayList<VuCalibration>();
        while (start < tmp.length) {
            VuCalibration toAdd = new VuCalibration(Arrays.copyOfRange(tmp, start, start + (vuVersion == 1 ? V1_RECORD_SIZE : V2_RECORD_SIZE)));
            TimsLogger.debug("#VuCalibration.parse# calibration purpose : " + toAdd.getPurpose() + ", next calibration : " + ConversionTime.dateToStringFr(toAdd.getNextDate()) + " state : " + toAdd.getVehicleRegistrationIdentification().getNationNumeric() + " country timestamp " + (vuVersion == 2 ? ConversionTime.dateToStringFr(toAdd.getCountryTimestamp()) : "unavailable"));
            toReturn.add(toAdd);
            start += vuVersion == 1 ? V1_RECORD_SIZE : V2_RECORD_SIZE;
        }
        return toReturn;
    }
}

