/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.uev.object.FullCardNumberAndGeneration;
import transpo.system.util.Fonctions;

public class VuTimeAdjustement {
    public static final int RECORD_SIZE = 99;
    private Date oldDate = null;
    private Date newDate = null;
    private String name = null;
    private String address = null;
    private FullCardNumberAndGeneration card = null;

    public Date getOldDate() {
        return this.oldDate;
    }

    public void setOldDate(Date oldDate) {
        this.oldDate = oldDate;
    }

    public Date getNewDate() {
        return this.newDate;
    }

    public void setNewDate(Date newDate) {
        this.newDate = newDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public FullCardNumberAndGeneration getCard() {
        return this.card;
    }

    public void setCard(FullCardNumberAndGeneration card) {
        this.card = card;
    }

    public VuTimeAdjustement(byte[] toParse) {
        this.oldDate = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 0, 4));
        this.newDate = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 4, 4));
        this.name = Fonctions.getStringFromBuffer(toParse, 8, 36, 1);
        this.address = Fonctions.getStringFromBuffer(toParse, 44, 36, 1);
        this.card = new FullCardNumberAndGeneration(Arrays.copyOfRange(toParse, 80, 99));
    }

    public static ArrayList<VuTimeAdjustement> parse(byte[] toParse) {
        int start = 0;
        ArrayList<VuTimeAdjustement> toReturn = new ArrayList<VuTimeAdjustement>();
        while (start < toParse.length) {
            VuTimeAdjustement toAdd = new VuTimeAdjustement(Arrays.copyOfRange(toParse, start, start + 99));
            toReturn.add(toAdd);
            start += 99;
        }
        return toReturn;
    }
}

