/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ProgressBarIndetermine
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JProgressBar barreProgression = null;
    private String message = null;

    public ProgressBarIndetermine(Frame owner, String title) {
        super(owner);
        this.initialize(title, LanguageTranslator.getString("generics.inProgress"));
    }

    public ProgressBarIndetermine(Frame owner, String title, String message) {
        super(owner);
        this.initialize(title, message);
    }

    private void initialize(String title, String message) {
        this.message = message;
        this.setSize(300, 150);
        this.setTitle(title);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getBarreProgression(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    public JProgressBar getBarreProgression() {
        if (this.barreProgression == null) {
            this.barreProgression = new JProgressBar();
            this.barreProgression.setIndeterminate(true);
            this.barreProgression.setStringPainted(true);
            this.barreProgression.setPreferredSize(new Dimension(200, 30));
            this.barreProgression.setString(this.message);
        }
        return this.barreProgression;
    }

    public void setString(String status) {
        this.message = status;
        this.barreProgression.setString(status);
    }
}

