/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.RoundAffectation;
import fr.pgh.data.bdd.RoundType;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import transpo.system.TimsLogger;
import transpo.system.listener.RoundTabListener;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ModelRoundTab
implements TableModel {
    Vector<RoundAffectation> datas = null;
    Vector<RoundType> roundType = null;
    Vector<RoundAffectation> selected = null;
    LinkedHashMap<Date, HashMap<String, Integer>> hashDate = new LinkedHashMap();
    Vector<Date> date = new Vector();
    private final EventListenerList listeners = new EventListenerList();
    private String[] columnName = new String[]{LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("round.count"), LanguageTranslator.getString("round.beginTimeLate"), LanguageTranslator.getString("round.beginTimeEarly"), LanguageTranslator.getString("round.highLoadTime"), LanguageTranslator.getString("round.highTotalTime"), LanguageTranslator.getString("round.highUnloadTime"), LanguageTranslator.getString("round.endLate")};

    public void setData(Vector<RoundAffectation> datas, Date begin, Date end) {
        TimsLogger.verbose("#ModelRoundTab.setData# on red\u00e9fini " + datas.size() + " tourn\u00e9es");
        this.datas = datas;
        this.roundType = RoundType.loadListById(this.getRoundTypeIdList());
        this.date.clear();
        this.hashDate.clear();
        int x = 0;
        Date tmp = new Date(begin.getTime());
        while (tmp.compareTo(end) <= 0) {
            HashMap<String, Integer> toFill = new HashMap<String, Integer>();
            int totalCount = 0;
            int earlyCount = 0;
            int laterCount = 0;
            int unloadCount = 0;
            int unloadTimeAverage = 0;
            int loadCount = 0;
            int loadTimeAverage = 0;
            int highTotalCount = 0;
            int totalAverage = 0;
            int endCount = 0;
            int endAverage = 0;
            while (x <= datas.size()) {
                if (x == datas.size() || datas.get(x).getRoundDate().compareTo(tmp) > 0) {
                    toFill.put(LanguageTranslator.getString("round.count"), totalCount);
                    toFill.put(LanguageTranslator.getString("round.beginTimeLate"), laterCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.beginTimeLate")) + "_COUNT", laterCount);
                    toFill.put(LanguageTranslator.getString("round.beginTimeEarly"), earlyCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.beginTimeEarly")) + "_COUNT", earlyCount);
                    toFill.put(LanguageTranslator.getString("round.highLoadTime"), loadCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.highLoadTime")) + "_AVG", loadCount == 0 ? 0 : loadTimeAverage / loadCount);
                    toFill.put(LanguageTranslator.getString("round.highUnloadTime"), unloadCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.highUnloadTime")) + "_AVG", unloadCount == 0 ? 0 : unloadTimeAverage / unloadCount);
                    toFill.put(LanguageTranslator.getString("round.highTotalTime"), highTotalCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.highTotalTime")) + "_AVG", highTotalCount == 0 ? 0 : totalAverage / highTotalCount);
                    toFill.put(LanguageTranslator.getString("round.endLate"), endCount);
                    toFill.put(String.valueOf(LanguageTranslator.getString("round.endLate")) + "_AVG", endCount == 0 ? 0 : endAverage / endCount);
                    this.hashDate.put(tmp, toFill);
                    this.date.add(tmp);
                    break;
                }
                RoundAffectation ra = datas.get(x);
                if (ra.isDone()) {
                    ++totalCount;
                    RoundType rt = RoundType.getRoundType(this.roundType, ra.getRoundId());
                    if (ra.getBeginTime() > rt.getBeginTime() + 15) {
                        ++laterCount;
                    }
                    if (ra.getBeginTime() < rt.getBeginTime() - 15) {
                        ++earlyCount;
                    }
                    if (ra.getLoadTime() > rt.getLoadTime() + 15) {
                        loadTimeAverage += ra.getLoadTime() - rt.getLoadTime();
                        ++loadCount;
                    }
                    if (ra.getTotalTime() > rt.getTotalTime()) {
                        totalAverage += ra.getTotalTime() - rt.getTotalTime();
                        ++highTotalCount;
                    }
                    if (ra.getUnloadTime() > rt.getUnloadTime()) {
                        unloadTimeAverage += ra.getUnloadTime() - rt.getUnloadTime();
                        ++unloadCount;
                    }
                    if (ra.getReturnTime() + ra.getUnloadTime() > rt.getReturnTime() + rt.getUnloadTime()) {
                        endAverage += ra.getReturnTime() + ra.getUnloadTime() - (rt.getReturnTime() + rt.getUnloadTime());
                        ++endCount;
                    }
                }
                ++x;
            }
            tmp = ConversionTime.addDay(tmp, 1);
        }
        this.fireDataChanged();
    }

    private Vector<Integer> getRoundTypeIdList() {
        Vector<Integer> list = new Vector<Integer>();
        for (RoundAffectation ra : this.datas) {
            if (list.contains(ra.getRoundId())) continue;
            list.add(ra.getRoundId());
        }
        return list;
    }

    public void selectionFilters(Vector<Date> days, Vector<Integer> roundTypeId, Vector<Integer> driverId, Vector<Integer> vehicleId) {
        this.selected = new Vector();
        if (this.datas == null) {
            return;
        }
        for (RoundAffectation tmp : this.datas) {
            if (!days.contains(tmp.getRoundDate()) || roundTypeId != null && !roundTypeId.contains(tmp.getRoundId()) || driverId != null && !driverId.contains(tmp.getDriverId()) || vehicleId != null && !vehicleId.contains(tmp.getVehicleId())) continue;
            this.selected.add(tmp);
        }
        TimsLogger.verbose("#ModelRoundTab.selectionFilters# on a " + this.selected.size() + " s\u00e9lections sur " + this.datas.size() + " tourn\u00e9es");
        this.fireSelectionChanged();
    }

    @Override
    public int getRowCount() {
        return this.date.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnName.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnName[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Date tmp = this.date.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return tmp;
            }
        }
        HashMap<String, Integer> res = this.hashDate.get(tmp);
        if (res == null) {
            return LanguageTranslator.getString("generics.unk");
        }
        return res.get(this.getColumnName(columnIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    protected void fireDataChanged() {
        RoundTabListener[] roundTabListenerArray = (RoundTabListener[])this.listeners.getListeners(RoundTabListener.class);
        int n = roundTabListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoundTabListener listener = roundTabListenerArray[n2];
            listener.dataChanged(this.datas);
            ++n2;
        }
        this.fireTableChanged();
    }

    protected void fireSelectionChanged() {
        RoundTabListener[] roundTabListenerArray = (RoundTabListener[])this.listeners.getListeners(RoundTabListener.class);
        int n = roundTabListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoundTabListener listener = roundTabListenerArray[n2];
            listener.selectionChanged(this.selected);
            ++n2;
        }
    }

    protected void fireTableChanged() {
        TableModelListener[] tableModelListenerArray = (TableModelListener[])this.listeners.getListeners(TableModelListener.class);
        int n = tableModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableModelListener listener = tableModelListenerArray[n2];
            listener.tableChanged(new TableModelEvent(this));
            ++n2;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(TableModelListener.class, l);
    }

    public void addDataListener(RoundTabListener listener) {
        this.listeners.add(RoundTabListener.class, listener);
    }
}

