/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CardDownload;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMCardFile
extends AbstractTableModel {
    private ArrayList<CardDownload> data;
    private String[] titres = new String[]{LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("download.date"), LanguageTranslator.getString("download.fileName")};

    public TMCardFile(ArrayList<CardDownload> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    public CardDownload getCardDownloadAt(int line) {
        return this.data.get(line);
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        CardDownload tmp = this.data.get(parm1);
        String retour = "";
        switch (parm2) {
            case 0: {
                retour = String.valueOf(tmp.getDriver().getNom()) + " " + tmp.getDriver().getPrenom();
                break;
            }
            case 1: {
                retour = ConversionTime.dateFromBDDToFrance(tmp.getTelechargement(), true, false);
                break;
            }
            case 2: {
                retour = tmp.getFichier();
            }
        }
        return retour;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }
}

