/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.CompanyWarningActivation;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMCompanyAlert
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.name"), LanguageTranslator.getString("parameters.enable"), LanguageTranslator.getString("generics.frequency"), LanguageTranslator.getString("warning.executionDay")};
    private ArrayList<AutomaticWarning> data = null;
    private ArrayList<CompanyWarningActivation> activation = new ArrayList();

    public TMCompanyAlert(ArrayList<AutomaticWarning> data) {
        this.data = data;
    }

    public void setActivation(ArrayList<CompanyWarningActivation> activation) {
        this.activation = activation;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        AutomaticWarning tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return LanguageTranslator.getString(tmp.getName());
            }
            case 1: {
                if (this.activation == null) {
                    return false;
                }
                for (CompanyWarningActivation tmpC : this.activation) {
                    if (tmp.getId() != tmpC.getAutoWarningId()) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return AutomaticWarning.getFrequencyWording(tmp.getFrequency());
            }
            case 3: {
                return tmp.getExecutionDate();
            }
        }
        String retour = LanguageTranslator.getString("generics.notFound");
        return retour;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        AutomaticWarning tmp = this.data.get(row);
        switch (col) {
            case 1: {
                if ("true".equals(value.toString())) {
                    this.activation.add(new CompanyWarningActivation(0, tmp.getId(), 0));
                    break;
                }
                int x = 0;
                while (x < this.activation.size()) {
                    CompanyWarningActivation tmpC = this.activation.get(x);
                    if (tmp.getId() == tmpC.getAutoWarningId()) {
                        if (tmpC.getId() != 0) {
                            tmpC.delete();
                        }
                        this.activation.remove(x);
                    }
                    ++x;
                }
                break;
            }
            case 2: {
                TimsLogger.verbose(value.toString());
                tmp.compareAndUpdate(tmp.getName(), tmp.getCalculationClass(), AutomaticWarning.getFrequencyWording(value.toString()), tmp.getExecutionDate());
                break;
            }
            case 3: {
                TimsLogger.verbose(value.toString());
                tmp.compareAndUpdate(tmp.getName(), tmp.getCalculationClass(), tmp.getFrequency(), Integer.parseInt(value.toString()));
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public ArrayList<CompanyWarningActivation> getActivation() {
        return this.activation;
    }
}

