/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.Configuration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMConfiguration
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("parameters.key"), LanguageTranslator.getString("parameters.value")};
    private Vector<Configuration> data = null;

    public TMConfiguration(Vector<Configuration> donnees) {
        this.data = donnees;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Configuration tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getValue();
            }
            case 1: {
                return tmp.getEval();
            }
        }
        String retour = LanguageTranslator.getString("generics.notFound");
        return retour;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Configuration tmp = this.data.get(row);
        switch (col) {
            case 1: {
                if (value == null || value.toString().equals("")) {
                    return;
                }
                if (tmp.getEval().equals(value.toString())) break;
                tmp.setEval(value.toString());
                tmp.update();
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public Vector<Configuration> getTable() {
        return this.data;
    }
}

