/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.FuelConsumption;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMConsumption
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.length"), LanguageTranslator.getString("generics.kmDone"), LanguageTranslator.getString("generics.liters"), LanguageTranslator.getString("generics.consumption")};
    private Vector<FuelConsumption> data = null;

    public TMConsumption(Vector<FuelConsumption> data, TableModelListener listener) {
        this.addTableModelListener(listener);
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<FuelConsumption> getData() {
        return this.data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.data == null && this.data.size() == 0) {
            return null;
        }
        FuelConsumption tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy HH'h'mm");
            }
            case 1: {
                return ConversionTime.heureIntToString(tmp.getLength(), "h");
            }
            case 2: {
                return Float.valueOf(tmp.getKm());
            }
            case 3: {
                return Float.valueOf(tmp.getLiters());
            }
            case 4: {
                return Float.valueOf(tmp.getConsumption());
            }
        }
        LanguageTranslator.getString("generics.unknown");
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? null : this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public FuelConsumption getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

