/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMDriverCardExpiration
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.agency"), LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("generics.cardExpiration")};
    private Vector<Conducteur> data = null;

    public TMDriverCardExpiration(Vector<Conducteur> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<Conducteur> getData() {
        return this.data;
    }

    public Conducteur getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Conducteur tmp = this.data.get(row);
        Object toReturn = null;
        switch (col) {
            case 0: {
                Agence agency = Agence.find(Agence.getList(), tmp.getCleAgence());
                return agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription();
            }
            case 1: {
                return String.valueOf(tmp.getNom()) + " " + tmp.getPrenom();
            }
            case 2: {
                return ConversionTime.stringToDate2(tmp.getDateFinValiditeCarte(), "yyyy-MM-dd");
            }
        }
        return toReturn;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        Conducteur tmp = this.data.get(row);
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                tmp.setFimoFco((String)value);
                break;
            }
            case 3: {
                tmp.setDateFinValiditeCarte((String)value);
                break;
            }
            case 5: {
                tmp.setDateVisite((String)value);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }
}

