/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverDayAnomaly;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.ProcessType;

public class TMDriverDayAnomalies
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = null;
    private ArrayList<DriverDayAnomaly> data = null;

    public TMDriverDayAnomalies(ArrayList<DriverDayAnomaly> data) {
        this.data = data;
    }

    public void setData(ArrayList<DriverDayAnomaly> data) {
        this.data = null;
        this.data = data;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.getColumnNames()[col];
    }

    public ArrayList<DriverDayAnomaly> getData() {
        return this.data;
    }

    public DriverDayAnomaly getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        DriverDayAnomaly tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return Conducteur.getDriverLibelle(tmp.getDriverId());
            }
            case 1: {
                return ConversionTime.dateToStringFr(tmp.getAnomalyDay());
            }
            case 2: {
                return ConversionTime.heureIntToString(tmp.getOverrun(), "h");
            }
            case 3: {
                return new Boolean(tmp.getProcess().equals((Object)ProcessType.ERASE));
            }
            case 4: {
                return tmp.getProcess().equals((Object)ProcessType.MERGE);
            }
            case 5: {
                return tmp.getProcess().equals((Object)ProcessType.IGNORE);
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 3;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        DriverDayAnomaly tmp = this.data.get(row);
        switch (col) {
            case 3: {
                tmp.setProcess(ProcessType.ERASE);
                break;
            }
            case 4: {
                tmp.setProcess(ProcessType.MERGE);
                break;
            }
            case 5: {
                tmp.setProcess(ProcessType.IGNORE);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    private String[] getColumnNames() {
        if (this.columnNames == null) {
            ProcessType[] types = ProcessType.values();
            this.columnNames = new String[3 + types.length];
            int idx = 0;
            this.columnNames[idx] = LanguageTranslator.getString("generics.driver");
            this.columnNames[++idx] = LanguageTranslator.getString("generics.date");
            this.columnNames[++idx] = LanguageTranslator.getString("import.activity.overrun");
            ++idx;
            ProcessType[] processTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessType type = processTypeArray[n2];
                this.columnNames[idx] = type.getText();
                ++idx;
                ++n2;
            }
        }
        return this.columnNames;
    }
}

