/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMDriverOffence
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ArrayList<Offence> donnees;
    String[] titres = new String[]{LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("offence.time"), LanguageTranslator.getString("generics.designation"), LanguageTranslator.getString("offence.autorisedThreshold"), LanguageTranslator.getString("offence.threshold"), LanguageTranslator.getString("offence.type"), LanguageTranslator.getString("offence.maxCost")};

    public TMDriverOffence(ArrayList<Offence> donnees) {
        this.donnees = donnees;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        Offence donnee = this.donnees.get(parm1);
        OffencePart part = null;
        OffenceType type = null;
        switch (parm2) {
            case 0: {
                return ConversionTime.dateToString(donnee.getDate(), "dd/MM/yyyy");
            }
            case 1: {
                return ConversionTime.heureIntToString(donnee.getTime(), "h");
            }
            case 2: {
                return donnee.getDesignation();
            }
            case 3: {
                part = OffencePart.getOffencePart(donnee.getOffencePartId());
                type = OffenceType.getOffenceType(part.getOffenceTypeId());
                if (type == null) {
                    return LanguageTranslator.getString("generics.unknown");
                }
                String sThreshold = "offence.threshold.minor";
                if (type.getName().equals("offence.type.weeklyWork")) {
                    sThreshold = "offence.threshold";
                    try {
                        Conducteur detailConducteur = Conducteur.getDriver(null, donnee.getDriverId());
                        int driverType = detailConducteur.getCleTypeConducteur();
                        sThreshold = String.valueOf(sThreshold) + (driverType == 1 ? ".GR" : (driverType == 2 ? ".ZC" : ".ME"));
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("Driver not found " + donnee.getDriverId());
                    }
                }
                if (type.getName().equals("offence.type.manualInput")) {
                    sThreshold = "offence.threshold";
                }
                int threshold = Fonctions.getOffenceThreshold(type, part.getName(), sThreshold).getThreshold();
                return ConversionTime.heureIntToString(threshold, "h");
            }
            case 4: {
                return ConversionTime.heureIntToString(donnee.getThreshold(), "h");
            }
            case 5: {
                return Fonctions.getTypeWording(donnee.getType());
            }
            case 6: {
                return String.valueOf(donnee.getCost()) + " \u20ac";
            }
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    public ArrayList<Offence> getData() {
        return this.donnees;
    }

    @Override
    public int getRowCount() {
        return this.donnees.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

