/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class TMDynamicReport
extends AbstractTableModel {
    protected Vector<CustomReportColumn> column = null;
    protected ArrayList<Map<String, ?>> data = null;
    protected CustomReport report = null;

    public TMDynamicReport(CustomReport report, Vector<CustomReportColumn> column, ArrayList<Map<String, ?>> data) {
        this.report = report;
        this.column = column;
        this.data = data;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.column.get(columnIndex).getVisibleName();
    }

    @Override
    public int getColumnCount() {
        return this.column.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CustomReportColumn col = this.column.get(columnIndex);
        Object value = this.data.get(rowIndex).get(col.getName());
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            if ("time".equals(col.getExpression())) {
                return this.report.getTimeConverter().format(value != null ? (Integer)value : 0);
            }
            return value;
        }
        if (value instanceof Date) {
            return ConversionTime.dateToString((Date)value, col.getExpression());
        }
        return value;
    }

    public Vector<CustomReportColumn> getColumn() {
        return this.column;
    }

    public void removeColumn(int columnIndex) {
        this.column.remove(columnIndex);
        this.fireTableStructureChanged();
    }

    public CustomReportColumn getColumnAt(int vColIndex) {
        return this.column.get(vColIndex);
    }
}

