/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ExpensesAmount;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMExpensesAmount
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.enactment"), LanguageTranslator.getString("expenses.frenchRate"), LanguageTranslator.getString("expenses.foreignRate")};
    private ArrayList<ExpensesAmount> data = null;

    public TMExpensesAmount(ArrayList<ExpensesAmount> data, TableModelListener listener) {
        this.data = data == null ? new ArrayList() : data;
        this.addTableModelListener(listener);
    }

    public void setData(ArrayList<ExpensesAmount> data) {
        this.data = data;
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public ArrayList<ExpensesAmount> getData() {
        return this.data;
    }

    public ExpensesAmount getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        ExpensesAmount tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return ConversionTime.dateToStringFr(tmp.getEnacted());
            }
            case 1: {
                return Float.valueOf(tmp.getFrenchAmount());
            }
            case 2: {
                return Float.valueOf(tmp.getForeignAmount());
            }
        }
        return "?";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        ExpensesAmount tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setEnacted(ConversionTime.stringToDateFr(value.toString()));
                break;
            }
            case 1: {
                tmp.setFrenchAmount(Float.valueOf(value.toString().replace(",", ".")).floatValue());
                break;
            }
            case 2: {
                tmp.setForeignAmount(Float.valueOf(value.toString().replace(",", ".")).floatValue());
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(ExpensesAmount tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, ExpensesAmount tmp) {
        this.data.add(row, tmp);
        this.fireTableRowsInserted(row, row);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }

    public ExpensesAmount removeRow(int row) {
        ExpensesAmount tmp = this.data.get(row);
        this.data.remove(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }
}

