/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.TypeActivite;
import java.awt.Color;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.ModificationLevelType;

public class TMFullActivityType
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.designation"), LanguageTranslator.getString("generics.code"), LanguageTranslator.getString("generics.color"), LanguageTranslator.getString("activity.percentage"), LanguageTranslator.getString("dayType.HSGenerator"), LanguageTranslator.getString("dayType.RCGenerator"), LanguageTranslator.getString("generics.rest"), LanguageTranslator.getString("activity.modificationLevel")};
    private Vector<TypeActivite> data = null;

    public TMFullActivityType(Vector<TypeActivite> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<TypeActivite> getData() {
        return this.data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TypeActivite tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getName();
            }
            case 1: {
                return tmp.getCode();
            }
            case 2: {
                return new Color(tmp.getColor());
            }
            case 3: {
                return tmp.getPaidPercentage();
            }
            case 4: {
                return tmp.isHsGenerator();
            }
            case 5: {
                return tmp.isRcGenerator();
            }
            case 6: {
                return tmp.isRest();
            }
            case 7: {
                return this.getModificationLevelWording(tmp.getModificationLevel());
            }
        }
        return "?";
    }

    private String getModificationLevelWording(int type) {
        if (type == 0) {
            return LanguageTranslator.getString("activity.noUpdate");
        }
        if (type == 1) {
            return LanguageTranslator.getString("activity.updateWithComment");
        }
        if (type == 2) {
            return LanguageTranslator.getString("activity.allUpdate");
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        TypeActivite tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setName(value.toString());
                break;
            }
            case 1: {
                tmp.setCode(value.toString());
                break;
            }
            case 2: {
                tmp.setColor(((Color)value).getRGB());
                break;
            }
            case 3: {
                if (Integer.parseInt(value.toString()) == 0) {
                    tmp.setHsGenerator(false);
                }
                tmp.setPaidPercentage(Integer.parseInt(value.toString()));
                break;
            }
            case 4: {
                if (value.toString().equals("true")) {
                    tmp.setPaidPercentage(100);
                }
                tmp.setHsGenerator(new Boolean(value.toString()));
                break;
            }
            case 5: {
                tmp.setRcGenerator(new Boolean(value.toString()));
                break;
            }
            case 6: {
                tmp.setRest(new Boolean(value.toString()));
                break;
            }
            case 7: {
                tmp.setModificationLevel(((ModificationLevelType)value).getIndex());
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void addRow(TypeActivite tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, TypeActivite tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public TypeActivite removeRow(int row) {
        TypeActivite tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }

    public TypeActivite getRow(int row) {
        return this.data.get(row);
    }
}

