/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMInterventionState
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Vector<Vehicule> rows = null;
    private Vector<InterventionType> columns = null;
    private Vector<Intervention> datas = null;

    public TMInterventionState(Vector<Vehicule> rows, Vector<InterventionType> columns, Vector<Intervention> datas) {
        this.rows = rows;
        this.columns = columns;
        this.datas = datas;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size() * 3 + 2;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return LanguageTranslator.getString("generics.agency");
        }
        if (col == 1) {
            return LanguageTranslator.getString("generics.vehicle");
        }
        int interventionId = (col - 2) / 3;
        int threshold = (col - 2) % 3;
        String columnName = this.columns.get(interventionId).getName();
        switch (threshold) {
            case 1: {
                columnName = String.valueOf(columnName) + "_COLOR";
                break;
            }
            case 2: {
                columnName = String.valueOf(columnName) + "_ID";
            }
        }
        return columnName;
    }

    public Vehicule getRow(int row) {
        return this.rows.get(row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        int vehicleId = this.rows.get(row).getCleVehicule();
        if (col == 0) {
            Agence agency = Agence.find(Agence.getList(), this.rows.get(row).getAgencyId());
            return agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription();
        }
        if (col == 1) {
            return this.rows.get(row).toString();
        }
        int intervId = this.columns.get((col - 2) / 3).getId();
        int threshold = (col - 2) % 3;
        block7: for (Intervention toCheck : this.datas) {
            if (toCheck.getVehicleId() != vehicleId || toCheck.getTypeId() != intervId) continue;
            try {
                switch (threshold) {
                    case 0: {
                        return toCheck.getDay();
                    }
                    case 1: {
                        int errorThreshold;
                        int warnThreshold;
                        Color background = null;
                        Date dayOfValue = toCheck.getDay();
                        int nbJour = ConversionTime.getDaysBetween(new Date(), dayOfValue);
                        if (toCheck.getState() == 1) {
                            background = nbJour > 0 ? MainFrameTransport.BG_PASTEL_BLUE : MainFrameTransport.BG_PASTEL_RED;
                        } else {
                            warnThreshold = Integer.parseInt(System.getProperty("intervention_warning", "60"));
                            errorThreshold = Integer.parseInt(System.getProperty("intervention_error", "10"));
                            background = nbJour <= errorThreshold ? MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT : (nbJour <= warnThreshold ? MainFrameTransport.BG_COLOR_ALERTE_DEFAULT : MainFrameTransport.BG_COLOR_OK_DEFAULT);
                        }
                        return background;
                    }
                    case 2: {
                        int errorThreshold;
                        int warnThreshold;
                        Color background;
                        Date dayOfValue = toCheck.getDay();
                        int nbJour = ConversionTime.getDaysBetween(new Date(), dayOfValue);
                        if (toCheck.getState() == 1) {
                            background = nbJour > 0 ? MainFrameTransport.BG_PASTEL_BLUE : MainFrameTransport.BG_PASTEL_RED;
                        } else {
                            warnThreshold = Integer.parseInt(System.getProperty("intervention_warning", "60"));
                            errorThreshold = Integer.parseInt(System.getProperty("intervention_error", "10"));
                            background = nbJour <= errorThreshold ? MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT : (nbJour <= warnThreshold ? MainFrameTransport.BG_COLOR_ALERTE_DEFAULT : MainFrameTransport.BG_COLOR_OK_DEFAULT);
                        }
                        if (MainFrameTransport.BG_COLOR_OK_DEFAULT.equals(background)) {
                            return 1;
                        }
                        if (MainFrameTransport.BG_COLOR_ALERTE_DEFAULT.equals(background)) {
                            return 2;
                        }
                        if (MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT.equals(background)) {
                            return 3;
                        }
                        if (MainFrameTransport.BG_PASTEL_RED.equals(background)) {
                            return 4;
                        }
                        if (!MainFrameTransport.BG_PASTEL_BLUE.equals(background)) continue block7;
                        return 5;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        this.datas.add((Intervention)value);
        this.fireTableCellUpdated(row, col);
    }
}

