/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.exception.DBObjectNotFoundException;
import java.awt.Color;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMObligationState
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Vector<Conducteur> rows = null;
    private Vector<EmployeeObligationType> columns = null;
    private Vector<EmployeeObligation> datas = null;

    public TMObligationState(Vector<Conducteur> rows, Vector<EmployeeObligationType> columns, Vector<EmployeeObligation> datas) {
        this.rows = rows;
        this.columns = columns;
        this.datas = datas;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size() * 3 + 2;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return LanguageTranslator.getString("generics.agency");
        }
        if (col == 1) {
            return LanguageTranslator.getString("generics.driver");
        }
        int obligationId = (col - 2) / 3;
        int threshold = (col - 2) % 3;
        String columnName = this.columns.get(obligationId).getName();
        switch (threshold) {
            case 1: {
                columnName = String.valueOf(columnName) + "_COLOR";
                break;
            }
            case 2: {
                columnName = String.valueOf(columnName) + "_ID";
            }
        }
        return columnName;
    }

    public Conducteur getRow(int row) {
        return this.rows.get(row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        int driverId = this.rows.get(row).getCleConducteur();
        if (col == 0) {
            Agence agency = Agence.find(Agence.getList(), this.rows.get(row).getCleAgence());
            return agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription();
        }
        if (col == 1) {
            return this.rows.get(row).toString();
        }
        int obligationId = this.columns.get((col - 2) / 3).getId();
        int threshold = (col - 2) % 3;
        block7: for (EmployeeObligation toCheck : this.datas) {
            if (toCheck.getDriverId() != driverId || toCheck.getTypeId() != obligationId) continue;
            try {
                switch (threshold) {
                    case 0: {
                        return toCheck.getDay();
                    }
                    case 1: {
                        int errorThreshold;
                        int warnThreshold;
                        Color background = null;
                        Date dayOfValue = toCheck.getDay();
                        int nbJour = ConversionTime.getDaysBetween(new Date(), dayOfValue);
                        if (toCheck.getState() == 1) {
                            background = nbJour > 0 ? MainFrameTransport.BG_PASTEL_BLUE : MainFrameTransport.BG_PASTEL_RED;
                        } else {
                            warnThreshold = EmployeeObligationType.getObligationType(obligationId).getWarningThreshold();
                            errorThreshold = EmployeeObligationType.getObligationType(obligationId).getErrorThreshold();
                            background = nbJour <= errorThreshold ? MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT : (nbJour <= warnThreshold ? MainFrameTransport.BG_COLOR_ALERTE_DEFAULT : MainFrameTransport.BG_COLOR_OK_DEFAULT);
                        }
                        return background;
                    }
                    case 2: {
                        int errorThreshold;
                        int warnThreshold;
                        Color background;
                        Date dayOfValue = toCheck.getDay();
                        int nbJour = ConversionTime.getDaysBetween(new Date(), dayOfValue);
                        if (toCheck.getState() == 1) {
                            background = nbJour > 0 ? MainFrameTransport.BG_PASTEL_BLUE : MainFrameTransport.BG_PASTEL_RED;
                        } else {
                            warnThreshold = EmployeeObligationType.getObligationType(obligationId).getWarningThreshold();
                            errorThreshold = EmployeeObligationType.getObligationType(obligationId).getErrorThreshold();
                            background = nbJour <= errorThreshold ? MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT : (nbJour <= warnThreshold ? MainFrameTransport.BG_COLOR_ALERTE_DEFAULT : MainFrameTransport.BG_COLOR_OK_DEFAULT);
                        }
                        if (MainFrameTransport.BG_COLOR_OK_DEFAULT.equals(background)) {
                            return 1;
                        }
                        if (MainFrameTransport.BG_COLOR_ALERTE_DEFAULT.equals(background)) {
                            return 2;
                        }
                        if (MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT.equals(background)) {
                            return 3;
                        }
                        if (MainFrameTransport.BG_PASTEL_RED.equals(background)) {
                            return 4;
                        }
                        if (!MainFrameTransport.BG_PASTEL_BLUE.equals(background)) continue block7;
                        return 5;
                    }
                }
            }
            catch (DBObjectNotFoundException ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        Conducteur tmp = this.rows.get(row);
        EmployeeObligationType obligation = this.columns.get(col);
        switch (col) {
            default: 
        }
        this.fireTableCellUpdated(row, col);
    }
}

