/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.PayPeriod;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMPayPeriod
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<PayPeriod> donnees;
    String[] titres = new String[]{LanguageTranslator.getString("generics.name"), LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end")};

    public TMPayPeriod(Vector<PayPeriod> donnees) {
        this.donnees = donnees;
    }

    public void setData(Vector<PayPeriod> data) {
        this.donnees = data;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        PayPeriod tmp = this.donnees.get(parm1);
        switch (parm2) {
            case 0: {
                return tmp.getName();
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getBegin(), "dd/MM/yyyy");
            }
            case 2: {
                return ConversionTime.dateToString(tmp.getEnd(), "dd/MM/yyyy");
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.donnees.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    public Vector<PayPeriod> getData() {
        return this.donnees;
    }
}

