/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ConsumptionEval;
import fr.pgh.data.bdd.ConsumptionEvalCriteria;
import fr.pgh.data.bdd.ConsumptionMark;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMTargetMark
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    String[] columns = new String[]{LanguageTranslator.getString("consumption.criteria"), LanguageTranslator.getString("consumption.evaluation")};
    private Vector<ConsumptionMark> datas = null;
    private Conducteur currentDriver = null;

    public TMTargetMark(Conducteur currentDriver, Vector<ConsumptionMark> datas) {
        this.currentDriver = currentDriver;
        this.datas = datas;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public int getRowCount() {
        return ConsumptionEvalCriteria.getList().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return ConsumptionEvalCriteria.getList().get(row).getName();
            }
            case 1: {
                ConsumptionMark tmp = this.searchMarkByCriteriaId(ConsumptionEvalCriteria.getList().get(row).getId());
                return tmp == null ? null : this.searchEvalById(tmp.getConsumptionEvalId());
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        TimsLogger.verbose("getColumnClass for column " + columnIndex);
        if (columnIndex == 1) {
            TimsLogger.verbose("return consumption eval for column " + columnIndex);
            return ConsumptionEval.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        ConsumptionEval tmpEval = this.searchEvalByName(value.toString());
        int criteriaId = ConsumptionEvalCriteria.getList().get(row).getId();
        ConsumptionMark tmp = this.searchMarkByCriteriaId(criteriaId);
        if (tmpEval == null) {
            if (tmp != null) {
                this.datas.remove(tmp);
                tmp.delete();
            } else {
                TimsLogger.debug("none to none");
            }
        } else {
            if (tmp == null) {
                tmp = new ConsumptionMark();
                this.datas.add(tmp);
            }
            tmp.compareAndUpdate(this.currentDriver.getCleConducteur(), criteriaId, tmpEval.getId());
        }
        this.fireTableCellUpdated(row, col);
    }

    private ConsumptionMark searchMarkByCriteriaId(int id) {
        for (ConsumptionMark tmp : this.datas) {
            if (tmp.getCriteriaId() != id) continue;
            TimsLogger.debug("returns " + tmp.getId() + " eval = " + tmp.getConsumptionEvalId() + " criteria = " + tmp.getConsumptionEvalId());
            return tmp;
        }
        return null;
    }

    private ConsumptionEval searchEvalByName(String name) {
        if (LanguageTranslator.getString("generics.none").equals(name)) {
            return null;
        }
        for (ConsumptionEval tmp : ConsumptionEval.getList()) {
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    private ConsumptionEval searchEvalById(int id) {
        for (ConsumptionEval tmp : ConsumptionEval.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        return null;
    }
}

