/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.UevDownload;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMUevFile
extends AbstractTableModel {
    private ArrayList<UevDownload> data;
    String[] titres = new String[]{LanguageTranslator.getString("generics.vehicle"), LanguageTranslator.getString("download.date"), LanguageTranslator.getString("download.fileName"), LanguageTranslator.getString("download.activity"), LanguageTranslator.getString("download.previousDownload")};

    public TMUevFile(ArrayList<UevDownload> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        UevDownload tmp = this.data.get(parm1);
        String retour = "";
        switch (parm2) {
            case 0: {
                retour = tmp.getVehicle().getRegistrationNumber();
                break;
            }
            case 1: {
                retour = ConversionTime.dateToString(tmp.getTelechargement(), "dd/MM/yyyy HH'h'mm");
                break;
            }
            case 2: {
                retour = tmp.getFichier();
                break;
            }
            case 3: {
                if (tmp.getBeginActivity() == null || tmp.getBeginActivity() == null) {
                    retour = LanguageTranslator.getString("generics.unknown");
                    break;
                }
                retour = String.valueOf(ConversionTime.dateToString(tmp.getBeginActivity(), "dd/MM/yy")) + " -> " + ConversionTime.dateToString(tmp.getEndActivity(), "dd/MM/yy");
                break;
            }
            case 4: {
                retour = tmp.getPreviousDownload() == null ? LanguageTranslator.getString("generics.unknown") : ConversionTime.dateToString(tmp.getPreviousDownload(), "dd/MM/yyyy HH'h'mm");
            }
        }
        return retour;
    }

    public UevDownload getUevDownloadAt(int line) {
        return this.data.get(line);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }
}

