/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.popup;

import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import transpo.system.ui.JPopupIClicked;
import transpo.system.ui.popup.PopupManager;

public class JPopup
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JPanel jp = null;
    private KeyboardFocusManager kfm = null;
    public static String T_RETURN = "t_return";
    public static String ESCAPE = "escape";
    public static String PACK = "pack";
    public boolean userUpdateValue = true;
    public boolean isTrigger = false;

    public JPopup() {
        this.adapte();
    }

    private void adapte() {
        this.kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.setFocusable(false);
        this.kfm.addPropertyChangeListener("activeWindow", this);
        this.setUndecorated(true);
    }

    public void addComposant(JPanel jp, JPopupIClicked jcpopup) {
        this.jp = jp;
        this.add(jp);
    }

    public void validateDebut() {
        this.jp.addPropertyChangeListener(T_RETURN, this);
        this.jp.addPropertyChangeListener(ESCAPE, this);
        this.jp.addPropertyChangeListener(PACK, this);
    }

    public void openPopup() {
        if (!this.isTrigger) {
            this.isTrigger = true;
            this.userUpdateValue = false;
            this.jp.putClientProperty(ESCAPE, "escape");
            this.jp.putClientProperty(T_RETURN, "t_return");
            this.jp.putClientProperty(PACK, "pack");
            this.userUpdateValue = true;
            this.pack();
            this.setVisible(true);
            PopupManager.getInstance().addPopup(this);
        } else {
            this.isTrigger = false;
        }
    }

    @Override
    public void setVisible(boolean enable) {
        if (enable) {
            this.setRelativeLocation();
        }
        super.setVisible(enable);
    }

    @Override
    public void pack() {
        super.pack();
        this.setRelativeLocation();
    }

    public void setRelativeLocation() {
    }

    private void hidePopup() {
        if (this.isVisible()) {
            this.removeAndDispose();
            this.isTrigger = false;
        }
    }

    private void removeAndDispose() {
        PopupManager.getInstance().removePopup(this);
        this.setTriggerOnDispose();
        this.setVisible(false);
        this.dispose();
        if (PopupManager.getInstance().getList().size() > 0) {
            this.getParent().requestFocus();
        }
    }

    private void setTriggerOnDispose() {
        if (this.getParent().getMousePosition() == null) {
            this.isTrigger = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.userUpdateValue) {
            if (arg0.getPropertyName().equals(T_RETURN)) {
                this.hidePopup();
            } else if (arg0.getPropertyName().equals(ESCAPE)) {
                this.hidePopup();
            } else if (arg0.getPropertyName().equals(PACK)) {
                this.pack();
            }
        }
        if (arg0.getPropertyName().equals("activeWindow")) {
            Object newValue = arg0.getNewValue();
            if (this.isVisible() && newValue != null && !(newValue instanceof JDialog)) {
                int thisRank;
                int popupRank;
                if (newValue.getClass() != this.getClass()) {
                    this.removeAndDispose();
                } else if (newValue != this && (popupRank = PopupManager.getInstance().getPopupRank((JPopup)newValue)) < (thisRank = PopupManager.getInstance().getPopupRank(this)) && PopupManager.getInstance().getList().size() > 0) {
                    int lastPopup = PopupManager.getInstance().getList().size() - 1;
                    JPopup jpp = PopupManager.getInstance().getList().get(lastPopup);
                    jpp.removeAndDispose();
                }
            }
        }
    }

    public void disposePopup() {
        PopupManager.getInstance().removePopup(this);
        if (this.jp != null) {
            this.jp.removePropertyChangeListener(T_RETURN, this);
            this.jp.removePropertyChangeListener(ESCAPE, this);
            this.jp.removePropertyChangeListener(PACK, this);
            this.jp.remove(this);
            this.jp = null;
        }
        if (this.kfm != null) {
            this.kfm.removePropertyChangeListener("activeWindow", this);
            this.kfm = null;
        }
        this.dispose();
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable arg0) {
            arg0.printStackTrace();
        }
    }
}

