/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import fr.pgh.conversion.ConversionTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class DriverTableRenderer
extends DefaultTableCellRenderer {
    Color SEUIL0 = new Color(0xFFFFFF);
    Color SEUIL1 = new Color(0x99CCFF);
    Color SEUIL2 = new Color(0x66CC66);
    Color SEUIL3 = new Color(0xCC3333);

    public DriverTableRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setForeground(new Color(0));
        this.setFont(new Font("Arial", 1, 12));
        Integer val = ConversionTime.heureStringToInt(value.toString().substring(0, 5), "h");
        int spaceIndex = value.toString().lastIndexOf(" ");
        if (val != 0) {
            if (value.toString().length() > 7) {
                this.setFont(new Font("Arial", 1, 9));
                this.setText("<html>" + value.toString().substring(0, spaceIndex) + "<html>");
            } else {
                this.setText("<html>" + value.toString() + "<html>");
            }
        } else if (val == 0) {
            if (value.toString().length() > 5) {
                this.setText(value.toString().substring(9, spaceIndex));
                this.setBackground(new Color(Integer.valueOf(value.toString().substring(spaceIndex + 1))));
            } else {
                this.setText("");
                this.setBackground(this.SEUIL0);
            }
            return this;
        }
        if (col == table.getColumnCount() - 1) {
            int nbJours = table.getColumnCount() - 2;
            if (val <= 360 * nbJours) {
                this.setBackground(this.SEUIL1);
            } else if (360 * nbJours < val && val <= 720 * nbJours) {
                this.setBackground(this.SEUIL2);
            } else if (720 * nbJours < val) {
                this.setBackground(this.SEUIL3);
            }
        } else if (value.toString().length() > 7) {
            this.setBackground(new Color(Integer.valueOf(value.toString().substring(spaceIndex + 1))));
        } else if (val <= 360) {
            this.setBackground(this.SEUIL1);
        } else if (360 < val && val <= 720) {
            this.setBackground(this.SEUIL2);
        } else if (720 < val) {
            this.setBackground(this.SEUIL3);
        }
        return this;
    }

    public static void initialize(JTable table) {
        TableColumn column = null;
        int x = 0;
        while (x < table.getModel().getColumnCount()) {
            column = table.getColumnModel().getColumn(x);
            column.setCellRenderer(new DriverTableRenderer());
            if (x == table.getModel().getColumnCount() - 1) {
                column.setPreferredWidth(55);
            } else {
                column.setPreferredWidth(38);
            }
            ++x;
        }
    }
}

