/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import fr.pgh.data.bdd.DayPlanning;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DayTypeNotFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.TMDriverPlanning;

public class TRDriverPlanning
extends DefaultTableCellRenderer {
    Color SEUIL0 = new Color(0xFFFFFF);
    Color SEUIL1 = new Color(0x99CCFF);
    Color SEUIL2 = new Color(0x66CC66);
    Color SEUIL3 = new Color(0xCC3333);

    public TRDriverPlanning() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setForeground(new Color(0));
        this.setText("");
        this.setBackground(Color.white);
        TMDriverPlanning ptm = (TMDriverPlanning)table.getModel();
        this.setBorder(null);
        int selection = ptm.getSelectionType(row, col);
        if (selection != 0) {
            if (selection == 1) {
                this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.blue));
            }
            if (selection == 2) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.blue));
            }
            if (selection == 3) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.blue));
            }
            if (selection == 4) {
                this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.blue));
            }
        }
        this.setFont(new Font("Arial", 1, 11));
        Vector val = (Vector)value;
        if (val == null || val.size() == 0) {
            return this;
        }
        if (val.size() > 1) {
            TimsLogger.debug("PlanningTableRenderer# more than one row");
        }
        try {
            JourType dayType = JourType.getDayType(((DayPlanning)val.get(0)).getDayTypeId());
            String vehicles = "";
            for (Integer id : ((DayPlanning)val.get(0)).getVehicles()) {
                try {
                    vehicles = String.valueOf(vehicles) + ", " + Vehicule.getVehicule(null, id).getRegistrationNumber();
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#PlanningAgence.loadTable# Vehicle not found");
                }
            }
            this.setText("<html><center><span style=\"font-size:8px;font-weight: bold;\"><strong>" + dayType.getCode() + "<strong></span><br/>" + (vehicles.equals("") ? "" : "<span style=\"font-size:8px\">" + vehicles.substring(2) + "</span>") + "<br/><i>" + ((DayPlanning)val.get(0)).getComm() + "</i></center></html>");
            this.setBackground(new Color(dayType.getColor()));
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#PlanningAgence.loadTable# DayType not found");
        }
        return this;
    }

    public static void initialize(JTable table) {
        TableColumn column = null;
        int x = 0;
        while (x < table.getModel().getColumnCount()) {
            column = table.getColumnModel().getColumn(x);
            column.setCellRenderer(new TRDriverPlanning());
            column.setPreferredWidth(120);
            ++x;
        }
    }
}

