/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class VehicleTableRenderer
extends DefaultTableCellRenderer {
    Color SEUIL0 = new Color(0xFFFFFF);
    Color SEUIL1 = new Color(0x99CCFF);
    Color SEUIL2 = new Color(0x6699FF);
    Color SEUIL3 = new Color(0x66CC66);
    Color SEUIL4 = new Color(0xFFCC33);
    Color SEUIL5 = new Color(0xCC3333);
    Color SEUIL6 = new Color(0xCC3333);

    public VehicleTableRenderer() {
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setForeground(new Color(0));
        this.setFont(new Font("Arial", 1, 12));
        this.setIcon(null);
        this.setToolTipText(null);
        this.setText("");
        this.setBackground(this.SEUIL0);
        if (value instanceof Intervention) {
            try {
                String name = InterventionType.getInterventionType(((Intervention)value).getTypeId()).getName();
                this.setToolTipText(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setToolTipText(LanguageTranslator.getString("generics.unknown"));
            }
            String img = "images/tools_green.png";
            switch (((Intervention)value).getState()) {
                case 2: {
                    img = "images/tools_red.png";
                    break;
                }
                case 1: {
                    img = "images/tools_orange.png";
                    break;
                }
                case 3: {
                    img = "images/tools_blue.png";
                    break;
                }
                case 4: {
                    img = "images/tools_red.png";
                }
            }
            ImageIcon ii = new ImageIcon(this.getClass().getClassLoader().getResource(img));
            Image icon = ii.getImage().getScaledInstance(16, 16, 1);
            this.setIcon(new ImageIcon(icon));
        } else {
            int separatorIndex = value.toString().indexOf("h");
            Integer val = 0;
            if (separatorIndex != -1) {
                val = ConversionTime.heureStringToInt(value.toString().substring(0, separatorIndex + 3), "h");
            }
            if (val == 0) {
                this.setBackground(this.SEUIL0);
            } else {
                this.setText("<html>" + value.toString() + "<html>");
                if (col == table.getColumnCount() - 1) {
                    int nbJours = table.getColumnCount() - 2;
                    if (val < 240 * nbJours) {
                        this.setBackground(this.SEUIL1);
                    } else if (240 * nbJours < val && val <= 480 * nbJours) {
                        this.setBackground(this.SEUIL2);
                    } else if (480 * nbJours < val && val <= 720 * nbJours) {
                        this.setBackground(this.SEUIL3);
                    } else if (720 * nbJours < val && val <= 960 * nbJours) {
                        this.setBackground(this.SEUIL4);
                    } else if (960 * nbJours < val && val <= 1200 * nbJours) {
                        this.setBackground(this.SEUIL5);
                    } else if (1200 * nbJours < val) {
                        this.setBackground(this.SEUIL6);
                    }
                } else if (val < 240) {
                    this.setBackground(this.SEUIL1);
                } else if (240 < val && val <= 480) {
                    this.setBackground(this.SEUIL2);
                } else if (480 < val && val <= 720) {
                    this.setBackground(this.SEUIL3);
                } else if (720 < val && val <= 960) {
                    this.setBackground(this.SEUIL4);
                } else if (960 < val && val <= 1200) {
                    this.setBackground(this.SEUIL5);
                } else if (1200 < val) {
                    this.setBackground(this.SEUIL6);
                }
            }
        }
        return this;
    }

    public static void initialize(JTable table) {
        TableColumn column = null;
        int x = 0;
        while (x < table.getModel().getColumnCount()) {
            column = table.getColumnModel().getColumn(x);
            column.setCellRenderer(new VehicleTableRenderer());
            if (x == table.getModel().getColumnCount() - 1) {
                column.setPreferredWidth(55);
            } else {
                column.setHeaderRenderer(null);
                column.setPreferredWidth(40);
            }
            ++x;
        }
    }
}

