/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import fr.pgh.conversion.ConversionTime;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.ui.MainFrameTransport;

public class WidgetDriverExpirationRenderer
extends JLabel
implements TableCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public WidgetDriverExpirationRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public static void initialize(JTable table) {
        TableColumn column = null;
        int x = 0;
        while (x < table.getModel().getColumnCount()) {
            column = table.getColumnModel().getColumn(x);
            if (x == 0) {
                column.setPreferredWidth(200);
            } else {
                column.setCellRenderer(new WidgetDriverExpirationRenderer(false));
            }
            ++x;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background = null;
        if (column < 1) {
            this.setText(value.toString());
            this.setBackground(Color.white);
            this.setHorizontalAlignment(2);
            return this;
        }
        this.setHorizontalAlignment(0);
        if (value == null) {
            background = MainFrameTransport.BG_COLOR_UNABLE;
            this.setText("");
        } else {
            this.setText(ConversionTime.dateToString((Date)value, "dd/MM/yyyy"));
            int dayDifference = ConversionTime.getDaysBetween(new Date(), (Date)value);
            int firstThreshold = Integer.parseInt(System.getProperty("driver_error", "30"));
            int secondThreshold = Integer.parseInt(System.getProperty("driver_warning", "60"));
            background = dayDifference <= firstThreshold ? MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT : (dayDifference < secondThreshold ? MainFrameTransport.BG_COLOR_ALERTE_DEFAULT : MainFrameTransport.BG_COLOR_OK_DEFAULT);
        }
        if (background == null) {
            return this;
        }
        this.setBackground(background);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }
}

