/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.resources.i18n;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;

public class LanguageTranslator
extends Observable
implements ActionListener {
    private static final String LANGUAGE_FILE = "transpo.system.ui.resources.i18n.strings";
    private static ResourceBundle resourceBundle = null;
    private static Locale currentLocale = null;
    public static final String[] available = new String[]{"fr", "en", "es", "it", "ua", "ru"};
    private static LanguageTranslator single = null;

    public static LanguageTranslator getInstance() {
        if (single == null) {
            single = new LanguageTranslator();
        }
        return single;
    }

    public LanguageTranslator() {
        currentLocale = Locale.getDefault();
        resourceBundle = ResourceBundle.getBundle(LANGUAGE_FILE, currentLocale);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setChanged();
        this.setLocale(event.getActionCommand());
        this.notifyObservers();
        MainFrameTransport.getInstance().reloadLabel();
    }

    public void setLocale(String locale) {
        if (locale.equals("en")) {
            currentLocale = Locale.ENGLISH;
        } else if (locale.equals("it")) {
            currentLocale = Locale.ITALIAN;
        } else if (locale.equals("es")) {
            currentLocale = new Locale("es", "ES");
        } else if (locale.equals("ua")) {
            currentLocale = new Locale("uk", "UA");
        } else if (locale.equals("ru")) {
            currentLocale = new Locale("ru", "RU");
        } else if (locale.equals("fr")) {
            currentLocale = Locale.FRENCH;
        }
        resourceBundle = ResourceBundle.getBundle(LANGUAGE_FILE, currentLocale);
    }

    public static String getString(String key) {
        String toReturn = "";
        try {
            toReturn = resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            TimsLogger.warn("key " + key + " doesn't have an available link", "LanguageTranslator");
            toReturn = "**" + key + "**";
        }
        catch (NullPointerException ex) {
            TimsLogger.warn("key " + key + " generate a NullPointerException", "LanguageTranslator");
            ex.printStackTrace();
            toReturn = "**" + key + "**";
        }
        return toReturn;
    }

    public static String getString(String key, String ... param) {
        String toReturn = "";
        try {
            toReturn = resourceBundle.getString(key);
            if (LanguageTranslator.regexOccur(toReturn, Pattern.quote("%s")) != param.length) {
                TimsLogger.warn("TranslationError " + param.length + " parameters whereas " + LanguageTranslator.regexOccur(toReturn, Pattern.quote("%s")) + " needed on " + key, "LanguageTranslator");
                return "TranslationError " + param.length + " parameters whereas " + LanguageTranslator.regexOccur(toReturn, Pattern.quote("%s")) + " needed on " + key;
            }
            int x = 0;
            while (x < param.length) {
                toReturn = toReturn.replaceFirst("%s", param[x].replace("\\", "\\\\"));
                ++x;
            }
        }
        catch (MissingResourceException ex) {
            TimsLogger.warn("key " + key + " doesn't have an available link", "LanguageTranslator");
            toReturn = "***" + key + "***";
        }
        catch (NullPointerException ex) {
            TimsLogger.warn("key " + key + " generate a NullPointerException", "LanguageTranslator");
            ex.printStackTrace();
            toReturn = "***" + key + "***";
        }
        catch (Exception ex) {
            TimsLogger.warn("unknow error", "LanguageTranslator");
            ex.printStackTrace();
            toReturn = "***" + key + "***";
        }
        return toReturn;
    }

    public static final int regexOccur(String text, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(text);
        int occur = 0;
        while (matcher.find()) {
            ++occur;
        }
        return occur;
    }

    public static Locale getLocale() {
        return currentLocale;
    }
}

