/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.viewable;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import transpo.system.ui.viewable.ProgressView;

public class ProgressViewManager {
    private ProgressView pg = null;
    private int currentValue = 0;
    private String currentText = "";
    private final Runnable progressRunnable;

    public ProgressViewManager(ProgressView pgView) {
        this.pg = pgView;
        this.progressRunnable = new Runnable(){

            @Override
            public void run() {
                ProgressViewManager.this.pg.setValue(ProgressViewManager.this.currentValue);
                ProgressViewManager.this.pg.setText(ProgressViewManager.this.currentText);
            }
        };
    }

    public void setMinimum(int x) {
        this.pg.setMinimum(x);
    }

    public void setMaximum(int x) {
        this.pg.setMaximum(x);
    }

    public void setVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pg.setVisible(visible);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProgressViewManager.this.pg.setVisible(visible);
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setValue(int value) {
        this.currentValue = value;
        this.updateProgressBar();
    }

    public void setText(String text) {
        this.currentText = text;
        this.updateProgressBar();
    }

    public void setValues(int value, String text) {
        this.currentValue = value;
        this.currentText = text;
        this.updateProgressBar();
    }

    protected void updateProgressBar() {
        SwingUtilities.invokeLater(this.progressRunnable);
    }
}

