/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.ui.views.PopupCaller;

public class CommentPopup
extends JPopupMenu {
    JTextField comment = null;
    MouseListener lsl = null;

    public CommentPopup() {
        this.initialize();
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof PopupCaller)) {
            TimsLogger.warn("CommentPopup must be invoked by a class which is implementing PopupCaller (" + invoker.getClass().getName() + " is invoker)");
            return;
        }
        TimsLogger.verbose("CommentPopup");
        super.show(invoker, x, y);
    }

    public void initialize() {
        this.add(this.getComment());
    }

    public JTextField getComment() {
        if (this.comment == null) {
            this.comment = new JTextField();
            this.comment.setPreferredSize(new Dimension(300, 30));
            this.comment.setMinimumSize(new Dimension(300, 30));
            this.comment.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CommentPopup.this.saveAndExit();
                    }
                }
            });
        }
        return this.comment;
    }

    public void setText(String comment) {
        this.getComment().setText(comment);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            ((PopupCaller)((Object)this.getInvoker())).submitPopup();
            this.getComment().removeMouseListener(this.getMouseListener());
        }
        if (visible) {
            this.getComment().addMouseListener(this.getMouseListener());
        }
        super.setVisible(visible);
    }

    public void saveAndExit() {
        this.setVisible(false);
    }

    public MouseListener getMouseListener() {
        if (this.lsl == null) {
            this.lsl = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CommentPopup.this.getComment().setText("");
                    }
                }
            };
        }
        return this.lsl;
    }
}

