/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMDynamicReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.CustomReportColumnPopup;
import transpo.system.ui.views.ProgressBar;
import transpo.system.user.UserPreferences;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transport.report.CustomReportFactory;
import transport.report.DynamicService;
import transport.report.generator.TimeConverterFactory;

public class CustomService
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlFilter = null;
    private JPanel pnlBtn = null;
    private JScrollPane jspTable = null;
    private JTable tblData = null;
    private JComboBox cbAgencies = null;
    private JButton btnGenerer = null;
    private JComboBox cbDrivers = null;
    private JLabel lblAgency = null;
    private JLabel lblDriver = null;
    private JComboBox cbCustomReport = null;
    private JLabel lblCustomReport = null;
    private JCheckBox cbPrint = null;
    private JButton btnSaveReport = null;
    private JButton btnQuit = null;
    private DynamicService dynamicService = null;
    private JPanel pnlDate = null;
    private JLabel lblDu = null;
    private JTextField txtDateDebut = null;
    private JLabel lblAu = null;
    private JTextField txtDateFin = null;
    private JCheckBox cbSemaine = null;
    private JCheckBox cbMois = null;
    private JPanel pnlReport = null;
    private JCheckBox cbMinut = null;
    private JCheckBox cbHundreed = null;
    private JCheckBox cbHS = null;
    private JCheckBox cbWeekTotal = null;
    private CustomReport current = null;
    private boolean isValueAdjusting = false;
    private JPanel pnlContent = null;
    private JTextField txtFooter = null;
    private JLabel lblFooter = null;
    private JComboBox cbTypeExport = null;
    private JLabel lblTypeExport = null;
    private ProgressBar pg = null;

    public CustomService(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(700, 500);
        this.setTitle(LanguageTranslator.getString("report.custom.service"));
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout);
            this.jContentPane.add((Component)this.getPnlFilter(), "North");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
            this.jContentPane.add((Component)this.getPnlContent(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints22.gridy = 2;
            this.lblTypeExport = new JLabel();
            this.lblTypeExport.setText(LanguageTranslator.getString("report.exportType"));
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.fill = 2;
            gridBagConstraints110.gridy = 2;
            gridBagConstraints110.weightx = 0.0;
            gridBagConstraints110.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints110.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 4;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.weighty = 0.0;
            gridBagConstraints15.gridheight = 2;
            gridBagConstraints15.gridy = 2;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 4;
            gridBagConstraints14.gridheight = 2;
            gridBagConstraints14.gridy = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.gridy = 4;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridy = 3;
            this.lblCustomReport = new JLabel();
            this.lblCustomReport.setText(LanguageTranslator.getString("generics.customReport"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            this.lblDriver = new JLabel();
            this.lblDriver.setText(LanguageTranslator.getString("generics.driver"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints2.gridy = 0;
            this.lblAgency = new JLabel();
            this.lblAgency.setText(LanguageTranslator.getString("generics.agency"));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)this.getCbAgencies(), gridBagConstraints);
            this.pnlFilter.add((Component)this.getCbDrivers(), gridBagConstraints1);
            this.pnlFilter.add((Component)this.lblAgency, gridBagConstraints2);
            this.pnlFilter.add((Component)this.lblDriver, gridBagConstraints3);
            this.pnlFilter.add((Component)this.getCbCustomReport(), gridBagConstraints11);
            this.pnlFilter.add((Component)this.lblCustomReport, gridBagConstraints21);
            this.pnlFilter.add((Component)this.getCbPrint(), gridBagConstraints31);
            this.pnlFilter.add((Component)this.getPnlDate(), gridBagConstraints14);
            this.pnlFilter.add((Component)this.getPnlReport(), gridBagConstraints15);
            this.pnlFilter.add((Component)this.getCbTypeExport(), gridBagConstraints110);
            this.pnlFilter.add((Component)this.lblTypeExport, gridBagConstraints22);
        }
        return this.pnlFilter;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(5, 0, 5, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints4.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnGenerer(), gridBagConstraints5);
            this.pnlBtn.add((Component)this.getBtnSaveReport(), gridBagConstraints4);
            this.pnlBtn.add((Component)this.getBtnQuit(), gridBagConstraints6);
        }
        return this.pnlBtn;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
            this.jspTable.setViewportView(this.getTblData());
        }
        return this.jspTable;
    }

    private JTable getTblData() {
        if (this.tblData == null) {
            this.tblData = new JTable();
            this.tblData.setAutoResizeMode(0);
            this.tblData.getTableHeader().addMouseListener(new MouseAdapter(){
                int x = 0;

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (((JTableHeader)evt.getSource()).getResizingColumn() == null) {
                        this.x = evt.getX();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    int vColIndex = this.getColumnIndex(evt);
                    if (vColIndex == -1) {
                        return;
                    }
                    if (SwingUtilities.isRightMouseButton(evt)) {
                        TableColumnModel model = ((JTableHeader)evt.getSource()).getColumnModel();
                        ((JTableHeader)evt.getSource()).getColumnModel().removeColumn(model.getColumn(vColIndex));
                    } else if (SwingUtilities.isLeftMouseButton(evt) && this.x != 0 && this.x - 5 < evt.getX() && evt.getX() < this.x + 5) {
                        int index = CustomService.this.getTblData().getColumnModel().getColumn(vColIndex).getModelIndex();
                        CustomReportColumn toDetail = ((TMDynamicReport)CustomService.this.getTblData().getModel()).getColumnAt(index);
                        CustomReportColumnPopup popup = new CustomReportColumnPopup(toDetail, vColIndex);
                        popup.show((JTableHeader)evt.getSource(), this.getXPopup(evt, toDetail.getVisibleName()), 0);
                    }
                }

                public int getXPopup(MouseEvent evt, Object headerValue) {
                    TimsLogger.verbose("on entre dans getXpopup");
                    JTableHeader th = (JTableHeader)evt.getSource();
                    int x = 0;
                    Enumeration<TableColumn> en = th.getColumnModel().getColumns();
                    while (en.hasMoreElements()) {
                        TableColumn tmp = en.nextElement();
                        if (tmp.getHeaderValue().equals(headerValue)) break;
                        x += tmp.getWidth();
                    }
                    if (x + 240 > th.getWidth()) {
                        x = th.getWidth() - 240;
                    }
                    TimsLogger.verbose("return " + x);
                    return x;
                }

                public int getColumnIndex(MouseEvent evt) {
                    JTable table = ((JTableHeader)evt.getSource()).getTable();
                    TableColumnModel colModel = table.getColumnModel();
                    return colModel.getColumnIndexAtX(evt.getX());
                }
            });
        }
        return this.tblData;
    }

    public DynamicService getDynamicService() {
        if (this.dynamicService == null) {
            this.dynamicService = new DynamicService();
        }
        return this.dynamicService;
    }

    private JComboBox getCbAgencies() {
        if (this.cbAgencies == null) {
            this.cbAgencies = new JComboBox();
            this.cbAgencies.setModel(new ComboBoxModel(Agence.getList(), true, LanguageTranslator.getString("generics.all")));
            this.cbAgencies.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cleAgence = ((ComboBoxModel)CustomService.this.getCbAgencies().getModel()).getSelectedCle();
                    CustomService.this.getCbDrivers().setModel(new ComboBoxModel(Conducteur.loadList(cleAgence), true, LanguageTranslator.getString("generics.all")));
                }
            });
        }
        return this.cbAgencies;
    }

    private JButton getBtnGenerer() {
        if (this.btnGenerer == null) {
            this.btnGenerer = new JButton();
            this.btnGenerer.setText(LanguageTranslator.getString("button.generate"));
            this.btnGenerer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomService.this.getCurrent().updateProperty("FOOTER", CustomService.this.getTxtFooter().getText());
                    CustomService.this.getCurrent().updateProperty("OUT", CustomService.this.getCbTypeExport().getSelectedItem());
                    CustomService.this.generateDynamicReport();
                }
            });
        }
        return this.btnGenerer;
    }

    public void generateDynamicReport() {
        new Thread(){

            @Override
            public void run() {
                CustomService.this.loadParameters();
                if (CustomService.this.getTblData().getModel() != null && CustomService.this.getTblData().getModel() instanceof TMDynamicReport) {
                    CustomService.this.getCurrent().setColumn(CustomService.this.orderColumn(((TMDynamicReport)CustomService.this.getTblData().getModel()).getColumn(), CustomService.this.getTblData()));
                }
                try {
                    CustomService.this.getDynamicService().process();
                }
                catch (Exception ex) {
                    TimsLogger.warn("#CustomService.generateDynamicReport()# error during report process");
                    ex.printStackTrace();
                }
                CustomService.this.pg.dispose();
            }
        }.start();
    }

    private JComboBox getCbDrivers() {
        if (this.cbDrivers == null) {
            this.cbDrivers = new JComboBox();
            this.cbDrivers.setModel(new ComboBoxModel(Conducteur.loadList(0), true, LanguageTranslator.getString("generics.all")));
            this.cbDrivers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.cbDrivers;
    }

    private JComboBox getCbCustomReport() {
        if (this.cbCustomReport == null) {
            this.cbCustomReport = new JComboBox();
            this.cbCustomReport.setModel(new ComboBoxModel(CustomReport.loadList(1), true, LanguageTranslator.getString("button.new")));
            this.cbCustomReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomService.this.current = (CustomReport)((ComboBoxModel)CustomService.this.getCbCustomReport().getModel()).getObjectAt(CustomService.this.getCbCustomReport().getSelectedIndex());
                    if (CustomService.this.current == null) {
                        CustomService.this.current = CustomReportFactory.getDriverServiceDefault();
                    }
                    if (CustomService.this.current.getProperties().get("FOOTER") != null) {
                        CustomService.this.getTxtFooter().setText(CustomService.this.current.getProperties().get("FOOTER").toString());
                    }
                    CustomService.this.isValueAdjusting = true;
                    CustomService.this.getCbMinut().setSelected(CustomService.this.getCurrent().getProperties().get("RESOLUTION") == null || CustomService.this.getCurrent().getProperties().get("RESOLUTION").toString().equals(String.valueOf(1)));
                    CustomService.this.getCbHundreed().setSelected(String.valueOf(0).equals(CustomService.this.getCurrent().getProperties().get("RESOLUTION").toString()));
                    CustomService.this.getCbHS().setSelected("1".equals(CustomService.this.getCurrent().getProperties().get("HS").toString()));
                    CustomService.this.getCbWeekTotal().setSelected("1".equals(CustomService.this.getCurrent().getProperties().get("WEEK_SUBTOTAL").toString()));
                    if (CustomService.this.getCbPrint().isSelected()) {
                        CustomService.this.loadParameters();
                        CustomService.this.getDynamicService().showOverview(CustomService.this.getTblData());
                    }
                    CustomService.this.isValueAdjusting = false;
                }
            });
        }
        return this.cbCustomReport;
    }

    private JCheckBox getCbPrint() {
        if (this.cbPrint == null) {
            this.cbPrint = new JCheckBox();
            this.cbPrint.setText(LanguageTranslator.getString("button.overview"));
            this.cbPrint.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        CustomService.this.loadOverview();
                    } else {
                        CustomService.this.getBtnSaveReport().setEnabled(false);
                    }
                }
            });
        }
        return this.cbPrint;
    }

    private void loadOverview() {
        if (this.getTxtDateDebut().getText().equals("") || this.getTxtDateFin().getText().equals("")) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("generics.emptyDate"), LanguageTranslator.getString("message.inputError"), 2);
            return;
        }
        this.getBtnSaveReport().setEnabled(true);
        this.getCbMinut().setEnabled(true);
        this.getCbHundreed().setEnabled(true);
        this.loadParameters();
        this.getDynamicService().showOverview(this.getTblData());
    }

    private JButton getBtnSaveReport() {
        if (this.btnSaveReport == null) {
            this.btnSaveReport = new JButton();
            this.btnSaveReport.setText(LanguageTranslator.getString("button.save"));
            this.btnSaveReport.setEnabled(false);
            this.btnSaveReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = JOptionPane.showInputDialog(LanguageTranslator.getString("report.custom.name.input"), (Object)CustomService.this.getCurrent().getName());
                    TimsLogger.debug("JOptionPane.showInputDialog " + name);
                    if (name != null) {
                        CustomService.this.getCurrent().setName(name);
                        CustomService.this.getCurrent().updateProperty("FOOTER", CustomService.this.getTxtFooter().getText());
                        CustomService.this.getCurrent().setColumn(CustomService.this.orderColumn(((TMDynamicReport)CustomService.this.getTblData().getModel()).getColumn(), CustomService.this.getTblData()));
                        if (!CustomService.this.getCurrent().update()) {
                            MessageSystemManager.error(null, LanguageTranslator.getString("generics.error"), LanguageTranslator.getString("generics.error"));
                        }
                        CustomService.this.getCbCustomReport().setModel(new ComboBoxModel(CustomReport.loadList(1), true, LanguageTranslator.getString("button.new")));
                        CustomService.this.getCbCustomReport().setSelectedItem(CustomService.this.getCurrent().getName());
                    }
                }
            });
        }
        return this.btnSaveReport;
    }

    private Vector<CustomReportColumn> orderColumn(Vector<CustomReportColumn> toOrder, JTable order) {
        Vector<CustomReportColumn> ordered = new Vector<CustomReportColumn>();
        int x = 0;
        while (x < order.getColumnCount()) {
            int index = order.getColumnModel().getColumn(x).getModelIndex();
            toOrder.get(index).setPosition(x);
            ordered.add(toOrder.get(index));
            TimsLogger.debug("#orderColumn# " + order.getColumnModel().getColumn(x).getHeaderValue() + " => " + index + ". set custom column " + toOrder.get(index).getName() + " at position " + x);
            ++x;
        }
        return ordered;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomService.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    public void loadParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CUSTOM_REPORT", this.getCurrent());
        params.put("AGENCIES", ((ComboBoxModel)this.getCbAgencies().getModel()).getList());
        params.put("DRIVERS", ((ComboBoxModel)this.getCbDrivers().getModel()).getList());
        params.put("BEGIN", ConversionTime.stringToDate(this.getTxtDateDebut().getText(), "dd/MM/yyyy"));
        params.put("END", ConversionTime.stringToDate(this.getTxtDateFin().getText(), "dd/MM/yyyy"));
        params.put("RESOLUTION", "1");
        params.put("DETAIL", true);
        params.put("OUT", this.getCbTypeExport().getSelectedItem());
        Vector<Object> driver = ((ComboBoxModel)this.getCbDrivers().getModel()).getList();
        Vector<Object> agency = ((ComboBoxModel)this.getCbAgencies().getModel()).getList();
        this.pg = new ProgressBar(this, LanguageTranslator.getString("generics.loading"));
        this.pg.setVisible(true);
        this.getDynamicService().setValues(this.pg, null, agency, driver, null, params);
    }

    private JPanel getPnlDate() {
        if (this.pnlDate == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridx = 2;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.gridwidth = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.gridwidth = 2;
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.fill = 2;
            gridBagConstraints111.gridx = 3;
            gridBagConstraints111.gridy = 0;
            gridBagConstraints111.weightx = 2.0;
            gridBagConstraints111.weighty = 1.0;
            gridBagConstraints111.insets = new Insets(0, 0, 0, 5);
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.gridx = 2;
            this.lblAu = new JLabel();
            this.lblAu.setText(LanguageTranslator.getString("generics.to"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 2.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 5);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.gridx = 0;
            this.lblDu = new JLabel();
            this.lblDu.setText(LanguageTranslator.getString("generics.from"));
            this.pnlDate = new JPanel();
            this.pnlDate.setLayout(new GridBagLayout());
            this.pnlDate.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.date"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlDate.add((Component)this.lblDu, gridBagConstraints8);
            this.pnlDate.add((Component)this.getTxtDateDebut(), gridBagConstraints9);
            this.pnlDate.add((Component)this.lblAu, gridBagConstraints10);
            this.pnlDate.add((Component)this.getTxtDateFin(), gridBagConstraints111);
            this.pnlDate.add((Component)this.getCbSemaine(), gridBagConstraints12);
            this.pnlDate.add((Component)this.getCbMois(), gridBagConstraints13);
        }
        return this.pnlDate;
    }

    private JTextField getTxtDateDebut() {
        if (this.txtDateDebut == null) {
            this.txtDateDebut = new JTextField();
            this.txtDateDebut.setEnabled(true);
            this.txtDateDebut.setEditable(false);
            this.txtDateDebut.setMinimumSize(new Dimension(70, 20));
            this.txtDateDebut.setPreferredSize(new Dimension(70, 20));
            this.txtDateDebut.setText(ConversionTime.dateToString(ConversionTime.getFirstDayOfPreviousMonth(null), "dd/MM/yyyy"));
            this.txtDateDebut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(CustomService.this.getTxtDateDebut());
                }
            });
        }
        return this.txtDateDebut;
    }

    private JTextField getTxtDateFin() {
        if (this.txtDateFin == null) {
            this.txtDateFin = new JTextField();
            this.txtDateFin.setEnabled(true);
            this.txtDateFin.setEditable(false);
            this.txtDateFin.setMinimumSize(new Dimension(70, 20));
            this.txtDateFin.setPreferredSize(new Dimension(70, 20));
            this.txtDateFin.setText(ConversionTime.dateToString(ConversionTime.getLastDayOfPreviousMonth(null), "dd/MM/yyyy"));
            this.txtDateFin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(CustomService.this.getTxtDateFin());
                }
            });
        }
        return this.txtDateFin;
    }

    private JCheckBox getCbSemaine() {
        if (this.cbSemaine == null) {
            this.cbSemaine = new JCheckBox(LanguageTranslator.getString("generics.week"));
            this.cbSemaine.setPreferredSize(new Dimension(0, 24));
            this.cbSemaine.setHorizontalAlignment(0);
            this.cbSemaine.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        CustomService.this.cbMois.setSelected(false);
                        CustomService.this.txtDateFin.setText(ConversionTime.addDay(CustomService.this.txtDateDebut.getText(), "dd/MM/yyyy", 6));
                    }
                }
            });
        }
        return this.cbSemaine;
    }

    private JCheckBox getCbMois() {
        if (this.cbMois == null) {
            this.cbMois = new JCheckBox(LanguageTranslator.getString("generics.month"));
            this.cbMois.setPreferredSize(new Dimension(0, 24));
            this.cbMois.setHorizontalAlignment(0);
            this.cbMois.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        CustomService.this.cbSemaine.setSelected(false);
                        String sDateDebut = CustomService.this.txtDateDebut.getText();
                        GregorianCalendar calDateRapport = new GregorianCalendar();
                        calDateRapport.setTime(ConversionTime.stringToDate(sDateDebut, "dd/MM/yyyy"));
                        calDateRapport.add(2, 1);
                        calDateRapport.add(5, -1);
                        CustomService.this.txtDateFin.setText(ConversionTime.dateToString(calDateRapport.getTime(), "dd/MM/yyyy"));
                    }
                }
            });
        }
        return this.cbMois;
    }

    private JPanel getPnlReport() {
        if (this.pnlReport == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            this.pnlReport = new JPanel();
            this.pnlReport.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.detail"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlReport.setLayout(new GridBagLayout());
            this.pnlReport.add((Component)this.getCbMinut(), gridBagConstraints7);
            this.pnlReport.add((Component)this.getCbHundreed(), gridBagConstraints16);
            this.pnlReport.add((Component)this.getCbHS(), gridBagConstraints17);
            this.pnlReport.add((Component)this.getCbWeekTotal(), gridBagConstraints18);
        }
        return this.pnlReport;
    }

    private JCheckBox getCbMinut() {
        if (this.cbMinut == null) {
            this.cbMinut = new JCheckBox();
            this.cbMinut = new JCheckBox(LanguageTranslator.getString("generics.minute"));
            this.cbMinut.setEnabled(false);
            this.cbMinut.setSelected(true);
            this.cbMinut.setHorizontalAlignment(0);
            this.cbMinut.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !CustomService.this.isValueAdjusting) {
                        CustomService.this.getCbHundreed().setSelected(!CustomService.this.getCbMinut().isSelected());
                        CustomService.this.getCurrent().updateProperty("RESOLUTION", String.valueOf(1));
                        CustomService.this.getCurrent().setTimeConverter(TimeConverterFactory.getTimeConverter(1));
                        if (CustomService.this.getCbPrint().isSelected()) {
                            CustomService.this.loadParameters();
                            CustomService.this.getDynamicService().showOverview(CustomService.this.getTblData());
                        }
                    }
                }
            });
        }
        return this.cbMinut;
    }

    private JCheckBox getCbHundreed() {
        if (this.cbHundreed == null) {
            this.cbHundreed = new JCheckBox(LanguageTranslator.getString("generics.hundredth"));
            this.cbHundreed.setEnabled(false);
            this.cbHundreed.setHorizontalAlignment(0);
            this.cbHundreed.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !CustomService.this.isValueAdjusting) {
                        CustomService.this.getCbMinut().setSelected(!CustomService.this.getCbHundreed().isSelected());
                        CustomService.this.getCurrent().updateProperty("RESOLUTION", String.valueOf(0));
                        CustomService.this.getCurrent().setTimeConverter(TimeConverterFactory.getTimeConverter(0));
                        if (CustomService.this.getCbPrint().isSelected()) {
                            CustomService.this.loadParameters();
                            CustomService.this.getDynamicService().showOverview(CustomService.this.getTblData());
                        }
                    }
                }
            });
        }
        return this.cbHundreed;
    }

    private JCheckBox getCbHS() {
        if (this.cbHS == null) {
            this.cbHS = new JCheckBox();
            this.cbHS.setText(LanguageTranslator.getString("generics.HS"));
            this.cbHS.setEnabled(false);
            this.cbHS.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!CustomService.this.isValueAdjusting) {
                        CustomService.this.getCurrent().updateProperty("HS", CustomService.this.getCbHS().isSelected() ? "1" : "0");
                    }
                }
            });
        }
        return this.cbHS;
    }

    private JCheckBox getCbWeekTotal() {
        if (this.cbWeekTotal == null) {
            this.cbWeekTotal = new JCheckBox();
            this.cbWeekTotal.setEnabled(false);
            this.cbWeekTotal.setText(LanguageTranslator.getString("generics.weeklySum"));
            this.cbWeekTotal.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!CustomService.this.isValueAdjusting) {
                        CustomService.this.getCurrent().updateProperty("WEEK_SUBTOTAL", CustomService.this.getCbWeekTotal().isSelected() ? "1" : "0");
                    }
                }
            });
        }
        return this.cbWeekTotal;
    }

    private CustomReport getCurrent() {
        if (this.current == null) {
            this.current = CustomReportFactory.getDriverServiceDefault();
        }
        return this.current;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints19.gridy = 1;
            this.lblFooter = new JLabel();
            this.lblFooter.setText(LanguageTranslator.getString("report.footer"));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridy = 1;
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints18.weightx = 1.0;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.weighty = 1.0;
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.weightx = 1.0;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getJspTable(), gridBagConstraints17);
            this.pnlContent.add((Component)this.getTxtFooter(), gridBagConstraints18);
            this.pnlContent.add((Component)this.lblFooter, gridBagConstraints19);
        }
        return this.pnlContent;
    }

    private JTextField getTxtFooter() {
        if (this.txtFooter == null) {
            this.txtFooter = new JTextField();
        }
        return this.txtFooter;
    }

    private JComboBox getCbTypeExport() {
        if (this.cbTypeExport == null) {
            this.cbTypeExport = new JComboBox();
            this.cbTypeExport.addItem("pdf");
            this.cbTypeExport.addItem("\u00e9cran");
            this.cbTypeExport.addItem("imprimer");
            this.cbTypeExport.addItem("xls");
            String reportOut = UserPreferences.getPreferences("preference.report.out");
            if (reportOut != null) {
                this.cbTypeExport.setSelectedItem(reportOut);
            }
        }
        return this.cbTypeExport;
    }
}

