/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DetailUserConnexion
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlInfos = null;
    private JLabel lblNomUser = null;
    private JLabel lblPrenomUser = null;
    private JTextField txtNom = null;
    private JTextField txtPrenom = null;
    private JTextArea txtAdresse = null;
    private JLabel lblAdresse = null;
    private JTextField txtVille = null;
    private JLabel lblVille = null;
    private JLabel lblTel = null;
    private JTextField txtTel = null;
    private JButton jButton = null;
    private JButton btnChangerMdp = null;
    private JButton btnQuitter = null;
    private JPanel pnlMdp = null;
    private JLabel lblAncienPass = null;
    private JLabel lblNouveauPass = null;
    private JLabel lblConfirmerNouveauPass = null;
    private JPanel pnDroite = null;
    private ConnexionSettings infos = null;
    private JPasswordField txtPassword = null;
    private JPasswordField txtConfirmation = null;
    private JPasswordField txtAncienPassword = null;
    private JTextField txtMail = null;
    private JLabel lblMail = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DetailUserConnexion.dispose()#");
        super.dispose();
    }

    public DetailUserConnexion(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DetailUserConnexion()#");
        this.initialize();
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 600, 400));
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("user.title"));
        this.infos = this.getInfos();
        this.setContentPane(this.getJContentPane());
    }

    private ConnexionSettings getInfos() {
        return ConnexionSettings.getInstance();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 3;
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.weightx = 0.3;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlInfos(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnDroite(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JPanel getPnlInfos() {
        if (this.pnlInfos == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.gridy = 5;
            this.lblMail = new JLabel();
            this.lblMail.setText(LanguageTranslator.getString("generics.mail"));
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridy = 5;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.weighty = 1.0;
            gridBagConstraints23.gridx = 1;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 2;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 4;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.gridy = 4;
            this.lblTel = new JLabel();
            this.lblTel.setText(LanguageTranslator.getString("generics.phone"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridy = 3;
            this.lblVille = new JLabel();
            this.lblVille.setText(LanguageTranslator.getString("generics.city"));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridy = 2;
            this.lblAdresse = new JLabel();
            this.lblAdresse.setText(LanguageTranslator.getString("generics.address"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridy = 1;
            this.lblPrenomUser = new JLabel();
            this.lblPrenomUser.setText(LanguageTranslator.getString("user.firstName"));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 0;
            this.lblNomUser = new JLabel();
            this.lblNomUser.setText(LanguageTranslator.getString("user.lastName"));
            this.pnlInfos = new JPanel();
            this.pnlInfos.setLayout(new GridBagLayout());
            this.pnlInfos.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user.information"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlInfos.add((Component)this.lblNomUser, gridBagConstraints1);
            this.pnlInfos.add((Component)this.lblPrenomUser, gridBagConstraints2);
            this.pnlInfos.add((Component)this.getTxtNom(), gridBagConstraints3);
            this.pnlInfos.add((Component)this.getTxtPrenom(), gridBagConstraints4);
            this.pnlInfos.add((Component)this.lblAdresse, gridBagConstraints6);
            this.pnlInfos.add((Component)this.getTxtVille(), gridBagConstraints7);
            this.pnlInfos.add((Component)this.lblVille, gridBagConstraints8);
            this.pnlInfos.add((Component)this.lblTel, gridBagConstraints9);
            this.pnlInfos.add((Component)this.getTxtTel(), gridBagConstraints10);
            this.pnlInfos.add((Component)this.getTxtAdresse(), gridBagConstraints22);
            this.pnlInfos.add((Component)this.getTxtMail(), gridBagConstraints23);
            this.pnlInfos.add((Component)this.lblMail, gridBagConstraints24);
        }
        return this.pnlInfos;
    }

    private JTextField getTxtNom() {
        if (this.txtNom == null) {
            this.txtNom = new JTextField();
            this.txtNom.setText(this.infos.user.getNom());
        }
        return this.txtNom;
    }

    private JTextField getTxtPrenom() {
        if (this.txtPrenom == null) {
            this.txtPrenom = new JTextField();
            this.txtPrenom.setText(this.infos.user.getPrenom());
        }
        return this.txtPrenom;
    }

    private JTextArea getTxtAdresse() {
        if (this.txtAdresse == null) {
            this.txtAdresse = new JTextArea();
            this.txtAdresse.setText(this.infos.user.getAdresse());
            this.txtAdresse.setLineWrap(true);
            this.txtAdresse.setPreferredSize(new Dimension(0, 16));
            this.txtAdresse.setWrapStyleWord(true);
        }
        return this.txtAdresse;
    }

    private JTextField getTxtVille() {
        if (this.txtVille == null) {
            this.txtVille = new JTextField();
            this.txtVille.setText(this.infos.user.getVille());
        }
        return this.txtVille;
    }

    private JTextField getTxtTel() {
        if (this.txtTel == null) {
            this.txtTel = new JTextField();
            this.txtTel.setText(this.infos.user.getTelephone());
        }
        return this.txtTel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(LanguageTranslator.getString("button.save"));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailUserConnexion.this.enregistrer();
                }
            });
        }
        return this.jButton;
    }

    private JButton getBtnChangerMdp() {
        if (this.btnChangerMdp == null) {
            this.btnChangerMdp = new JButton();
            this.btnChangerMdp.setText(LanguageTranslator.getString("button.changePwd"));
            this.btnChangerMdp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailUserConnexion.this.verifPasse();
                }
            });
        }
        return this.btnChangerMdp;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailUserConnexion.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JPanel getPnlMdp() {
        if (this.pnlMdp == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 2;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.weighty = 1.0;
            gridBagConstraints18.gridx = 1;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridy = 2;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.weighty = 1.0;
            gridBagConstraints20.gridx = 1;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.gridy = 1;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.weighty = 1.0;
            gridBagConstraints19.gridx = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.gridy = 2;
            this.lblConfirmerNouveauPass = new JLabel();
            this.lblConfirmerNouveauPass.setText(LanguageTranslator.getString("user.confirmPwd"));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.weightx = 0.0;
            gridBagConstraints16.gridy = 1;
            this.lblNouveauPass = new JLabel();
            this.lblNouveauPass.setText(LanguageTranslator.getString("user.newPwd"));
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.gridy = 0;
            this.lblAncienPass = new JLabel();
            this.lblAncienPass.setText(LanguageTranslator.getString("user.oldPwd"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.gridy = 3;
            this.pnlMdp = new JPanel();
            this.pnlMdp.setLayout(new GridBagLayout());
            this.pnlMdp.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user.pwdManager"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlMdp.add((Component)this.getBtnChangerMdp(), gridBagConstraints12);
            this.pnlMdp.add((Component)this.lblAncienPass, gridBagConstraints15);
            this.pnlMdp.add((Component)this.lblNouveauPass, gridBagConstraints16);
            this.pnlMdp.add((Component)this.lblConfirmerNouveauPass, gridBagConstraints17);
            this.pnlMdp.add((Component)this.getTxtPassword(), gridBagConstraints19);
            this.pnlMdp.add((Component)this.getTxtConfirmation(), gridBagConstraints20);
            this.pnlMdp.add((Component)this.getTxtAncienPassword(), gridBagConstraints18);
        }
        return this.pnlMdp;
    }

    private JPanel getPnDroite() {
        if (this.pnDroite == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 0;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.anchor = 10;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridx = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 11;
            gridBagConstraints14.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 0.3;
            gridBagConstraints14.weighty = 0.5;
            gridBagConstraints14.fill = 1;
            this.pnDroite = new JPanel();
            this.pnDroite.setLayout(new GridBagLayout());
            this.pnDroite.add((Component)this.getPnlMdp(), gridBagConstraints14);
            this.pnDroite.add((Component)this.getBtnQuitter(), gridBagConstraints13);
            this.pnDroite.add((Component)this.getJButton(), gridBagConstraints11);
        }
        return this.pnDroite;
    }

    public void enregistrer() {
        if (this.infos.user.getCleUser() != 0) {
            this.infos.user.setAdresse(this.getTxtAdresse().getText());
            this.infos.user.setVille(this.getTxtVille().getText());
            this.infos.user.setTelephone(this.getTxtTel().getText());
            this.infos.user.setPrenom(this.getTxtPrenom().getText());
            this.infos.user.setNom(this.getTxtNom().getText());
            this.infos.user.setEmail(this.getTxtMail().getText());
            Transport.bdd.updateUtilisateur(this.infos.user, this.infos.user.getCleUser(), false);
            JOptionPane.showMessageDialog(this, "Utilisateur modifi\u00e9", "Mise \u00e0 jour effectu\u00e9e", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Impossible de modifier ce compte", "Erreur", 0);
        }
    }

    public void verifPasse() {
        if (this.infos.user.getCleUser() == 0) {
            JOptionPane.showMessageDialog(this, "Impossible de modifier ce compte", "Erreur", 0);
            return;
        }
        String pwdSaisi = new String(new StringBuffer().append(this.getTxtAncienPassword().getPassword()).toString());
        if (pwdSaisi.toLowerCase().equals(this.infos.user.getMdp().toLowerCase())) {
            String newPass = new String(new StringBuffer().append(this.getTxtPassword().getPassword()).toString());
            String confirmPass = new String(new StringBuffer().append(this.getTxtConfirmation().getPassword()).toString());
            if (newPass.length() >= 8 || confirmPass.length() >= 8) {
                if (newPass.equals(confirmPass)) {
                    if (this.isAncienPassword(newPass)) {
                        Transport.bdd.updatePassword(this.infos.user, newPass);
                        JOptionPane.showMessageDialog(this, "Mot de passe modifi\u00e9", "Mise \u00e0 jour effectu\u00e9e", 1);
                    } else {
                        JOptionPane.showMessageDialog(this, "Vous devez choisir un mot de passe different", "Erreur", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "La confirmation est diff\u00e9rente du nouveau mot de passe", "Erreur de saisie", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Le mot de passe doit comporter au moins 8 caract\u00e8res", "Erreur de saisie", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Mauvais mot de passe", "Erreur de saisie", 0);
        }
    }

    boolean isAncienPassword(String password) {
        int x = 0;
        while (x < this.infos.user.getPasse().length) {
            if (this.infos.user.getPasse()[x].equals(password)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private JPasswordField getTxtPassword() {
        if (this.txtPassword == null) {
            this.txtPassword = new JPasswordField();
        }
        return this.txtPassword;
    }

    private JPasswordField getTxtConfirmation() {
        if (this.txtConfirmation == null) {
            this.txtConfirmation = new JPasswordField();
        }
        return this.txtConfirmation;
    }

    private JPasswordField getTxtAncienPassword() {
        if (this.txtAncienPassword == null) {
            this.txtAncienPassword = new JPasswordField();
        }
        return this.txtAncienPassword;
    }

    private JTextField getTxtMail() {
        if (this.txtMail == null) {
            this.txtMail = new JTextField();
            this.txtMail.setText(this.infos.user.getEmail());
        }
        return this.txtMail;
    }
}

