/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverAttachment;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.VehicleAttachment;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.modele.TMAttachmentManager;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class DialogAttachmentManager
extends JDialog {
    private static final int NAME_COLUMN = 0;
    private static final int DIR_COLUMN = 1;
    private static final int URL_COLUMN = 2;
    private JTextField txtSearchField = null;
    private JButton btnSearch = null;
    private JTable tblResult = null;
    private JScrollPane jspResult = null;
    private JPanel pnlFilter = null;
    private JCheckBox cbDriver = null;
    private JCheckBox cbVehicle = null;
    private JCheckBox cbIntervention = null;
    private JCheckBox cbObligation = null;
    private JPanel pnlBtn = null;
    private JButton btnExport = null;
    private JButton btnQuit = null;
    private JPanel pnlContent = null;

    public DialogAttachmentManager() {
        this.initialize();
    }

    public DialogAttachmentManager(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(900, 600);
        this.setContentPane(this.getPnlContent());
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel(new GridBagLayout());
            JPanel pnlSearch = new JPanel(new GridBagLayout());
            pnlSearch.add((Component)this.getTxtSearchField(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 5, 0)));
            pnlSearch.add((Component)this.getBtnSearch(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 0)));
            this.pnlContent.add((Component)pnlSearch, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getJspResult(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlContent;
    }

    private JTable getTblResult() {
        if (this.tblResult == null) {
            this.tblResult = new JTable();
        }
        return this.tblResult;
    }

    private JScrollPane getJspResult() {
        if (this.jspResult == null) {
            this.jspResult = new JScrollPane();
            this.jspResult.setViewportView(this.getTblResult());
        }
        return this.jspResult;
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("generics.filter")));
            this.pnlFilter.add(this.getCbDriver());
            this.pnlFilter.add(this.getCbVehicle());
            this.pnlFilter.add(this.getCbObligation());
            this.pnlFilter.add(this.getCbIntervention());
        }
        return this.pnlFilter;
    }

    private JCheckBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = new JCheckBox(LanguageTranslator.getString("generics.driver"));
            this.cbDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.reload();
                }
            });
        }
        return this.cbDriver;
    }

    private JCheckBox getCbVehicle() {
        if (this.cbVehicle == null) {
            this.cbVehicle = new JCheckBox(LanguageTranslator.getString("generics.vehicle"));
            this.cbVehicle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.reload();
                }
            });
        }
        return this.cbVehicle;
    }

    private JCheckBox getCbObligation() {
        if (this.cbObligation == null) {
            this.cbObligation = new JCheckBox(LanguageTranslator.getString("generics.employeeObligation"));
            this.cbObligation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.reload();
                }
            });
        }
        return this.cbObligation;
    }

    private JCheckBox getCbIntervention() {
        if (this.cbIntervention == null) {
            this.cbIntervention = new JCheckBox(LanguageTranslator.getString("generics.intervention"));
            this.cbIntervention.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.reload();
                }
            });
        }
        return this.cbIntervention;
    }

    private JTextField getTxtSearchField() {
        if (this.txtSearchField == null) {
            this.txtSearchField = new JTextField();
        }
        return this.txtSearchField;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnExport());
            this.pnlBtn.add(this.getBtnQuit());
        }
        return this.pnlBtn;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton(LanguageTranslator.getString("button.export"));
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            block5: {
                                try {
                                    GetFile tmp = new GetFile();
                                    SwingUtilities.invokeAndWait(tmp);
                                    if (tmp.getCheminSave() == null) break block5;
                                    ProgressBarIndetermine progres = new ProgressBarIndetermine((Frame)MainFrameTransport.getInstance(), LanguageTranslator.getString("download.copy"));
                                    progres.setVisible(true);
                                    try {
                                        DialogAttachmentManager.this.saveFile(tmp.getCheminSave());
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    progres.dispose();
                                }
                                catch (InvocationTargetException ex) {
                                    ex.printStackTrace();
                                }
                                catch (InterruptedException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }.start();
                }
            });
        }
        return this.btnExport;
    }

    private void saveFile(String saveDir) {
        TMAttachmentManager model = (TMAttachmentManager)this.getTblResult().getModel();
        if (this.getTblResult().getSelectedRows().length != 0) {
            int[] nArray = this.getTblResult().getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int x = nArray[n2];
                String dir = model.getValueAt(x, 1).toString();
                String name = model.getValueAt(x, 0).toString();
                String url = model.getValueAt(x, 2).toString();
                TimsLogger.debug("#DialogAttachmentManager.saveFile# save " + url + " to " + saveDir);
                FileManager.getFile(url, String.valueOf(saveDir) + "\\" + dir + " - " + name);
                ++n2;
            }
        } else {
            int x = 0;
            while (x < this.getTblResult().getRowCount()) {
                String dir = model.getValueAt(x, 1).toString();
                String name = model.getValueAt(x, 0).toString();
                String url = model.getValueAt(x, 2).toString();
                TimsLogger.debug("#DialogAttachmentManager.saveFile# save " + url + " to " + saveDir);
                FileManager.getFile(url, String.valueOf(saveDir) + "\\" + dir + " - " + name);
                ++x;
            }
        }
        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("download.export.succeed"), LanguageTranslator.getString("message.done"), 1);
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe"))));
            this.btnSearch.setPreferredSize(new Dimension(25, 25));
            this.btnSearch.setToolTipText(LanguageTranslator.getString("button.search"));
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAttachmentManager.this.reload();
                }
            });
        }
        return this.btnSearch;
    }

    private void reload() {
        Vehicule vehicle;
        String[] newLine;
        Conducteur driver;
        String rexExp = this.getTxtSearchField().getText();
        Vector<String[]> toShow = new Vector<String[]>();
        if (this.getCbDriver().isSelected()) {
            for (DriverAttachment driverAttachment : DriverAttachment.loadList(rexExp)) {
                try {
                    driver = Conducteur.getDriver(null, driverAttachment.getDriverId());
                    newLine = new String[]{driverAttachment.getDocumentName(), driver.toString(), String.valueOf(FileManager.getFilePath(driver)) + driverAttachment.getDocumentName()};
                    toShow.add(newLine);
                }
                catch (DriverNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getCbVehicle().isSelected()) {
            for (VehicleAttachment vehicleAttachment : VehicleAttachment.loadList(rexExp)) {
                try {
                    vehicle = Vehicule.getVehicule(null, vehicleAttachment.getVehicleId());
                    newLine = new String[]{vehicleAttachment.getDocumentName(), vehicle.toString(), String.valueOf(FileManager.getFilePath(vehicle)) + vehicleAttachment.getDocumentName()};
                    toShow.add(newLine);
                }
                catch (DBObjectNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getCbObligation().isSelected()) {
            for (EmployeeObligation employeeObligation : EmployeeObligation.loadList(this.getTxtSearchField().getText())) {
                try {
                    driver = Conducteur.getDriver(null, employeeObligation.getDriverId());
                    newLine = new String[]{employeeObligation.getAttachment(), driver.toString(), String.valueOf(FileManager.getFilePath(driver)) + employeeObligation.getAttachment()};
                    toShow.add(newLine);
                }
                catch (DriverNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getCbIntervention().isSelected()) {
            for (Intervention intervention : Intervention.loadList(this.getTxtSearchField().getText())) {
                try {
                    vehicle = Vehicule.getVehicule(null, intervention.getVehicleId());
                    newLine = new String[]{intervention.getAttachment(), vehicle.toString(), String.valueOf(FileManager.getFilePath(vehicle)) + intervention.getAttachment()};
                    toShow.add(newLine);
                }
                catch (DBObjectNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        this.getTblResult().setModel(new TMAttachmentManager(toShow));
    }

    class GetFile
    implements Runnable {
        private String cheminSave = null;

        GetFile() {
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser();
            choix.setDialogTitle("o\u00f9 desirez-vous sauvegarger les fichiers ?");
            choix.setFileSelectionMode(1);
            if (choix.showSaveDialog(MainFrameTransport.getInstance()) == 0) {
                this.cheminSave = choix.getSelectedFile().getAbsolutePath();
            }
        }

        public String getCheminSave() {
            return this.cheminSave;
        }
    }
}

