/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogConsumption
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlBtn = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JPanel pnlContent = null;
    private JPanel pnlData = null;
    private JLabel lblAgency = null;
    private JLabel lblDriver = null;
    private JLabel lblVehicle = null;
    private JLabel lblDate = null;
    private JLabel lblKm = null;
    private JLabel lblKmCpt = null;
    private JLabel lblLiters = null;
    private JLabel lblLength = null;
    private JLabel lblConsumption = null;
    private JLabel lblStop = null;
    private JLabel lblStopStrength = null;
    private JLabel lblStopInTraffic = null;
    private JLabel lblLengthBrake = null;
    private JLabel lblRegDelta = null;
    private JLabel lblCo2 = null;
    private JLabel lblTravelNotation = null;
    private JFittedComboBox cbAgency = null;
    private JFittedComboBox cbDriver = null;
    private JFittedComboBox cbVehicle = null;
    private JTextField txtDate = null;
    private JTextHour txtHour = null;
    private JTextField txtKmDone = null;
    private JTextField txtKmCpt = null;
    private JTextField txtLiters = null;
    private JTextHour txtLength = null;
    private JTextField txtConsumption = null;
    private JTextHour txtStop = null;
    private JTextHour txtStopStrength = null;
    private JTextHour txtStopInTraffic = null;
    private JTextField txtLengthBrake = null;
    private JTextField txtRegDelta = null;
    private JTextField txtCo2 = null;
    private JTextField txtTravelNotation = null;
    private FuelConsumption toShow = null;
    DecimalFormat df = new DecimalFormat();

    public DialogConsumption(Frame owner) {
        super(owner);
        this.setModal(true);
        this.df.setMaximumFractionDigits(2);
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(550, 320);
        this.setTitle(LanguageTranslator.getString("generics.consumption"));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlContent(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 1);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnSave(), gridBagConstraints1);
            this.pnlBtn.add((Component)this.getBtnCancel(), gridBagConstraints2);
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setPreferredSize(new Dimension(25, 25));
            this.btnSave.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_valid"))));
            this.btnSave.setToolTipText(LanguageTranslator.getString("button.valid"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogConsumption.this.add()) {
                        DialogConsumption.this.dispose();
                    }
                }
            });
        }
        return this.btnSave;
    }

    public boolean add() {
        int travelNotation;
        boolean toReturn = false;
        if (!this.check()) {
            return false;
        }
        Date date = ConversionTime.stringToDate(this.getTxtDate().getText(), "dd/MM/yyyy");
        int length = ConversionTime.heureStringToInt(this.getTxtLength().getText(), "h");
        Float consumption = Fonctions.parseFloat(this.getTxtConsumption().getText());
        Float liters = Fonctions.parseFloat(this.getTxtLiters().getText());
        Float km = Fonctions.parseFloat(this.getTxtKmDone().getText());
        int kmCpt = this.getTxtKmCpt().getText().equals("") ? 0 : Integer.parseInt(this.getTxtKmCpt().getText());
        int agencyId = ((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle();
        int driverId = ((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle();
        int vehicleId = ((ComboBoxModel)this.getCbVehicle().getModel()).getSelectedCle();
        int stop = ConversionTime.heureStringToInt(this.getTxtStop().getText(), "h");
        int stopStrength = ConversionTime.heureStringToInt(this.getTxtStopStrength().getText(), "h");
        int stopInTraffic = ConversionTime.heureStringToInt(this.getTxtStopInTraffic().getText(), "h");
        Float lengthBrake = Fonctions.parseFloat(this.getTxtLengthBrake().getText());
        int regDelta = this.getTxtRegDelta().getText().equals("") ? 0 : Integer.parseInt(this.getTxtRegDelta().getText());
        int co2 = this.getTxtCo2().getText().equals("") ? 0 : Integer.parseInt(this.getTxtCo2().getText());
        int n = travelNotation = this.getTxtTravelNotation().getText().equals("") ? 0 : Integer.parseInt(this.getTxtTravelNotation().getText());
        if (this.toShow == null) {
            this.toShow = new FuelConsumption(0, agencyId, driverId, vehicleId, date, consumption.floatValue(), liters.floatValue(), length, km.floatValue(), kmCpt, stop, stopStrength, stopInTraffic, lengthBrake.floatValue(), regDelta, co2, travelNotation);
            toReturn = this.toShow.update();
        } else {
            toReturn = this.toShow.compareAndUpdate(agencyId, driverId, vehicleId, date, consumption.floatValue(), liters.floatValue(), length, km.floatValue(), kmCpt, stop, stopStrength, stopInTraffic, lengthBrake.floatValue(), regDelta, co2, travelNotation);
        }
        return toReturn;
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtKmDone().getText().equals("") || !Fonctions.isFloat(this.getTxtKmDone().getText())) {
            this.getTxtKmDone().setBackground(new Color(255, 192, 203));
            if (this.getTxtKmDone().getText().equals("")) {
                this.getTxtKmDone().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else {
                this.getTxtKmDone().setToolTipText(LanguageTranslator.getString("generics.floatNeeded"));
            }
            toReturn = false;
        } else {
            this.getTxtKmDone().setBackground(Color.white);
        }
        if (this.getTxtKmCpt().getText().equals("") || !Fonctions.isInt(this.getTxtKmCpt().getText())) {
            this.getTxtKmCpt().setBackground(new Color(255, 192, 203));
            if (this.getTxtKmCpt().getText().equals("")) {
                this.getTxtKmCpt().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else {
                this.getTxtKmCpt().setToolTipText(LanguageTranslator.getString("generics.intNeeded"));
            }
            toReturn = false;
        } else {
            this.getTxtKmCpt().setBackground(Color.white);
        }
        if (this.getTxtLiters().getText().equals("") || !Fonctions.isFloat(this.getTxtLiters().getText())) {
            this.getTxtLiters().setBackground(new Color(255, 192, 203));
            if (this.getTxtLiters().getText().equals("")) {
                this.getTxtLiters().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else {
                this.getTxtLiters().setToolTipText(LanguageTranslator.getString("generics.floatNeeded"));
            }
            toReturn = false;
        } else {
            this.getTxtLiters().setBackground(Color.white);
        }
        if (this.getTxtConsumption().getText().equals("") || !Fonctions.isFloat(this.getTxtConsumption().getText())) {
            this.getTxtConsumption().setBackground(new Color(255, 192, 203));
            if (this.getTxtConsumption().getText().equals("")) {
                this.getTxtConsumption().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else {
                this.getTxtConsumption().setToolTipText(LanguageTranslator.getString("generics.floatNeeded"));
            }
            toReturn = false;
        } else {
            this.getTxtConsumption().setBackground(Color.white);
        }
        if (this.getTxtDate().getText().equals("")) {
            this.getTxtDate().setBackground(new Color(255, 192, 203));
            this.getTxtDate().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDate().setBackground(Color.white);
        }
        return toReturn;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setPreferredSize(new Dimension(25, 25));
            this.btnCancel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnCancel.setToolTipText(LanguageTranslator.getString("button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumption.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 1;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getPnlData(), gridBagConstraints5);
        }
        return this.pnlContent;
    }

    private JPanel getPnlData() {
        if (this.pnlData == null) {
            this.lblAgency = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblDriver = new JLabel(LanguageTranslator.getString("generics.driver"));
            this.lblVehicle = new JLabel(LanguageTranslator.getString("generics.vehicle"));
            this.lblDate = new JLabel(LanguageTranslator.getString("generics.date"));
            this.lblLength = new JLabel(LanguageTranslator.getString("generics.length"));
            this.lblKm = new JLabel(LanguageTranslator.getString("generics.kmDone"));
            this.lblKmCpt = new JLabel(LanguageTranslator.getString("generics.km.cpt"));
            this.lblLiters = new JLabel(LanguageTranslator.getString("generics.liters"));
            this.lblConsumption = new JLabel(LanguageTranslator.getString("generics.consumption"));
            this.lblStop = new JLabel(LanguageTranslator.getString("generics.stop"));
            this.lblStopStrength = new JLabel(LanguageTranslator.getString("generics.stopStrength"));
            this.lblStopInTraffic = new JLabel(LanguageTranslator.getString("generics.stopInTraffic"));
            this.lblLengthBrake = new JLabel(LanguageTranslator.getString("generics.lengthBrake"));
            this.lblRegDelta = new JLabel(LanguageTranslator.getString("generics.regDelta"));
            this.lblCo2 = new JLabel(LanguageTranslator.getString("generics.co2"));
            this.lblTravelNotation = new JLabel(LanguageTranslator.getString("generics.travelNotation"));
            this.pnlData = new JPanel();
            this.pnlData.setLayout(new GridBagLayout());
            this.pnlData.add((Component)this.lblAgency, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 3)));
            this.pnlData.add((Component)this.getCbAgency(), Fonctions.getGridBagConstraints(1, 0, 1, 5, 0.0, 0.0, 2, 17, new Insets(0, 3, 0, 3)));
            this.pnlData.add((Component)this.lblDriver, Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getCbDriver(), Fonctions.getGridBagConstraints(1, 1, 1, 5, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblVehicle, Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getCbVehicle(), Fonctions.getGridBagConstraints(1, 2, 1, 5, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            JPanel date = new JPanel(new GridBagLayout());
            date.add((Component)this.lblDate, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            date.add(this.getPnlDate(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 13, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)date, Fonctions.getGridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblLength, Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtLength(), Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblLengthBrake, Fonctions.getGridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtLengthBrake(), Fonctions.getGridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblKm, Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtKmDone(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblKmCpt, Fonctions.getGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtKmCpt(), Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblLiters, Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtLiters(), Fonctions.getGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblConsumption, Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtConsumption(), Fonctions.getGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblStop, Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtStop(), Fonctions.getGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblStopStrength, Fonctions.getGridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtStopStrength(), Fonctions.getGridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblStopInTraffic, Fonctions.getGridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtStopInTraffic(), Fonctions.getGridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblRegDelta, Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtRegDelta(), Fonctions.getGridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblCo2, Fonctions.getGridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtCo2(), Fonctions.getGridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.lblTravelNotation, Fonctions.getGridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 3, 0, 3)));
            this.pnlData.add((Component)this.getTxtTravelNotation(), Fonctions.getGridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 2, 17, new Insets(2, 3, 0, 3)));
        }
        return this.pnlData;
    }

    private Component getPnlDate() {
        JPanel pnlDate = new JPanel();
        pnlDate.add(this.getTxtDate());
        pnlDate.add(this.getTxtHour());
        return pnlDate;
    }

    private JTextField getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextField();
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(DialogConsumption.this.getTxtDate())) {
                        DialogConsumption.this.getTxtDate().setBackground(Color.white);
                    }
                }
            });
        }
        return this.txtDate;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour(true);
        }
        return this.txtHour;
    }

    private JTextField getTxtKmDone() {
        if (this.txtKmDone == null) {
            this.txtKmDone = new JTextField();
            this.txtKmDone.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!DialogConsumption.this.getTxtLiters().getText().equals("") && !DialogConsumption.this.getTxtKmDone().getText().equals("") && Fonctions.isFloat(DialogConsumption.this.getTxtLiters().getText()) && Fonctions.isFloat(DialogConsumption.this.getTxtKmDone().getText())) {
                        float liters = Fonctions.parseFloat(DialogConsumption.this.getTxtLiters().getText()).floatValue();
                        float km = Fonctions.parseFloat(DialogConsumption.this.getTxtKmDone().getText()).floatValue();
                        String number = DialogConsumption.this.df.format(liters / km * 100.0f);
                        DialogConsumption.this.getTxtConsumption().setText(number);
                    }
                }
            });
        }
        return this.txtKmDone;
    }

    private JTextField getTxtKmCpt() {
        if (this.txtKmCpt == null) {
            this.txtKmCpt = new JTextField();
        }
        return this.txtKmCpt;
    }

    private JTextField getTxtLiters() {
        if (this.txtLiters == null) {
            this.txtLiters = new JTextField();
            this.txtLiters.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!DialogConsumption.this.getTxtLiters().getText().equals("") && !DialogConsumption.this.getTxtKmDone().getText().equals("") && Fonctions.isFloat(DialogConsumption.this.getTxtLiters().getText()) && Fonctions.isFloat(DialogConsumption.this.getTxtKmDone().getText())) {
                        float liters = Fonctions.parseFloat(DialogConsumption.this.getTxtLiters().getText()).floatValue();
                        float km = Fonctions.parseFloat(DialogConsumption.this.getTxtKmDone().getText()).floatValue();
                        String number = DialogConsumption.this.df.format(liters / km * 100.0f);
                        DialogConsumption.this.getTxtConsumption().setText(number);
                    }
                }
            });
        }
        return this.txtLiters;
    }

    private JTextHour getTxtLength() {
        if (this.txtLength == null) {
            this.txtLength = new JTextHour(false);
        }
        return this.txtLength;
    }

    private JTextHour getTxtStop() {
        if (this.txtStop == null) {
            this.txtStop = new JTextHour();
        }
        return this.txtStop;
    }

    private JTextHour getTxtStopStrength() {
        if (this.txtStopStrength == null) {
            this.txtStopStrength = new JTextHour();
        }
        return this.txtStopStrength;
    }

    private JTextHour getTxtStopInTraffic() {
        if (this.txtStopInTraffic == null) {
            this.txtStopInTraffic = new JTextHour();
        }
        return this.txtStopInTraffic;
    }

    private JTextField getTxtLengthBrake() {
        if (this.txtLengthBrake == null) {
            this.txtLengthBrake = new JTextField();
        }
        return this.txtLengthBrake;
    }

    private JTextField getTxtRegDelta() {
        if (this.txtRegDelta == null) {
            this.txtRegDelta = new JTextField();
        }
        return this.txtRegDelta;
    }

    private JTextField getTxtCo2() {
        if (this.txtCo2 == null) {
            this.txtCo2 = new JTextField();
        }
        return this.txtCo2;
    }

    private JTextField getTxtTravelNotation() {
        if (this.txtTravelNotation == null) {
            this.txtTravelNotation = new JTextField();
        }
        return this.txtTravelNotation;
    }

    private JTextField getTxtConsumption() {
        if (this.txtConsumption == null) {
            this.txtConsumption = new JTextField();
        }
        return this.txtConsumption;
    }

    private JComboBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JFittedComboBox();
            this.cbAgency.setMaxWidth(170);
            this.cbAgency.setModel(new ComboBoxModel(Agence.getList(), true, LanguageTranslator.getString("generics.select")));
            this.cbAgency.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cleAgence = ((ComboBoxModel)DialogConsumption.this.getCbAgency().getModel()).getSelectedCle();
                    DialogConsumption.this.getCbDriver().setModel(new ComboBoxModel(Conducteur.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                    DialogConsumption.this.getCbVehicle().setModel(new ComboBoxModel(Vehicule.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                }
            });
        }
        return this.cbAgency;
    }

    private JComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = new JFittedComboBox();
            this.cbDriver.setMaxWidth(170);
            this.cbDriver.setModel(new ComboBoxModel(Conducteur.getList(), true, LanguageTranslator.getString("generics.select")));
            this.cbDriver.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.cbDriver;
    }

    private JComboBox getCbVehicle() {
        if (this.cbVehicle == null) {
            this.cbVehicle = new JFittedComboBox();
            this.cbVehicle.setMaxWidth(170);
            this.cbVehicle.setModel(new ComboBoxModel(Vehicule.loadList(0), true, LanguageTranslator.getString("generics.select")));
            this.cbVehicle.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.cbVehicle;
    }

    public void setConsumption(FuelConsumption toShow) {
        this.toShow = toShow;
        this.getCbAgency().setSelectedItem(((ComboBoxModel)this.getCbAgency().getModel()).getLabel(toShow.getAgencyId()));
        this.getCbDriver().setSelectedItem(((ComboBoxModel)this.getCbDriver().getModel()).getLabel(toShow.getDriverId()));
        this.getCbVehicle().setSelectedItem(((ComboBoxModel)this.getCbVehicle().getModel()).getLabel(toShow.getVehicleId()));
        this.getTxtDate().setText(ConversionTime.dateToString(toShow.getDate(), "dd/MM/yyyy"));
        int hour = ConversionTime.heureStringToInt(ConversionTime.dateToString(toShow.getDate(), "HH:mm"), ":");
        this.getTxtHour().setHourMinute(hour);
        this.getTxtKmDone().setText(this.df.format(toShow.getKm()));
        this.getTxtKmCpt().setText(String.valueOf(toShow.getKmCpt()));
        this.getTxtLiters().setText(this.df.format(toShow.getLiters()));
        this.getTxtLength().setText(ConversionTime.heureIntToString(toShow.getLength(), "h"));
        this.getTxtConsumption().setText(this.df.format(toShow.getConsumption()));
    }

    public void setDriver(Conducteur current) {
        ((ComboBoxModel)this.getCbAgency().getModel()).setSelected(current.getCleAgence());
        ((ComboBoxModel)this.getCbDriver().getModel()).setSelected(current.getCleConducteur());
    }

    public void setVehicle(Vehicule current) {
        ((ComboBoxModel)this.getCbAgency().getModel()).setSelected(current.getAgencyId());
        ((ComboBoxModel)this.getCbDriver().getModel()).setSelected(current.getId());
    }
}

