/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.TypeActivite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.GraphJour;
import transpo.system.util.Fonctions;

public class DialogCreerJour
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private GraphJour graphJour = null;
    private JPanel pnlRB = null;
    private JTextField txtDebut = null;
    private JLabel lblDebut = null;
    private JLabel lblFin = null;
    private JTextField txtFin = null;
    private Conducteur detailConducteur = null;
    private String dateJour = null;
    private Vector<ActiviteConducteur> detailJournee = null;
    private JTextField txtKm = null;
    private JLabel lblKm = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JList listeActivite = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCreerJour.dispose()#");
        super.dispose();
    }

    public DialogCreerJour(Frame owner, Conducteur detailConducteur, String date) {
        super(owner);
        TimsLogger.verbose("#DialogCreerJour()#");
        this.detailConducteur = detailConducteur;
        this.dateJour = date;
        this.detailJournee = new Vector();
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(659, 246);
        try {
            this.setTitle(LanguageTranslator.getString("day.create.title"));
            this.setContentPane(this.getJContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getGraphJour(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlRB(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private GraphJour getGraphJour() {
        if (this.graphJour == null) {
            this.graphJour = new GraphJour();
            this.graphJour.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int minute = DialogCreerJour.this.getGraphJour().getMinute((int)e.getPoint().getX());
                    if (DialogCreerJour.this.getGraphJour().getActivite((int)e.getPoint().getX()) != null) {
                        DialogCreerJour.this.detailJournee = DialogCreerJour.this.getGraphJour().getActiviteAvant(minute);
                        DialogCreerJour.this.getGraphJour().initialiser(DialogCreerJour.this.detailJournee, 0, 0);
                        DialogCreerJour.this.getTxtDebut().setText(ConversionTime.heureIntToString(((ActiviteConducteur)DialogCreerJour.this.detailJournee.get(DialogCreerJour.this.detailJournee.size() - 1)).getHeureFin(), "h"));
                    } else {
                        DialogCreerJour.this.getTxtFin().setText(ConversionTime.heureIntToString(minute, "h"));
                    }
                }
            });
        }
        return this.graphJour;
    }

    private JPanel getPnlRB() {
        if (this.pnlRB == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.gridy = 3;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 2.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridheight = 4;
            gridBagConstraints13.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(0, 15, 0, 15);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridy = 1;
            this.lblFin = new JLabel();
            this.lblFin.setText(LanguageTranslator.getString("generics.end"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridy = 0;
            this.lblDebut = new JLabel();
            this.lblDebut.setText(LanguageTranslator.getString("generics.begin"));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            this.lblKm = new JLabel();
            this.lblKm.setText(LanguageTranslator.getString("generics.km"));
            this.pnlRB = new JPanel();
            this.pnlRB.setLayout(new GridBagLayout());
            this.pnlRB.add((Component)this.getTxtDebut(), gridBagConstraints3);
            this.pnlRB.add((Component)this.lblDebut, gridBagConstraints4);
            this.pnlRB.add((Component)this.lblFin, gridBagConstraints5);
            this.pnlRB.add((Component)this.getTxtFin(), gridBagConstraints6);
            this.pnlRB.add((Component)this.getListeActivite(), gridBagConstraints13);
            this.pnlRB.add((Component)this.lblKm, gridBagConstraints7);
            this.pnlRB.add((Component)this.getTxtKm(), gridBagConstraints2);
            this.pnlRB.add((Component)this.getBtnQuitter(), gridBagConstraints8);
            this.pnlRB.add((Component)this.getBtnEnregistrer(), gridBagConstraints9);
        }
        return this.pnlRB;
    }

    private JTextField getTxtDebut() {
        if (this.txtDebut == null) {
            this.txtDebut = new JTextField();
            this.txtDebut.setText("00h00");
            this.txtDebut.setEnabled(true);
            this.txtDebut.setEditable(false);
        }
        return this.txtDebut;
    }

    private JTextField getTxtFin() {
        if (this.txtFin == null) {
            this.txtFin = new JTextField();
            this.txtFin.setText("");
            this.txtFin.setPreferredSize(new Dimension(39, 20));
            this.txtFin.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    DialogCreerJour.this.verifSaisie(e, DialogCreerJour.this.txtFin);
                }
            });
            this.txtFin.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DialogCreerJour.this.getTxtFin().setText("");
                }
            });
        }
        return this.txtFin;
    }

    private void addActivite() {
        if (this.getTxtFin().getText().equals("")) {
            this.getTxtFin().setText("24h00");
        }
        if (!this.isValid(this.getTxtFin())) {
            JOptionPane.showMessageDialog(this, "V\u00e9rifier l'heure saisie.", "Erreur", 0);
            return;
        }
        int debut = ConversionTime.heureStringToInt(this.getTxtDebut().getText(), "h");
        int fin = ConversionTime.heureStringToInt(this.getTxtFin().getText(), "h");
        int offset = this.getListeActivite().getSelectedIndex();
        TypeActivite selected = (TypeActivite)((ComboBoxModel)this.getListeActivite().getModel()).getObjectAt(offset);
        ActiviteConducteur toAdd = new ActiviteConducteur(0, this.detailConducteur.getCleConducteur(), this.detailConducteur.getCleAgence(), selected.getCle(), selected.getName(), String.valueOf(selected.getColor()), debut, fin, fin - debut, ConversionTime.dateFromFranceToBDD(this.dateJour, false), "GRAPHE", "", "NON INSEREE", "SEUL", "", 0, 0, 0);
        this.detailJournee.add(toAdd);
        this.getGraphJour().initialiser(this.detailJournee, 0, 0);
        this.getTxtDebut().setText(ConversionTime.heureIntToString(toAdd.getHeureFin(), "h"));
        if (fin == 1440) {
            this.getBtnEnregistrer().setEnabled(true);
        } else {
            this.getTxtFin().setText("24h");
        }
    }

    public boolean isValid(JTextField heure) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            if (heure != null && heure.getText().length() == 3) {
                                heure.setText(String.valueOf(heure.getText()) + "00");
                            }
                            if (heure != null && heure.getText().length() == 5) break block7;
                            return false;
                        }
                        catch (NumberFormatException ex) {
                            TimsLogger.warn("#DialogCreerJour# format incorrect " + ex.getMessage());
                            return false;
                        }
                    }
                    if (Integer.parseInt(heure.getText().substring(0, 2)) <= 24) break block8;
                    return false;
                }
                if (Integer.parseInt(heure.getText().substring(3, 5)) <= 60) break block9;
                return false;
            }
            if (Integer.parseInt(heure.getText().substring(0, 2)) >= Integer.parseInt(this.getTxtDebut().getText().substring(0, 2))) break block10;
            return false;
        }
        return Integer.parseInt(heure.getText().substring(0, 2)) != Integer.parseInt(this.getTxtDebut().getText().substring(0, 2)) || Integer.parseInt(heure.getText().substring(3, 5)) > Integer.parseInt(this.getTxtDebut().getText().substring(3, 5));
    }

    private void verifSaisie(KeyEvent e, JTextField txt) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyCode == 8 || keyCode == 20 || keyCode == 16) {
            return;
        }
        if (txt.getText().length() == 1) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText("");
            }
        } else if (txt.getText().length() == 2) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText("0" + txt.getText().substring(0, 1) + "h");
            } else {
                txt.setText(String.valueOf(txt.getText()) + "h");
            }
        } else if (txt.getText().length() == 3) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(String.valueOf(txt.getText().substring(0, 2)) + "h");
            } else {
                txt.setText(String.valueOf(txt.getText().substring(0, 2)) + "h" + txt.getText().substring(2));
            }
        } else if (txt.getText().length() == 4) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(txt.getText().substring(0, 3));
            }
        } else if (txt.getText().length() == 5) {
            if (keyChar < '0' || keyChar > '9') {
                txt.setText(txt.getText().substring(0, 4));
            }
        } else if (txt.getText().length() >= 6) {
            txt.setText(txt.getText().substring(0, 5));
        }
    }

    private JTextField getTxtKm() {
        if (this.txtKm == null) {
            this.txtKm = new JTextField();
            this.txtKm.setText("0");
            this.txtKm.setPreferredSize(new Dimension(39, 20));
        }
        return this.txtKm;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.setEnabled(false);
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreerJour.this.enregistrer();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void enregistrer() {
        if (Fonctions.saveDriverActivities(this.detailJournee, this.detailConducteur, Integer.parseInt(this.getTxtKm().getText()), null) != 2) {
            JOptionPane.showMessageDialog(this, "Erreur d'enregistrement", "Journ\u00e9e non ajout\u00e9e", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Enregistrement effectu\u00e9", "Journ\u00e9e ajout\u00e9e", 1);
        }
        this.dispose();
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCreerJour.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JList getListeActivite() {
        if (this.listeActivite == null) {
            this.listeActivite = new JList();
            this.listeActivite.setSelectionMode(0);
            this.getListeActivite().setModel(new ComboBoxModel(TypeActivite.getList(), true, null));
            this.listeActivite.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogCreerJour.this.listeActivite.getSelectedIndex() != -1) {
                        DialogCreerJour.this.addActivite();
                        DialogCreerJour.this.listeActivite.clearSelection();
                    }
                }
            });
        }
        return this.listeActivite;
    }
}

