/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.JPanelButton;
import fr.pgh.component.JTextDate;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import transpo.system.Transport;
import transpo.system.controller.DataRetrieverController;
import transpo.system.ui.modele.TMAgencyOffence;
import transpo.system.ui.modele.TMCardFile;
import transpo.system.ui.modele.TMDriverMissingActivity;
import transpo.system.ui.modele.TMUevFile;
import transpo.system.ui.modele.TMVuMissingActivity;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.viewable.ProgressViewManager;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;

public class DialogDataRetriever
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel pnlContent = null;
    JTabbedPane pnlMain = null;
    JPanel pnlOverview = null;
    JPanel pnlAnomaly = null;
    JPanel pnlOffence = null;
    JPanelButton pnlBtn = null;
    JPanel pnlFilter = null;
    JTextDate txtBegin = null;
    JTextDate txtEnd = null;
    JTextField txtName = null;
    JScrollPane jspCard = null;
    JScrollPane jspUev = null;
    JTable tblCard = null;
    JTable tblUev = null;
    JMultiListBox mbAgency = null;
    JScrollPane jspDA = null;
    JScrollPane jspVA = null;
    JTable tblVehicleAnomaly = null;
    JTable tblDriverAnomaly = null;
    JScrollPane jspDO = null;
    JScrollPane jspVO = null;
    JTable tblVehicleOffence = null;
    JTable tblDriverOffence = null;
    JList<?> saved = null;
    JButton btnFilter = null;
    JButton btnNew = null;
    JButton btnLoad = null;
    JButton btnSave = null;
    JButton btnArchive = null;
    JButton btnQuit = null;
    boolean hasChanged = false;
    private DataRetrieverController controller = null;
    private ProgressViewManager pgBar = null;

    @Override
    public void dispose() {
        super.dispose();
    }

    public DialogDataRetriever(JFrame f) {
        super(f);
        this.setTitle(LanguageTranslator.getString("data.retriever"));
        this.setLocation(50, 50);
        this.setSize(900, 600);
        this.add(this.getPnlContent());
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    public ProgressViewManager getProgression() {
        if (this.pgBar == null) {
            this.pgBar = new ProgressViewManager(new ProgressBar(this, "Controle..."));
        }
        return this.pgBar;
    }

    public JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getPnlFilter(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(1, 2, 1, 2)));
            this.pnlContent.add((Component)this.getPnlMain(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, new Insets(1, 2, 1, 2)));
            this.pnlContent.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
        }
        return this.pnlContent;
    }

    public JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.name")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)this.getTxtName(), Fonctions.getGridBagConstraints(1, 0, 1, 5, 0.0, 0.0, 2, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.from")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.to")), Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)this.getTxtEnd(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)new JLabel(LanguageTranslator.getString("generics.agency")), Fonctions.getGridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 0, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)this.getMbAgency(), Fonctions.getGridBagConstraints(5, 1, 1, 1, 0.0, 1.0, 2, -1, new Insets(1, 2, 1, 2)));
            this.pnlFilter.add((Component)this.getBtnFilter(), Fonctions.getGridBagConstraints(6, 0, 2, 1, 0.0, 1.0, 2, -1, new Insets(1, 2, 1, 2)));
        }
        return this.pnlFilter;
    }

    public JTabbedPane getPnlMain() {
        if (this.pnlMain == null) {
            this.pnlMain = new JTabbedPane();
            this.pnlMain.addTab("Fichiers", this.getPnlOverview());
            this.pnlMain.addTab("Trous d'activit\u00e9s", this.getPnlAnomaly());
            this.pnlMain.addTab("Infractions", this.getPnlOffence());
        }
        return this.pnlMain;
    }

    private JPanel getPnlOverview() {
        if (this.pnlOverview == null) {
            this.pnlOverview = new JPanel();
            this.pnlOverview.setLayout(new GridBagLayout());
            this.pnlOverview.add((Component)this.getJspCard(), Fonctions.getGridBagConstraints(0, 0));
            this.pnlOverview.add((Component)this.getJspUev(), Fonctions.getGridBagConstraints(1, 0));
        }
        return this.pnlOverview;
    }

    private JScrollPane getJspCard() {
        if (this.jspCard == null) {
            this.jspCard = new JScrollPane();
            this.jspCard.setViewportView(this.getTblCard());
        }
        return this.jspCard;
    }

    private JTable getTblCard() {
        if (this.tblCard == null) {
            this.tblCard = new JTable();
            this.tblCard.setRowHeight(20);
        }
        return this.tblCard;
    }

    private JScrollPane getJspUev() {
        if (this.jspUev == null) {
            this.jspUev = new JScrollPane();
            this.jspUev.setViewportView(this.getTblUev());
        }
        return this.jspUev;
    }

    private JTable getTblUev() {
        if (this.tblUev == null) {
            this.tblUev = new JTable();
            this.tblUev.setRowHeight(20);
        }
        return this.tblUev;
    }

    private JPanel getPnlAnomaly() {
        if (this.pnlAnomaly == null) {
            this.pnlAnomaly = new JPanel();
            this.pnlAnomaly.setLayout(new GridBagLayout());
            this.pnlAnomaly.add((Component)this.getJspDriverAnomaly(), Fonctions.getGridBagConstraints(0, 0));
            this.pnlAnomaly.add((Component)this.getJspVehicleAnomaly(), Fonctions.getGridBagConstraints(1, 0));
        }
        return this.pnlAnomaly;
    }

    private JScrollPane getJspDriverAnomaly() {
        if (this.jspDA == null) {
            this.jspDA = new JScrollPane();
            this.jspDA.setViewportView(this.getTblDriverAnomaly());
        }
        return this.jspDA;
    }

    private JTable getTblDriverAnomaly() {
        if (this.tblDriverAnomaly == null) {
            this.tblDriverAnomaly = new JTable();
            this.tblDriverAnomaly.setRowHeight(20);
        }
        return this.tblDriverAnomaly;
    }

    private JScrollPane getJspVehicleAnomaly() {
        if (this.jspVA == null) {
            this.jspVA = new JScrollPane();
            this.jspVA.setViewportView(this.getTblVehicleAnomaly());
        }
        return this.jspVA;
    }

    private JTable getTblVehicleAnomaly() {
        if (this.tblVehicleAnomaly == null) {
            this.tblVehicleAnomaly = new JTable();
            this.tblVehicleAnomaly.setRowHeight(20);
        }
        return this.tblVehicleAnomaly;
    }

    private JPanel getPnlOffence() {
        if (this.pnlOffence == null) {
            this.pnlOffence = new JPanel();
            this.pnlOffence.setLayout(new GridBagLayout());
            this.pnlOffence.add((Component)this.getJspDriverOffence(), Fonctions.getGridBagConstraints(0, 0));
            this.pnlOffence.add((Component)this.getJspVehicleOffence(), Fonctions.getGridBagConstraints(1, 0));
        }
        return this.pnlOffence;
    }

    private JScrollPane getJspDriverOffence() {
        if (this.jspDO == null) {
            this.jspDO = new JScrollPane();
            this.jspDO.setViewportView(this.getTblDriverOffence());
        }
        return this.jspDO;
    }

    private JTable getTblDriverOffence() {
        if (this.tblDriverOffence == null) {
            this.tblDriverOffence = new JTable();
            this.tblDriverOffence.setRowHeight(20);
        }
        return this.tblDriverOffence;
    }

    private JScrollPane getJspVehicleOffence() {
        if (this.jspVO == null) {
            this.jspVO = new JScrollPane();
            this.jspVO.setViewportView(this.getTblVehicleOffence());
        }
        return this.jspVO;
    }

    private JTable getTblVehicleOffence() {
        if (this.tblVehicleOffence == null) {
            this.tblVehicleOffence = new JTable();
            this.tblVehicleOffence.setRowHeight(20);
        }
        return this.tblVehicleOffence;
    }

    public JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnNew(), this.getBtnLoad(), this.getBtnSave(), this.getBtnQuit());
        }
        return this.pnlBtn;
    }

    private JButton getBtnFilter() {
        if (this.btnFilter == null) {
            this.btnFilter = new JButton();
            this.btnFilter.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnFilter.setPreferredSize(new Dimension(50, 50));
            this.btnFilter.setToolTipText(LanguageTranslator.getString("button.filter"));
            this.btnFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDataRetriever.this.doAnalyze();
                }
            });
        }
        return this.btnFilter;
    }

    private void doAnalyze() {
        this.controller = new DataRetrieverController(this.getProgression());
        this.controller.analyze(ConversionTime.stringToDateFr(this.getTxtBegin().getText()), ConversionTime.addDay(ConversionTime.stringToDateFr(this.getTxtEnd().getText()), 1), new ArrayList<Agence>(this.getMbAgency().getSelectedItems()));
        this.getTblCard().setModel(new TMCardFile(this.controller.getCurrent().getCardFiles()));
        this.getTblUev().setModel(new TMUevFile(this.controller.getCurrent().getVuFiles()));
        this.getTblVehicleAnomaly().setModel(new TMVuMissingActivity(this.controller.getCurrent().getVuMissingActivities()));
        this.getTblDriverAnomaly().setModel(new TMDriverMissingActivity(this.controller.getCurrent().getDriverMissingActivities()));
        this.getTblDriverOffence().setModel(new TMAgencyOffence(this.controller.getCurrent().getDriverOffences(), this.controller.getDrivers()));
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnNew.setPreferredSize(new Dimension(50, 50));
            this.btnNew.setToolTipText(LanguageTranslator.getString("button.add"));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnLoad() {
        if (this.btnLoad == null) {
            this.btnLoad = new JButton();
            this.btnLoad.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnLoad.setPreferredSize(new Dimension(50, 50));
            this.btnLoad.setToolTipText(LanguageTranslator.getString("button.load"));
            this.btnLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnLoad;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_save"))));
            this.btnSave.setPreferredSize(new Dimension(50, 50));
            this.btnSave.setToolTipText(LanguageTranslator.getString("button.export"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_sup"))));
            this.btnQuit.setPreferredSize(new Dimension(50, 50));
            this.btnQuit.setToolTipText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnQuit;
    }

    public JTextDate getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextDate();
        }
        return this.txtBegin;
    }

    public JTextDate getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextDate();
        }
        return this.txtEnd;
    }

    public JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    public JMultiListBox getMbAgency() {
        if (this.mbAgency == null) {
            this.mbAgency = new JMultiListBox<Agence>(Agence.getList(), true);
        }
        return this.mbAgency;
    }
}

