/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogExportError
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private HashMap<Conducteur, ArrayList<Date>> datas = null;
    private JScrollPane jspList = null;
    private JList listDriver = null;
    private JScrollPane jspDate = null;
    private JList listDate = null;
    private JLabel lblError = null;
    private JButton btnOk = null;

    public DialogExportError(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 400);
        this.setTitle(LanguageTranslator.getString("payPeriod.missingDay"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
    }

    public void setDatas(HashMap<Conducteur, ArrayList<Date>> datas) {
        this.datas = datas;
        this.listDriver.setListData(new Vector<Conducteur>(datas.keySet()));
        this.lblError.setText(LanguageTranslator.getString("payPeriod.driverErrors", String.valueOf(datas.size())));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(4, 2, 5, 4);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(4, 3, 5, 2);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.lblError = new JLabel();
            if (this.datas != null) {
                this.lblError.setText(LanguageTranslator.getString("payPeriod.driverErrors", String.valueOf(this.datas.size())));
            }
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblError, gridBagConstraints);
            this.jContentPane.add((Component)this.getJspDate(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJspList(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getBtnOk(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getListDriver());
        }
        return this.jspList;
    }

    private JList getListDriver() {
        if (this.listDriver == null) {
            this.listDriver = new JList();
            this.listDriver.setSelectionMode(0);
            this.listDriver.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Conducteur key = (Conducteur)DialogExportError.this.getListDriver().getModel().getElementAt(DialogExportError.this.getListDriver().getSelectedIndex());
                    DialogExportError.this.getListDate().setModel(new TableModelDate((ArrayList)DialogExportError.this.datas.get(key)));
                    DialogExportError.this.getListDate().repaint();
                }
            });
            if (this.datas != null) {
                this.listDriver.setListData(new Vector<Conducteur>(this.datas.keySet()));
            }
        }
        return this.listDriver;
    }

    private JScrollPane getJspDate() {
        if (this.jspDate == null) {
            this.jspDate = new JScrollPane();
            this.jspDate.setViewportView(this.getListDate());
        }
        return this.jspDate;
    }

    private JList getListDate() {
        if (this.listDate == null) {
            this.listDate = new JList();
        }
        return this.listDate;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExportError.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private class TableModelDate
    extends DefaultListModel {
        public TableModelDate(ArrayList<Date> data) {
            for (Date tmp : data) {
                this.addElement(tmp);
            }
        }

        @Override
        public Object getElementAt(int index) {
            return ConversionTime.dateToString((Date)this.get(index), "dd/MM/yyyy");
        }
    }
}

